/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryUtils;
import com.ibm.ws.rest.api.discovery.APIDocPublisher;
import com.ibm.ws.rest.api.discovery.CustomCSSWABUpdater;
import com.ibm.ws.rest.api.discovery.SwaggerWebProvider;
import com.ibm.ws.rest.api.discovery.internal.CustomCSSProcessor;
import com.ibm.ws.rest.api.discovery.internal.config.APIDiscoveryWebModuleDoc;
import com.ibm.ws.rest.api.discovery.internal.config.APIDiscoveryWebModuleDocListener;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import v2.io.swagger.models.Info;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.SwaggerException;
import v2.io.swagger.models.SwaggerUtils;
import v2.io.swagger.parser.SwaggerParser;
import v2.io.swagger.util.Json;
import v2.io.swagger.util.Yaml;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIProviderAggregator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class APIProviderAggregator
implements APIDiscoveryWebModuleDocListener {
    private static final TraceComponent tc = Tr.register(APIProviderAggregator.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    static final String SWAGGER_BASE_INFO_TITLE = "Liberty REST APIs";
    static final String SWAGGER_BASE_INFO_DESCRIPTION = "Discover REST APIs available within Liberty";
    static final String SWAGGER_BASE_INFO_VERSION = "1.0.0";
    static final String SWAGGER_VERSION_2_0 = "2.0";
    private static final String HTTP_HEADER_REFERER = "Referer";
    public static final String IBM_HTTP_PORT_EXTENSION_KEY = "x-ibm-httpPort";
    public static final String IBM_HTTPS_PORT_EXTENSION_KEY = "x-ibm-httpsPort";
    public static final String IBM_SERVICES_EXTENSION_KEY = "x-ibm-services";
    private String hostPort = null;
    private int httpsPort = -1;
    private int httpPort = -1;
    private String apiName = null;
    private String swaggerDefinitionLocation = null;
    private Swagger swaggerDefinition = null;
    private boolean isSwaggerDefinitionSet;
    private String publicURL;
    ArrayList<APIProvider> delayedAction = new ArrayList();
    private boolean serverStartedPhase2Called = false;
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final Map<APIProvider, Map<String, Set<String>>> refToAddedItems = new HashMap<APIProvider, Map<String, Set<String>>>();
    private final Set<APIDocPublisher> apiDocPublishers = new CopyOnWriteArraySet<APIDocPublisher>();
    private final Set<APIProvider> pendingApiProviders = Collections.synchronizedSet(new HashSet());
    private final Set<SwaggerWebProvider> swaggerDefinitionProviders = Collections.synchronizedSet(new HashSet());
    private volatile boolean isLazilyProcessingProviders = true;
    private volatile CustomCSSProcessor customCSSProcessor;
    private WsLocationAdmin locationAdminProvider;
    static ConcurrentHashMap<String, APIDiscoveryWebModuleDoc> webModuleDocsConfig = new ConcurrentHashMap();
    static ConcurrentHashMap<String, APIProvider> apiProviders = new ConcurrentHashMap();
    private static final Set<String> contextRootsToIgnore = new HashSet<String>();
    private static final Set<String> nonPublicRoots;
    private volatile Swagger primarySwagger;
    static final long serialVersionUID = 7031223867829220700L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.executorServiceRef.activate(context);
        this.initPrimarySwagger();
        APIDiscoveryWebModuleDoc.addListener(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating APIProviderAggregator", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.executorServiceRef.deactivate(context);
        this.primarySwagger = null;
        this.hostPort = null;
        this.httpPort = -1;
        this.httpsPort = -1;
        this.refToAddedItems.clear();
        APIDiscoveryWebModuleDoc.removeListener(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating APIProviderAggregator, reason=" + reason), (Object[])new Object[0]);
        }
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDocumentation(APIProvider.DocType docType, Set<String> roots, boolean compact, boolean displayPorts, RESTRequest request, RESTResponse response) throws IOException {
        if (docType == APIProvider.DocType.Swagger_20_JSON || docType == APIProvider.DocType.Swagger_20_YAML) {
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                this.processPendingApiProviders();
                if (roots == null || roots.isEmpty()) {
                    Map<String, Object> oldValues = this.setDynamicHostInfo(request, this.primarySwagger);
                    APIProviderAggregator.writeSwaggerToResponse(this.primarySwagger, response, docType, compact, displayPorts, "no filtering", tc, this);
                    this.resetDynamicHostInfo(this.primarySwagger, oldValues);
                } else {
                    Swagger filteredSwagger = APIProviderAggregator.filterByRoots(this.primarySwagger, roots, true, tc, this);
                    Map<String, Object> oldValues = this.setDynamicHostInfo(request, filteredSwagger);
                    APIProviderAggregator.writeSwaggerToResponse(filteredSwagger, response, docType, compact, displayPorts, "filterByRoots - filteredRoots", tc, this);
                    this.resetDynamicHostInfo(filteredSwagger, oldValues);
                }
                return;
            }
        }
        response.sendError(415);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPublicDocumentation(APIProvider.DocType docType, Set<String> roots, boolean compact, boolean displayPorts, RESTRequest request, RESTResponse response) throws IOException {
        if (docType == APIProvider.DocType.Swagger_20_JSON || docType == APIProvider.DocType.Swagger_20_YAML) {
            if (this.primarySwagger != null) {
                Swagger swagger = this.primarySwagger;
                synchronized (swagger) {
                    this.processPendingApiProviders();
                    HashSet<String> rootsToFilter = new HashSet<String>();
                    rootsToFilter.addAll(contextRootsToIgnore);
                    rootsToFilter.addAll(nonPublicRoots);
                    Swagger filteredSwagger = APIProviderAggregator.filterByRoots(this.primarySwagger, rootsToFilter, false, tc, this);
                    if (roots != null && !roots.isEmpty()) {
                        filteredSwagger = APIProviderAggregator.filterByRoots(filteredSwagger, roots, true, tc, this);
                    }
                    Map<String, Object> oldValues = this.setDynamicHostInfo(request, filteredSwagger);
                    APIProviderAggregator.writeSwaggerToResponse(filteredSwagger, response, docType, compact, displayPorts, "publicFilterByRoots - filteredRoots", tc, this);
                    this.resetDynamicHostInfo(filteredSwagger, oldValues);
                    return true;
                }
            }
        } else {
            response.sendError(415);
            return true;
        }
        return false;
    }

    public static Swagger filterOutDefaultContextRootsToIgnore(Swagger swagger, TraceComponent tc, Object obj) {
        return APIProviderAggregator.filterByRoots(swagger, contextRootsToIgnore, false, tc, obj);
    }

    public static Swagger filterByRoots(Swagger swagger, Set<String> roots, boolean allowListFiltering, TraceComponent tc, Object obj) {
        Swagger filteredSwagger;
        String hostPort = swagger.getHost();
        if (swagger.getVendorExtensions().containsKey(IBM_HTTP_PORT_EXTENSION_KEY) && swagger.getVendorExtensions().containsKey(IBM_HTTPS_PORT_EXTENSION_KEY)) {
            int httpPort = APIDiscoveryUtils.getPortFromVendorExtensions(swagger, IBM_HTTP_PORT_EXTENSION_KEY);
            int httpsPort = APIDiscoveryUtils.getPortFromVendorExtensions(swagger, IBM_HTTPS_PORT_EXTENSION_KEY);
            filteredSwagger = APIProviderAggregator.getSwaggerBase(hostPort, httpPort, httpsPort);
        } else {
            filteredSwagger = APIProviderAggregator.getSwaggerBase(hostPort);
        }
        filteredSwagger.setInfo(swagger.getInfo());
        filteredSwagger.setConsumes(swagger.getConsumes());
        filteredSwagger.setProduces(swagger.getProduces());
        filteredSwagger.setSchemes(swagger.getSchemes());
        filteredSwagger.setExternalDocs(swagger.getExternalDocs());
        filteredSwagger.setBasePath(swagger.getBasePath());
        for (Map.Entry veEntry : swagger.getVendorExtensions().entrySet()) {
            filteredSwagger.setVendorExtension((String)veEntry.getKey(), veEntry.getValue());
        }
        if (roots == null || roots.isEmpty()) {
            return allowListFiltering ? filteredSwagger : swagger;
        }
        Map paths = swagger.getPaths();
        if (paths == null || paths.isEmpty()) {
            return filteredSwagger;
        }
        HashSet<String> filteredPaths = new HashSet<String>();
        HashSet usedReferences = new HashSet();
        for (String pathName : paths.keySet()) {
            int index;
            if (pathName == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)obj, (TraceComponent)tc, (String)"pathName is null", (Object[])new Object[0]);
                continue;
            }
            String pathToCompare = pathName;
            if (pathToCompare.startsWith("/") && pathToCompare.length() > 1 && (index = pathToCompare.substring(1).indexOf("/")) != -1 && pathToCompare.substring(1, index).contains(":")) {
                pathToCompare = pathToCompare.substring(index + 1);
            }
            boolean foundMatch = false;
            for (String root : roots) {
                if (!pathToCompare.startsWith(root)) continue;
                if (allowListFiltering) {
                    foundMatch = true;
                    break;
                }
                if (!pathToCompare.equals(root) && !pathToCompare.startsWith(root + "/")) continue;
                foundMatch = true;
                break;
            }
            if ((!allowListFiltering || !foundMatch) && (allowListFiltering || foundMatch)) continue;
            Path aPath = (Path)paths.get(pathName);
            filteredPaths.add(pathName);
            usedReferences.addAll(aPath.retrieveReferences());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)obj, (TraceComponent)tc, (String)("filteredPaths=" + filteredPaths + " : \n usedReferences=" + usedReferences), (Object[])new Object[0]);
        }
        Map itemsToAdd = SwaggerUtils.determineSwaggerItemsToAdd(usedReferences);
        itemsToAdd.put("paths", filteredPaths);
        filteredSwagger.addItems(swagger, itemsToAdd);
        return filteredSwagger;
    }

    public synchronized void initPrimarySwagger() {
        if (this.primarySwagger == null) {
            this.primarySwagger = APIProviderAggregator.getSwaggerBase(this.hostPort, this.httpPort, this.httpsPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        ArrayList<APIProvider> arrayList = this.delayedAction;
        synchronized (arrayList) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("setServerStartedPhase2 entered. number of actions to go through: " + this.delayedAction.size()), (Object[])new Object[0]);
            }
            Iterator<APIProvider> actionList = this.delayedAction.iterator();
            while (actionList.hasNext()) {
                this.setApiProviderAction(actionList.next());
                actionList.remove();
            }
            this.serverStartedPhase2Called = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        ArrayList<APIProvider> arrayList = this.delayedAction;
        synchronized (arrayList) {
            this.serverStartedPhase2Called = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=APIProvider.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setApiProvider(APIProvider apiProvider) {
        ArrayList<APIProvider> arrayList = this.delayedAction;
        synchronized (arrayList) {
            if (!this.serverStartedPhase2Called) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"setApiProvider adding an action", (Object[])new Object[0]);
                }
                this.delayedAction.add(apiProvider);
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setApiProvider work on an action", (Object[])new Object[0]);
        }
        this.setApiProviderAction(apiProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setApiProviderAction(APIProvider apiProvider) {
        if (this.primarySwagger == null) {
            this.initPrimarySwagger();
        }
        Swagger swagger = this.primarySwagger;
        synchronized (swagger) {
            Set<APIProvider> set = this.pendingApiProviders;
            synchronized (set) {
                if (this.isLazilyProcessingProviders) {
                    if (apiProvider instanceof SwaggerWebProvider) {
                        if (this.isSwaggerDefinitionSet) {
                            SwaggerWebProvider swp = (SwaggerWebProvider)apiProvider;
                            if (swp.getContextRoot().equals(this.swaggerDefinitionLocation)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Processing " + apiProvider + " instantly becasue it matches swagger definition root"), (Object[])new Object[0]);
                                }
                                this.processApiProvider(apiProvider, true);
                                return;
                            }
                        } else if (this.swaggerDefinitionProviders.size() < 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("Processing " + apiProvider + " instantly for optimized case"), (Object[])new Object[0]);
                            }
                            this.processApiProvider(apiProvider, true);
                            return;
                        }
                        this.pendingApiProviders.add(apiProvider);
                        return;
                    }
                    this.pendingApiProviders.add(apiProvider);
                    return;
                }
            }
            this.processApiProvider(apiProvider, true);
        }
    }

    protected void unsetApiProvider(APIProvider apiProvider) {
        String contextRoot;
        this.processRemoveApiProvider(apiProvider);
        if (!(apiProvider instanceof SwaggerWebProvider) && (contextRoot = this.getContextRoot(apiProvider)) != null) {
            apiProviders.remove(contextRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveApiProvider(APIProvider apiProvider) {
        if (this.primarySwagger != null) {
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                if (!this.pendingApiProviders.remove(apiProvider)) {
                    if (apiProvider instanceof SwaggerWebProvider) {
                        this.removeSwaggerDefinitionProvider((SwaggerWebProvider)apiProvider);
                    }
                    this.primarySwagger.removeItems(this.refToAddedItems.remove(apiProvider));
                    this.publishDoc(this.primarySwagger);
                }
            }
        } else {
            this.pendingApiProviders.remove(apiProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSwaggerDefinitionProvider(SwaggerWebProvider swProvider) {
        nonPublicRoots.remove(swProvider.getContextRoot());
        Set<SwaggerWebProvider> set = this.swaggerDefinitionProviders;
        synchronized (set) {
            if (this.pendingApiProviders.size() > 0) {
                Iterator<APIProvider> it = this.pendingApiProviders.iterator();
                while (it.hasNext()) {
                    APIProvider ap = it.next();
                    if (!(ap instanceof SwaggerWebProvider)) continue;
                    this.processApiProvider(ap, true);
                    it.remove();
                    break;
                }
            }
            this.swaggerDefinitionProviders.remove(swProvider);
            if (this.isSwaggerDefinitionSet) {
                if (this.swaggerDefinitionLocation != null && this.swaggerDefinitionLocation.equals(swProvider.getContextRoot())) {
                    this.pushDefaultSwaggerDefinition();
                }
            } else if (this.swaggerDefinitionProviders.size() == 1) {
                this.pushSwaggerDefinition(this.getSwaggerFromSwaggerWebProvider(this.swaggerDefinitionProviders.iterator().next()));
            } else if (this.swaggerDefinitionProviders.size() == 0) {
                this.pushDefaultSwaggerDefinition();
            }
        }
        List serverContextRoots = (List)this.primarySwagger.getVendorExtensions().get(IBM_SERVICES_EXTENSION_KEY);
        if (serverContextRoots != null) {
            serverContextRoots.remove(swProvider.getContextRoot());
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SwaggerException.class})
    private String getContextRoot(APIProvider apiProvider) {
        boolean isEventEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
        APIProvider.DocType docType = APIProvider.DocType.Swagger_20_JSON;
        String doc = apiProvider.getDocument(docType);
        if (doc == null || doc.trim().isEmpty()) {
            if (isEventEnabled) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document is null/empty for APIProvider: " + apiProvider + " : \n doc:" + doc), (Object[])new Object[0]);
            }
            docType = APIProvider.DocType.Swagger_20_YAML;
            doc = apiProvider.getDocument(docType);
        }
        try {
            Swagger s = APIProviderAggregator.getSwaggerDoc(doc, null, null, tc, null);
            if (s != null) {
                if (isEventEnabled) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Obtained swagger with base path:" + s.getBasePath()), (Object[])new Object[0]);
                }
                return s.getBasePath();
            }
        }
        catch (SwaggerException se) {
            if (isEventEnabled) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("SwaggerException occurred while trying to create Swagger object for APIProvider: " + apiProvider + " \n from document: " + doc + " : \n exception: " + (Object)((Object)se)), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"SWAGGER_NOT_CREATED", (Object[])new Object[]{apiProvider, docType, ((Object)((Object)se)).getClass(), se.getMessage()});
        }
        catch (Exception se) {
            void e;
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"575", (Object)this, (Object[])new Object[]{apiProvider});
            if (isEventEnabled) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to create Swagger object for APIProvider: " + apiProvider + " \n from document: " + doc + " : \n exception: " + e), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"SWAGGER_NOT_CREATED", (Object[])new Object[]{apiProvider, docType, e.getClass(), e.getMessage()});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SwaggerException.class})
    private void processApiProvider(APIProvider apiProvider, boolean shouldPublish) {
        boolean isDebugEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        boolean isEventEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
        boolean isDumpEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled();
        APIProvider.DocType docType = APIProvider.DocType.Swagger_20_JSON;
        String doc = apiProvider.getDocument(docType);
        if (doc == null || doc.trim().isEmpty()) {
            if (isEventEnabled) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document is null/empty for APIProvider: " + apiProvider + " : \n doc:" + doc), (Object[])new Object[0]);
            }
            docType = APIProvider.DocType.Swagger_20_YAML;
            doc = apiProvider.getDocument(docType);
        }
        if (doc == null || doc.trim().isEmpty()) {
            if (isEventEnabled) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document is null/empty for APIProvider: " + apiProvider + " : \n doc:" + doc), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"DOCUMENT_NOT_PROVIDED", (Object[])new Object[]{docType, apiProvider});
        } else {
            if (isDebugEnabled) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document from APIProvider: " + apiProvider + " \n"), (Object[])new Object[0]);
            }
            if (isDumpEnabled) {
                Tr.dump((TraceComponent)tc, (String)("Swagger document: " + doc), (Object[])new Object[0]);
            }
            if (this.primarySwagger == null) {
                this.initPrimarySwagger();
            }
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                try {
                    Swagger swg = APIProviderAggregator.getSwaggerDoc(doc, this.primarySwagger.gatherNamesAlreadyTaken(), null, tc, this);
                    if (swg != null) {
                        if (isDumpEnabled) {
                            Tr.dump((TraceComponent)tc, (String)("Retrieved Swagger object from document: " + doc + " : Swagger: " + swg), (Object[])new Object[0]);
                        }
                        if (!(apiProvider instanceof SwaggerWebProvider) && swg.getBasePath() != null) {
                            if (isEventEnabled) {
                                Tr.event((TraceComponent)tc, (String)("Using the base path of apiProvider swagger document as context root:" + swg.getBasePath()), (Object[])new Object[0]);
                            }
                            String contextRoot = swg.getBasePath();
                            apiProviders.put(contextRoot, apiProvider);
                            APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc = webModuleDocsConfig.get(contextRoot);
                            if (apiDiscoveryWebModuleDoc != null && !apiDiscoveryWebModuleDoc.getEnabled()) {
                                return;
                            }
                        }
                        Map returnedItems = this.primarySwagger.mergeSwagger(swg);
                        if (isDebugEnabled) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Returned items: " + returnedItems), (Object[])new Object[0]);
                        }
                        this.refToAddedItems.put(apiProvider, returnedItems);
                        if (apiProvider instanceof SwaggerWebProvider) {
                            this.addSwaggerDefinitionProvider((SwaggerWebProvider)apiProvider, doc);
                        }
                        if (shouldPublish) {
                            this.publishDoc(this.primarySwagger);
                        }
                    } else {
                        if (isEventEnabled) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved Swagger object is null for document: " + doc + " : \n APIProvider: " + apiProvider), (Object[])new Object[0]);
                        }
                        Tr.warning((TraceComponent)tc, (String)"SWAGGER_IS_NULL", (Object[])new Object[]{apiProvider, docType});
                    }
                }
                catch (SwaggerException se) {
                    if (isEventEnabled) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("SwaggerException occurred while trying to create Swagger object for APIProvider: " + apiProvider + " \n from document: " + doc + " : \n exception: " + (Object)((Object)se)), (Object[])new Object[0]);
                    }
                    Tr.warning((TraceComponent)tc, (String)"SWAGGER_NOT_CREATED", (Object[])new Object[]{apiProvider, docType, ((Object)((Object)se)).getClass(), se.getMessage()});
                }
                catch (Exception se) {
                    void e;
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"670", (Object)this, (Object[])new Object[]{apiProvider, shouldPublish});
                    if (isEventEnabled) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to create Swagger object for APIProvider: " + apiProvider + " \n from document: " + doc + " : \n exception: " + e), (Object[])new Object[0]);
                    }
                    Tr.warning((TraceComponent)tc, (String)"SWAGGER_NOT_CREATED", (Object[])new Object[]{apiProvider, docType, e.getClass(), e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSwaggerDefinitionProvider(SwaggerWebProvider swProvider, String doc) {
        String contextRoot = swProvider.getContextRoot();
        ArrayList<String> serverContextRoots = (ArrayList<String>)this.primarySwagger.getVendorExtensions().get(IBM_SERVICES_EXTENSION_KEY);
        if (serverContextRoots == null) {
            serverContextRoots = new ArrayList<String>();
            this.primarySwagger.setVendorExtension(IBM_SERVICES_EXTENSION_KEY, serverContextRoots);
        }
        if (!swProvider.isPublic()) {
            serverContextRoots.remove(contextRoot);
            nonPublicRoots.add(contextRoot);
        } else {
            serverContextRoots.add(contextRoot);
            nonPublicRoots.remove(contextRoot);
        }
        Swagger swagger = APIDiscoveryUtils.parseSwagger(doc);
        Set<SwaggerWebProvider> set = this.swaggerDefinitionProviders;
        synchronized (set) {
            if (this.containsSwaggerDefinition(swagger)) {
                this.swaggerDefinitionProviders.add(swProvider);
            }
            if (this.isSwaggerDefinitionSet) {
                if (this.swaggerDefinitionLocation != null && this.swaggerDefinitionLocation.equals(swProvider.getContextRoot())) {
                    this.pushSwaggerDefinition(swagger);
                }
            } else if (this.containsSwaggerDefinition(swagger)) {
                if (this.swaggerDefinitionProviders.size() == 1) {
                    this.pushSwaggerDefinition(swagger);
                } else if (this.swaggerDefinitionProviders.size() == 2) {
                    this.pushDefaultSwaggerDefinition();
                    Tr.warning((TraceComponent)tc, (String)"SWAGGER_DEFINITION_CONFLICTING", (Object[])new Object[]{Arrays.toString(this.swaggerDefinitionProviders.toArray())});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingApiProviders() {
        Swagger swagger = this.primarySwagger;
        synchronized (swagger) {
            Set<APIProvider> set = this.pendingApiProviders;
            synchronized (set) {
                if (this.isLazilyProcessingProviders) {
                    Iterator<APIProvider> i = this.pendingApiProviders.iterator();
                    if (i.hasNext()) {
                        while (i.hasNext()) {
                            APIProvider apiProvider = i.next();
                            this.processApiProvider(apiProvider, false);
                            i.remove();
                        }
                        this.publishDoc(this.primarySwagger);
                    }
                    this.isLazilyProcessingProviders = false;
                }
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected void setCustomCSSWABUpdater(CustomCSSWABUpdater updater) {
        this.customCSSProcessor = new CustomCSSProcessor(updater);
    }

    protected void unsetCustomCSSWABUpdater(CustomCSSWABUpdater updater) {
        this.customCSSProcessor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRESTAPIDocPublisher(APIDocPublisher publisher, Map<String, Object> props) {
        boolean publishImmediately = Boolean.parseBoolean((String)props.get("publishImmediately"));
        Tr.event((Object)this, (TraceComponent)tc, (String)("setRESTAPIDocPublisher " + publisher.getClass().getName() + " publishImmediately=" + publishImmediately), (Object[])new Object[0]);
        if (this.primarySwagger == null) {
            this.initPrimarySwagger();
        }
        if (publishImmediately) {
            this.processPendingApiProviders();
        }
        this.apiDocPublishers.add(publisher);
        Swagger swagger = this.primarySwagger;
        synchronized (swagger) {
            this.publishDoc(this.primarySwagger);
        }
    }

    protected void unsetRESTAPIDocPublisher(APIDocPublisher publisher) {
        this.apiDocPublishers.remove(publisher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={SwaggerException.class, Exception.class})
    public static Swagger getSwaggerDoc(String swaggerRef, Map<String, Set<String>> takenNames, String tagsOverrideValue, TraceComponent tc, Object obj) throws Exception {
        boolean isEventEnabled;
        if (swaggerRef == null || swaggerRef.trim().isEmpty()) {
            return null;
        }
        boolean isDebugEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        boolean bl = isEventEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
        if (swaggerRef.startsWith("http")) {
            try {
                return new SwaggerParser().read(swaggerRef, takenNames, tagsOverrideValue);
            }
            catch (Exception e) {
                if (!isEventEnabled) throw e;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception " + e + " occurred while trying to read http/https endpoint : " + swaggerRef), (Object[])new Object[0]);
                throw e;
            }
        }
        if (swaggerRef.startsWith("file:")) {
            if (!swaggerRef.startsWith("file:///")) {
                if (!isEventEnabled) return null;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("File reference must start with file:///. swaggerRef=" + swaggerRef), (Object[])new Object[0]);
                return null;
            }
            String swaggerFilePath = swaggerRef.substring("file:///".length());
            try {
                File aFile = new File(swaggerFilePath);
                if (FileUtils.fileExists((File)aFile)) {
                    if (!isDebugEnabled) return new SwaggerParser().read(aFile.getAbsolutePath(), takenNames, tagsOverrideValue);
                    Tr.debug((Object)obj, (TraceComponent)tc, (String)("Absolute path of aFile=" + aFile.getAbsolutePath()), (Object[])new Object[0]);
                    return new SwaggerParser().read(aFile.getAbsolutePath(), takenNames, tagsOverrideValue);
                }
                if (!isEventEnabled) return null;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("File doesn't exist. swaggerRef=" + swaggerRef + " : path=" + aFile.getAbsolutePath()), (Object[])new Object[0]);
                return null;
            }
            catch (SwaggerException se) {
                if (!isEventEnabled) throw se;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("SwaggerException occurred while trying to read file: " + swaggerRef + " : \n exception=" + (Object)((Object)se)), (Object[])new Object[0]);
                throw se;
            }
            catch (Exception e) {
                if (!isEventEnabled) throw e;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception occurred while trying to retrieve file: " + swaggerRef + " : \n exception=" + e), (Object[])new Object[0]);
                throw e;
            }
        } else {
            try {
                return new SwaggerParser().parse(swaggerRef, takenNames, tagsOverrideValue);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw e;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception " + e + " occurred while trying to parse : \n " + swaggerRef), (Object[])new Object[0]);
                throw e;
            }
        }
    }

    public static Swagger getSwaggerBase(String hostPortValue) {
        return APIProviderAggregator.getSwaggerBase(hostPortValue, 0, 0, false);
    }

    public static Swagger getSwaggerBase(String hostPortValue, int httpPort, int httpsPort) {
        return APIProviderAggregator.getSwaggerBase(hostPortValue, httpPort, httpsPort, true);
    }

    public static Swagger getSwaggerBase(String hostPortValue, int httpPort, int httpsPort, boolean showPorts) {
        Info info = new Info();
        info.title(SWAGGER_BASE_INFO_TITLE);
        info.description(SWAGGER_BASE_INFO_DESCRIPTION);
        info.setVersion(SWAGGER_BASE_INFO_VERSION);
        Swagger swg = new Swagger();
        swg.info(info);
        swg.setSwagger(SWAGGER_VERSION_2_0);
        if (hostPortValue != null) {
            swg.setHost(hostPortValue);
        }
        if (showPorts) {
            swg.setVendorExtension(IBM_HTTP_PORT_EXTENSION_KEY, (Object)httpPort);
            swg.setVendorExtension(IBM_HTTPS_PORT_EXTENSION_KEY, (Object)httpsPort);
        }
        return swg;
    }

    @FFDCIgnore(value={JsonParseException.class, JsonMappingException.class, IOException.class})
    private void checkVCAPHost() {
        block9: {
            String VCAP_APPLICATION = System.getenv("VCAP_APPLICATION");
            if (VCAP_APPLICATION != null) {
                try {
                    JsonNode node = (JsonNode)Json.mapper().readValue(VCAP_APPLICATION, JsonNode.class);
                    ArrayNode uris = (ArrayNode)node.get("uris");
                    if (uris != null && uris.size() > 0 && uris.get(0) != null) {
                        this.hostPort = uris.get(0).textValue();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Changed hostPort using VCAP_APPLICATION.  New value: " + this.hostPort), (Object[])new Object[0]);
                    }
                }
                catch (JsonParseException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                catch (JsonMappingException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrimarySwaggerHostPort(VirtualHost vhost, Map<String, Object> props) {
        boolean isSecure = true;
        Object value = props.get("httpsAlias");
        if (value == null) {
            String[] aliases = (String[])props.get("aliases");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuffer aliasesBuffer = new StringBuffer();
                String[] stringArray = aliases;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    aliasesBuffer.append("," + s);
                }
                Tr.debug((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + aliasesBuffer.toString()), (Object[])new Object[0]);
            }
            for (String anAlias : aliases) {
                if (anAlias.endsWith(":-1")) continue;
                value = anAlias;
                isSecure = false;
                break;
            }
        }
        String alias = value.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        String host = vhost.getHostName(alias);
        int port = isSecure ? vhost.getSecureHttpPort(alias) : vhost.getHttpPort(alias);
        this.hostPort = host + ":" + Integer.toString(port);
        this.httpPort = vhost.getHttpPort(alias);
        this.httpsPort = vhost.getSecureHttpPort(alias);
        this.checkVCAPHost();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("New hostPort: " + this.hostPort), (Object[])new Object[0]);
        }
        if (this.primarySwagger != null) {
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                if (this.swaggerDefinition == null) {
                    this.primarySwagger.setVendorExtension(IBM_HTTP_PORT_EXTENSION_KEY, (Object)this.httpPort);
                    this.primarySwagger.setVendorExtension(IBM_HTTPS_PORT_EXTENSION_KEY, (Object)this.httpsPort);
                    this.primarySwagger.setHost(this.hostPort);
                } else {
                    Integer httpPortFromSwaggerDefinition = (Integer)this.swaggerDefinition.getVendorExtensions().get(IBM_HTTP_PORT_EXTENSION_KEY);
                    Integer httpsPortFromSwaggerDefinition = (Integer)this.swaggerDefinition.getVendorExtensions().get(IBM_HTTPS_PORT_EXTENSION_KEY);
                    String hostFromSwaggerDefinition = this.swaggerDefinition.getHost();
                    this.primarySwagger.setVendorExtension(IBM_HTTP_PORT_EXTENSION_KEY, (Object)(httpPortFromSwaggerDefinition != null ? httpPortFromSwaggerDefinition : this.httpPort));
                    this.primarySwagger.setVendorExtension(IBM_HTTPS_PORT_EXTENSION_KEY, (Object)(httpsPortFromSwaggerDefinition != null ? httpsPortFromSwaggerDefinition : this.httpsPort));
                    this.primarySwagger.setHost(hostFromSwaggerDefinition != null ? hostFromSwaggerDefinition : this.hostPort);
                }
                this.publishDoc(this.primarySwagger);
            }
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updatePrimarySwaggerHostPort(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updatePrimarySwaggerHostPort(vhost, props);
    }

    protected void unsetVirtualHost(VirtualHost vhost) {
    }

    /*
     * Unable to fully structure code
     */
    private void publishDoc(Swagger doc) {
        if (doc != null && doc.getHost() != null && !doc.getHost().trim().isEmpty() && !this.apiDocPublishers.isEmpty()) {
            try {
                for (APIDocPublisher apiDocPublisher : this.apiDocPublishers) {
                    if (TraceComponent.isAnyTracingEnabled() && APIProviderAggregator.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)APIProviderAggregator.tc, (String)("Publishing doc to publisher " + apiDocPublisher), (Object[])new Object[0]);
                    }
                    apiDocPublisher.publishRESTAPIDoc(APIProvider.DocType.Swagger_20_JSON, Json.mapper().writeValueAsString((Object)doc));
                    apiDocPublisher.publishRESTAPIDoc(APIProvider.DocType.Swagger_20_YAML, Yaml.mapper().writeValueAsString((Object)doc));
                }
            }
            catch (JsonProcessingException var2_3) {
                FFDCFilter.processException((Throwable)var2_3, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1032", (Object)this, (Object[])new Object[]{doc});
                if (!TraceComponent.isAnyTracingEnabled() || !APIProviderAggregator.tc.isEventEnabled()) ** GOTO lbl17
                Tr.event((Object)this, (TraceComponent)APIProviderAggregator.tc, (String)("Exception occurred while trying to convert Swagger object to String. \n exception: " + e), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && APIProviderAggregator.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)APIProviderAggregator.tc, (String)"Skip publishing because either host:port value is not set on primary data or no instance of APIDocPublisher is set. Feature apiDiscoveryCollectiveMember might not be started up.", (Object[])new Object[0]);
        }
lbl17:
        // 6 sources

        if (TraceComponent.isAnyTracingEnabled() && APIProviderAggregator.tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)APIProviderAggregator.tc, (String)"Published the Swagger doc.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void writeSwaggerToResponse(Swagger swg, RESTResponse response, APIProvider.DocType docType, boolean compact, boolean displayPorts, String identifier, TraceComponent tc, Object obj) {
        HashMap<String, Object> savedExtensions = new HashMap<String, Object>();
        try {
            if (!displayPorts) {
                APIProviderAggregator.saveExtensions(swg, savedExtensions);
            }
            if (docType == APIProvider.DocType.Swagger_20_JSON) {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                if (compact) {
                    Json.mapper().writeValue(response.getWriter(), (Object)swg);
                } else {
                    Json.pretty().writeValue(response.getWriter(), (Object)swg);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    String swaggerAsString = Json.mapper().writeValueAsString((Object)swg);
                    if (tc.isDumpEnabled()) {
                        Tr.dump((TraceComponent)tc, (String)("Swagger document written to response (" + identifier + "). docType=" + docType + " : compact=" + compact + " :\n + swaggerAsString=" + swaggerAsString), (Object[])new Object[0]);
                    } else {
                        Tr.event((TraceComponent)tc, (String)("Swagger document written to response (" + identifier + "). docType=" + docType + " : compact=" + compact + "\n"), (Object[])new Object[0]);
                    }
                }
            } else if (docType == APIProvider.DocType.Swagger_20_YAML) {
                response.setContentType("application/yaml");
                response.setCharacterEncoding("UTF-8");
                if (compact) {
                    Yaml.mapper().writeValue(response.getWriter(), (Object)swg);
                } else {
                    Yaml.pretty().writeValue(response.getWriter(), (Object)swg);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled()) {
                    String swaggerAsString = Yaml.mapper().writeValueAsString((Object)swg);
                    if (tc.isDumpEnabled()) {
                        Tr.dump((TraceComponent)tc, (String)("Swagger document written to response (" + identifier + "). docType=" + docType + " : compact=" + compact + " :\n + swaggerAsString=" + swaggerAsString), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("Swagger document written to response (" + identifier + "). docType=" + docType + " : compact=" + compact + "\n"), (Object[])new Object[0]);
                    }
                }
            } else {
                response.sendError(415);
            }
        }
        catch (Exception swaggerAsString) {
            FFDCFilter.processException((Throwable)swaggerAsString, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1098", null, (Object[])new Object[]{swg, response, docType, compact, displayPorts, identifier, tc, obj});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception occurred while trying to write Swagger to response (" + identifier + "). docType=" + docType + " : \n response=" + response + " : \n exception=" + e), (Object[])new Object[0]);
            }
            try {
                response.sendError(500);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1105", null, (Object[])new Object[]{swg, response, docType, compact, displayPorts, identifier, tc, obj});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    void e1;
                    Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception occurred while trying to send error 500 to response (" + identifier + "). docType=" + docType + " : \n response=" + response + " : \n exception=" + e1), (Object[])new Object[0]);
                }
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeSwaggerToResponse.finally, savedExtensions:" + savedExtensions), (Object[])new Object[0]);
            }
            if (savedExtensions.get(IBM_HTTP_PORT_EXTENSION_KEY) != null) {
                swg.setVendorExtension(IBM_HTTP_PORT_EXTENSION_KEY, savedExtensions.get(IBM_HTTP_PORT_EXTENSION_KEY));
            }
            if (savedExtensions.get(IBM_HTTPS_PORT_EXTENSION_KEY) != null) {
                swg.setVendorExtension(IBM_HTTPS_PORT_EXTENSION_KEY, savedExtensions.get(IBM_HTTPS_PORT_EXTENSION_KEY));
            }
        }
    }

    private static void saveExtensions(Swagger swg, Map<String, Object> placeToSave) {
        Map vendorExtensions = swg.getVendorExtensions();
        Object ibmHttpPort = vendorExtensions.get(IBM_HTTP_PORT_EXTENSION_KEY);
        Object ibmHttpsPort = vendorExtensions.get(IBM_HTTPS_PORT_EXTENSION_KEY);
        placeToSave.put(IBM_HTTP_PORT_EXTENSION_KEY, ibmHttpPort);
        placeToSave.put(IBM_HTTPS_PORT_EXTENSION_KEY, ibmHttpsPort);
        HashSet<String> names = new HashSet<String>();
        names.add(IBM_HTTP_PORT_EXTENSION_KEY);
        names.add(IBM_HTTPS_PORT_EXTENSION_KEY);
        HashMap<String, HashSet<String>> removeItems = new HashMap<String, HashSet<String>>();
        removeItems.put("swvendorext", names);
        swg.removeItems(removeItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String getDocument(APIProvider.DocType docType) {
        if (this.primarySwagger != null) {
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                this.processPendingApiProviders();
                try {
                    if (docType == APIProvider.DocType.Swagger_20_YAML) {
                        return Yaml.mapper().writeValueAsString((Object)this.primarySwagger);
                    }
                    return Json.mapper().writeValueAsString((Object)this.primarySwagger);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1149", (Object)this, (Object[])new Object[]{docType});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void e;
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to convert Swagger object to String. \n exception: " + e), (Object[])new Object[0]);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApps(APIProvider.DocType docType, Set<String> roots) {
        if (this.primarySwagger != null) {
            Swagger swagger = this.primarySwagger;
            synchronized (swagger) {
                this.processPendingApiProviders();
                return APIProviderAggregator.filterApps(this.primarySwagger, docType, roots, tc, this);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String filterApps(Swagger swagger, APIProvider.DocType docType, Set<String> roots, TraceComponent tc, Object obj) {
        try {
            Swagger filteredSwagger = roots != null ? APIProviderAggregator.filterByRoots(swagger, roots, true, tc, obj) : APIProviderAggregator.filterByRoots(swagger, contextRootsToIgnore, false, tc, obj);
            if (docType == APIProvider.DocType.Swagger_20_YAML) {
                return Yaml.mapper().writeValueAsString((Object)filteredSwagger);
            }
            return Json.mapper().writeValueAsString((Object)filteredSwagger);
        }
        catch (JsonProcessingException filteredSwagger) {
            FFDCFilter.processException((Throwable)filteredSwagger, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1196", null, (Object[])new Object[]{swagger, docType, roots, tc, obj});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)obj, (TraceComponent)tc, (String)("Exception occurred while trying to convert Swagger object to String. \n exception: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAPIName(String apiName) {
        this.apiName = apiName;
        if (this.primarySwagger == null) {
            this.initPrimarySwagger();
        }
        Swagger swagger = this.primarySwagger;
        synchronized (swagger) {
            Info swaggerInfo = this.primarySwagger.getInfo();
            swaggerInfo.setTitle(apiName);
            swaggerInfo.setDescription("APIs for " + apiName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setSwaggerDefinition(String swaggerDefinitionLocation) {
        Swagger swagger = this.primarySwagger;
        synchronized (swagger) {
            boolean showWarning;
            Swagger swaggerDefinition;
            block23: {
                this.swaggerDefinitionLocation = swaggerDefinitionLocation;
                this.isSwaggerDefinitionSet = swaggerDefinitionLocation != null;
                this.swaggerDefinition = null;
                this.pushDefaultSwaggerDefinition();
                swaggerDefinition = null;
                showWarning = true;
                try {
                    if (swaggerDefinitionLocation == null || swaggerDefinitionLocation.trim().isEmpty()) {
                        showWarning = false;
                    } else if (swaggerDefinitionLocation.charAt(0) == '/' && !swaggerDefinitionLocation.endsWith(".json") && !swaggerDefinitionLocation.endsWith(".yaml")) {
                        showWarning = false;
                        swaggerDefinition = this.getSwaggerFromContextRoot(APIDiscoveryUtils.normalizeContextRoot(swaggerDefinitionLocation));
                    } else if (swaggerDefinitionLocation.startsWith("http:") || swaggerDefinitionLocation.startsWith("https:")) {
                        this.swaggerDefinition = swaggerDefinition = this.getSwaggerFromURL(swaggerDefinitionLocation);
                    } else if (swaggerDefinitionLocation.endsWith(".json") || swaggerDefinitionLocation.endsWith(".yaml")) {
                        this.swaggerDefinition = swaggerDefinition = this.getSwaggerFromFile(swaggerDefinitionLocation);
                    }
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1246", (Object)this, (Object[])new Object[]{swaggerDefinitionLocation});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to read Swagger definition '" + swaggerDefinitionLocation + "' or create Swagger object. \n exception: " + e), (Object[])new Object[0]);
                }
            }
            if (!this.isSwaggerDefinitionSet) {
                Set<SwaggerWebProvider> set = this.swaggerDefinitionProviders;
                synchronized (set) {
                    if (this.swaggerDefinitionProviders.size() == 1) {
                        swaggerDefinition = this.getSwaggerFromSwaggerWebProvider(this.swaggerDefinitionProviders.iterator().next());
                    } else if (this.swaggerDefinitionProviders.size() > 1) {
                        Tr.warning((TraceComponent)tc, (String)"SWAGGER_DEFINITION_CONFLICTING", (Object[])new Object[]{Arrays.toString(this.swaggerDefinitionProviders.toArray())});
                    }
                }
            }
            if (swaggerDefinition == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Document is null/empty for Swagger Definition: " + swaggerDefinitionLocation), (Object[])new Object[0]);
                }
                if (showWarning) {
                    Tr.warning((TraceComponent)tc, (String)"SWAGGER_DEFINITION_IS_NULL", (Object[])new Object[]{swaggerDefinitionLocation});
                }
            } else {
                this.pushSwaggerDefinition(swaggerDefinition);
            }
            this.publishDoc(this.primarySwagger);
        }
    }

    private void pushDefaultSwaggerDefinition() {
        this.swaggerDefinition = this.getDefaultSwaggerDefinition();
        this.pushSwaggerDefinition(this.swaggerDefinition);
        this.swaggerDefinition = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSwaggerDefinition(Swagger swagger) {
        if (this.primarySwagger == null) {
            this.initPrimarySwagger();
        }
        Swagger swagger2 = this.primarySwagger;
        synchronized (swagger2) {
            this.primarySwagger.setInfo(this.ensureValidInfo(swagger.getInfo()));
            this.primarySwagger.setConsumes(swagger.getConsumes());
            this.primarySwagger.setProduces(swagger.getProduces());
            this.primarySwagger.setSchemes(swagger.getSchemes());
            this.primarySwagger.setExternalDocs(swagger.getExternalDocs());
            if (this.swaggerDefinition != null) {
                if (swagger.getHost() != null && !swagger.getHost().isEmpty()) {
                    this.primarySwagger.setHost(swagger.getHost());
                }
                this.primarySwagger.setBasePath(swagger.getBasePath());
                for (Map.Entry veEntry : swagger.getVendorExtensions().entrySet()) {
                    if (veEntry.getValue() == null) continue;
                    if ((((String)veEntry.getKey()).equals(IBM_HTTP_PORT_EXTENSION_KEY) || ((String)veEntry.getKey()).equals(IBM_HTTPS_PORT_EXTENSION_KEY)) && !(veEntry.getValue() instanceof Integer)) {
                        veEntry.setValue(null);
                        continue;
                    }
                    this.primarySwagger.setVendorExtension((String)veEntry.getKey(), veEntry.getValue());
                }
            }
            this.processCustomCSS(this.primarySwagger);
        }
    }

    private Info ensureValidInfo(Info info) {
        if (info == null) {
            info = new Info();
        }
        if (info.getTitle() == null || info.getTitle().isEmpty()) {
            info.setTitle(SWAGGER_BASE_INFO_TITLE);
        }
        if (info.getVersion() == null || info.getVersion().isEmpty()) {
            info.setVersion(SWAGGER_BASE_INFO_VERSION);
        }
        return info;
    }

    private void processCustomCSS(Swagger swagger) {
        CustomCSSProcessor processor = this.customCSSProcessor;
        WsLocationAdmin locationAdmin = this.locationAdminProvider;
        if (processor != null && locationAdmin != null && !FrameworkState.isStopping()) {
            processor.process(swagger, locationAdmin, this.getExecutorService());
        }
    }

    private Swagger getDefaultSwaggerDefinition() {
        Swagger swagger = APIProviderAggregator.getSwaggerBase(this.hostPort, this.httpPort, this.httpsPort);
        Info swaggerInfo = swagger.getInfo();
        if (this.apiName != null) {
            swaggerInfo.setTitle(this.apiName);
            swaggerInfo.setDescription("APIs for " + this.apiName);
        }
        return swagger;
    }

    private Swagger getSwaggerFromContextRoot(String contextRoot) {
        SwaggerWebProvider webProvider = this.findSwaggerWebProvider(contextRoot);
        if (webProvider == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to find any APIProvider for context root: " + contextRoot), (Object[])new Object[0]);
            }
            return null;
        }
        return this.getSwaggerFromSwaggerWebProvider(webProvider);
    }

    private Swagger getSwaggerFromSwaggerWebProvider(SwaggerWebProvider webProvider) {
        if (webProvider == null) {
            return null;
        }
        Swagger swagger = null;
        APIProvider.DocType docType = APIProvider.DocType.Swagger_20_JSON;
        String swaggerDocument = webProvider.getDocument(docType);
        if (swaggerDocument == null || swaggerDocument.trim().isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document is null/empty for APIProvider: " + webProvider), (Object[])new Object[0]);
            }
            docType = APIProvider.DocType.Swagger_20_YAML;
            swaggerDocument = webProvider.getDocument(docType);
        }
        if (swaggerDocument != null) {
            swagger = APIDiscoveryUtils.parseSwagger(swaggerDocument);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved " + docType + " document is null/empty for APIProvider: " + webProvider), (Object[])new Object[0]);
        }
        return swagger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwaggerWebProvider findSwaggerWebProvider(String contextRoot) {
        Map<APIProvider, Map<String, Set<String>>> map = this.refToAddedItems;
        synchronized (map) {
            for (APIProvider provider : this.refToAddedItems.keySet()) {
                SwaggerWebProvider webProvider;
                if (!(provider instanceof SwaggerWebProvider) || !contextRoot.equals((webProvider = (SwaggerWebProvider)provider).getContextRoot())) continue;
                return webProvider;
            }
        }
        return null;
    }

    private Swagger getSwaggerFromURL(String swaggerDefinition) {
        return APIDiscoveryUtils.parseSwagger(APIDiscoveryUtils.getSwaggerDocumentFromURL(swaggerDefinition));
    }

    private Swagger getSwaggerFromFile(String swaggerDefinition) {
        String normalizedPath = PathUtils.normalize((String)swaggerDefinition);
        WsResource resource = this.locationAdminProvider.resolveResource(normalizedPath);
        File swaggerFile = resource.asFile();
        Swagger swagger = null;
        if (swaggerFile != null && swaggerFile.exists()) {
            swagger = APIDiscoveryUtils.parseSwagger(APIDiscoveryUtils.getSwaggerDocFromFile(swaggerFile));
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to locate the file " + (swaggerFile == null ? swaggerDefinition : swaggerFile.getAbsolutePath()) + "."), (Object[])new Object[0]);
        }
        return swagger;
    }

    private boolean containsSwaggerDefinition(Swagger swagger) {
        return swagger != null && swagger.getInfo() != null;
    }

    private ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"ScheduledExecutorService"}));
        }
        return service;
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(service=APIDiscoveryWebModuleDoc.class, name="apiProviderWebModuleDoc", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Process webModuleDoc config item for API provider.", (Object[])new Object[]{apiDiscoveryWebModuleDoc});
        }
        webModuleDocsConfig.put(apiDiscoveryWebModuleDoc.getContextRoot(), apiDiscoveryWebModuleDoc);
        this.processConfigToAPIProviderAssociation(apiDiscoveryWebModuleDoc);
    }

    protected void unsetApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Remove webModuleDoc config item for API provider.", (Object[])new Object[]{apiDiscoveryWebModuleDoc});
        }
        String contextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        webModuleDocsConfig.remove(contextRoot);
        APIProvider apiProvider = apiProviders.get(contextRoot);
        if (apiProvider != null && !this.isInPrimarySwagger(apiProvider)) {
            this.setApiProvider(apiProvider);
        }
    }

    private void processConfigToAPIProviderAssociation(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        String contextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        APIProvider apiProvider = apiProviders.get(contextRoot);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("process webModuleDoc config item for api provider, provider=" + apiProvider), (Object[])new Object[0]);
        }
        if (apiProvider != null) {
            if (apiDiscoveryWebModuleDoc.getEnabled()) {
                if (!this.isInPrimarySwagger(apiProvider)) {
                    this.processApiProvider(apiProvider, true);
                }
            } else {
                this.processRemoveApiProvider(apiProvider);
            }
        }
    }

    private boolean isInPrimarySwagger(APIProvider apiProvider) {
        return this.refToAddedItems.get(apiProvider) != null;
    }

    @Override
    public void modifyApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc, String oldContextRoot) {
        String newContextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        if (!oldContextRoot.equals(newContextRoot)) {
            APIDiscoveryWebModuleDoc webModDoc;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Aggregator changing the association of " + apiDiscoveryWebModuleDoc + " from " + oldContextRoot + " to " + newContextRoot), (Object[])new Object[0]);
            }
            if ((webModDoc = webModuleDocsConfig.get(oldContextRoot)) != null && webModDoc.equals(apiDiscoveryWebModuleDoc)) {
                webModuleDocsConfig.remove(oldContextRoot);
                APIProvider apiProvider = apiProviders.get(oldContextRoot);
                if (apiProvider != null && !this.isInPrimarySwagger(apiProvider)) {
                    this.setApiProvider(apiProvider);
                }
            }
            webModuleDocsConfig.put(newContextRoot, apiDiscoveryWebModuleDoc);
        }
        this.processConfigToAPIProviderAssociation(apiDiscoveryWebModuleDoc);
    }

    private Map<String, Object> setDynamicHostInfo(RESTRequest request, Swagger swagger) {
        String basePath;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Temporary modify host and port info", (Object[])new Object[0]);
        }
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        oldValues.put("host", swagger.getHost());
        oldValues.put("basePath", swagger.getBasePath());
        oldValues.put(IBM_HTTP_PORT_EXTENSION_KEY, swagger.getVendorExtensions().get(IBM_HTTP_PORT_EXTENSION_KEY));
        oldValues.put(IBM_HTTPS_PORT_EXTENSION_KEY, swagger.getVendorExtensions().get(IBM_HTTPS_PORT_EXTENSION_KEY));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (Map.Entry entry : oldValues.entrySet()) {
                Tr.debug((TraceComponent)tc, (String)("Preserve original swagger value at : " + (String)entry.getKey() + " = " + entry.getValue()), (Object[])new Object[0]);
            }
        }
        if (this.swaggerDefinition != null) {
            this.setHostInfoRequest(request, swagger);
            if ((this.swaggerDefinition.getBasePath() == null || this.swaggerDefinition.getBasePath().isEmpty()) && (basePath = this.getBasePathFromRequest(request)) != null && !basePath.isEmpty()) {
                swagger.setBasePath(basePath);
            }
        } else {
            this.setHostInfoRequest(request, swagger);
            basePath = this.getBasePathFromRequest(request);
            if (basePath != null && !basePath.isEmpty()) {
                swagger.setBasePath(basePath);
            }
        }
        return oldValues;
    }

    private void resetDynamicHostInfo(Swagger swagger, Map<String, Object> oldValues) {
        swagger.setHost((String)oldValues.get("host"));
        swagger.setBasePath((String)oldValues.get("basePath"));
        swagger.setVendorExtension(IBM_HTTP_PORT_EXTENSION_KEY, oldValues.get(IBM_HTTP_PORT_EXTENSION_KEY));
        swagger.setVendorExtension(IBM_HTTPS_PORT_EXTENSION_KEY, oldValues.get(IBM_HTTPS_PORT_EXTENSION_KEY));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reverted back temporary host and port info", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setHostInfoRequest(RESTRequest request, Swagger swagger) {
        URL url;
        String urlString;
        String refererHeader = request.getHeader(HTTP_HEADER_REFERER);
        if (refererHeader != null && !refererHeader.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set host info based on referer header " + refererHeader), (Object[])new Object[0]);
            }
            String string = refererHeader = refererHeader.endsWith("/") ? refererHeader.substring(0, refererHeader.length() - 1) : refererHeader;
            if (!refererHeader.endsWith("/explorer") && !refererHeader.endsWith("/docs")) {
                refererHeader = null;
            }
            urlString = refererHeader != null ? refererHeader : request.getCompleteURL();
        } else {
            urlString = request.getCompleteURL();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set host info based on request url " + urlString), (Object[])new Object[0]);
            }
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1619", (Object)this, (Object[])new Object[]{request, swagger});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + urlString + ": " + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        Integer port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if (port != this.httpPort && port != this.httpsPort) {
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                this.modifyExtPort(IBM_HTTPS_PORT_EXTENSION_KEY, swagger, port);
                this.modifyExtPort(IBM_HTTP_PORT_EXTENSION_KEY, swagger, 0);
            } else {
                this.modifyExtPort(IBM_HTTPS_PORT_EXTENSION_KEY, swagger, 0);
                this.modifyExtPort(IBM_HTTP_PORT_EXTENSION_KEY, swagger, port);
            }
        }
        if (this.swaggerDefinition == null || this.swaggerDefinition.getHost() == null || this.swaggerDefinition.getHost().isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting swagger host dynamically", (Object[])new Object[0]);
            }
            String hostPort = url.getHost() + ":" + port;
            swagger.setHost(hostPort);
        }
    }

    private void modifyExtPort(String extName, Swagger swagger, Integer value) {
        Integer sdValue = null;
        if (this.swaggerDefinition != null) {
            sdValue = (Integer)this.swaggerDefinition.getVendorExtensions().get(extName);
        }
        if (sdValue == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set " + extName + " port dynamically: " + value), (Object[])new Object[0]);
            }
            swagger.getVendorExtensions().put(extName, value);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set " + extName + " port from swagger defintion: " + sdValue), (Object[])new Object[0]);
            }
            swagger.getVendorExtensions().put(extName, sdValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getBasePathFromRequest(RESTRequest request) {
        String refererHeader = request.getHeader(HTTP_HEADER_REFERER);
        if (refererHeader != null && !refererHeader.isEmpty()) {
            URL url;
            try {
                url = new URL(refererHeader);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1672", (Object)this, (Object[])new Object[]{request});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    void e;
                    Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + refererHeader + ": " + e.getMessage()), (Object[])new Object[0]);
                }
                return this.primarySwagger.getBasePath();
            }
            try {
                refererHeader = new URI(url.getPath()).normalize().getPath();
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rest.api.discovery.APIProviderAggregator", (String)"1681", (Object)this, (Object[])new Object[]{request});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + url.getPath() + ": " + e.getMessage()), (Object[])new Object[0]);
                }
                return this.primarySwagger.getBasePath();
            }
            String string = refererHeader = refererHeader.endsWith("/") ? refererHeader.substring(0, refererHeader.length() - 1) : refererHeader;
            if (refererHeader.endsWith("/explorer")) {
                refererHeader = refererHeader.substring(0, refererHeader.lastIndexOf("/explorer"));
            } else if (refererHeader.endsWith("/docs")) {
                refererHeader = refererHeader.substring(0, refererHeader.lastIndexOf("/docs"));
            } else {
                return this.primarySwagger.getBasePath();
            }
            if (refererHeader.endsWith("/ibm/api")) {
                return refererHeader.substring(0, refererHeader.lastIndexOf("/ibm/api"));
            }
            if (refererHeader.endsWith(this.publicURL)) {
                return refererHeader.substring(0, refererHeader.lastIndexOf(this.publicURL));
            }
            return this.primarySwagger.getBasePath();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Referer header is null", (Object[])new Object[0]);
        }
        return this.primarySwagger.getBasePath();
    }

    public void setPublicURL(String publicURL) {
        this.publicURL = publicURL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        contextRootsToIgnore.add("/ibm/api");
        contextRootsToIgnore.add("/IBMJMXConnectorREST");
        contextRootsToIgnore.add("/analytics");
        contextRootsToIgnore.add("/mqtt");
        contextRootsToIgnore.add("/oauth2");
        contextRootsToIgnore.add("/oidcclient");
        contextRootsToIgnore.add("/oidc");
        contextRootsToIgnore.add("/ibm/saml20");
        contextRootsToIgnore.add("/ibm/wsatservice");
        contextRootsToIgnore.add("/adminCenter");
        nonPublicRoots = new HashSet<String>();
    }
}

