/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.FeedProvider;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerInternalError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerUserError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.security=true", "com.ibm.wsspi.rest.handler.root=/docs/subscription"})
public class SubscriptionHandler
implements RESTHandler {
    private static final String POST_REQUEST_PROPERTY_KEY_DOCTYPE = "docType";
    private static final String POST_RESPONSE_PROPERTY_KEY_URL = "feedURL";
    private static final String POST_RESPONSE_PROPERTY_KEY_TYPE = "feedType";
    public static final TraceComponent tc = Tr.register(SubscriptionHandler.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private final String KEY_FEED_PROVIDER = "feedProvider";
    private final AtomicServiceReference<FeedProvider> feedProviderRef = new AtomicServiceReference("feedProvider");
    static final long serialVersionUID = 255270558868280065L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.feedProviderRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.feedProviderRef.deactivate(context);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"POST".equals(request.getMethod())) {
            throw new RESTHandlerMethodNotAllowedError("POST");
        }
        FeedProvider provider = this.getFeedProvider();
        APIProvider.DocType docType = this.calculatePostDocType(request);
        JSONObject obj = new JSONObject();
        obj.put((Object)POST_RESPONSE_PROPERTY_KEY_URL, (Object)provider.getFeedURL(docType));
        obj.put((Object)POST_RESPONSE_PROPERTY_KEY_TYPE, (Object)provider.getFeedType());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(obj.serialize().replace("\\/", "/"));
    }

    protected FeedProvider getFeedProvider() {
        FeedProvider feedProvider = (FeedProvider)this.feedProviderRef.getService();
        if (feedProvider == null) {
            throw new RESTHandlerInternalError(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"FeedProvider"}));
        }
        return feedProvider;
    }

    @Reference(service=FeedProvider.class, name="feedProvider", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setFeedProvider(ServiceReference<FeedProvider> feedProvider) {
        this.feedProviderRef.setReference(feedProvider);
    }

    protected void unsetFeedProvider(ServiceReference<FeedProvider> feedProvider) {
        this.feedProviderRef.unsetReference(feedProvider);
    }

    /*
     * WARNING - void declaration
     */
    private APIProvider.DocType calculatePostDocType(RESTRequest request) {
        String docType = null;
        try {
            docType = (String)JSONObject.parse((InputStream)request.getInputStream()).get((Object)POST_REQUEST_PROPERTY_KEY_DOCTYPE);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.SubscriptionHandler", (String)"115", (Object)this, (Object[])new Object[]{request});
            throw new RESTHandlerUserError(e.getMessage());
        }
        if (APIProvider.DocType.Swagger_20_JSON.name().equals(docType)) {
            return APIProvider.DocType.Swagger_20_JSON;
        }
        if (APIProvider.DocType.Swagger_20_YAML.name().equals(docType)) {
            return APIProvider.DocType.Swagger_20_YAML;
        }
        if (APIProvider.DocType.RAML_YAML.name().equals(docType)) {
            return APIProvider.DocType.RAML_YAML;
        }
        if (APIProvider.DocType.API_BLUEPRINT_JSON.name().equals(docType)) {
            return APIProvider.DocType.API_BLUEPRINT_JSON;
        }
        return APIProvider.DocType.Swagger_20_JSON;
    }
}

