/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryUtils;
import com.ibm.ws.rest.api.discovery.ClassReader;
import com.ibm.ws.rest.api.discovery.ScannedClass;
import com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.util.Json;
import v2.io.swagger.util.Yaml;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SwaggerWebProvider
implements APIProvider {
    private static final TraceComponent tc = Tr.register(SwaggerWebProvider.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private static final Dictionary<String, String> PROPS = new Hashtable<String, String>();
    private final boolean hasStubDoc;
    private final SwaggerWebAnnotationScanner annotationScanner;
    private String cachedDoc;
    private String moduleURL;
    private String nonDefaultHostPort;
    private String docURL;
    private boolean isPublic;
    private APIProvider.DocType docType;
    private ServiceRegistration<APIProvider> serviceRegistration;
    private final ComponentContext cc;
    private ClassReader reader;
    private String swaggerDocAsString = null;
    static final long serialVersionUID = -6605905440883266348L;

    public SwaggerWebProvider(ComponentContext cc, InputStream is, boolean hasStubDoc, SwaggerWebAnnotationScanner annotationScanner) {
        this(cc, is, hasStubDoc, annotationScanner, APIProvider.DocType.Swagger_20_JSON);
    }

    public SwaggerWebProvider(ComponentContext cc, InputStream is, boolean hasStubDoc, SwaggerWebAnnotationScanner annotationScanner, APIProvider.DocType docType) {
        this.cc = cc;
        this.nonDefaultHostPort = null;
        this.hasStubDoc = hasStubDoc;
        this.annotationScanner = annotationScanner;
        this.docType = docType;
        this.isPublic = true;
        if (is != null) {
            this.swaggerDocAsString = APIDiscoveryUtils.getSwaggerDocFromStream(is);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.registerOSGiService();
        } else {
            this.unregisterOSGiService();
        }
    }

    public String getDocURL() {
        return this.docURL;
    }

    public String getCachedDoc() {
        return this.cachedDoc;
    }

    public void setDocURL(String docURL) {
        this.docURL = docURL;
        this.cachedDoc = null;
        if (docURL != null) {
            this.docType = docURL.endsWith("yaml") ? APIProvider.DocType.Swagger_20_YAML : APIProvider.DocType.Swagger_20_JSON;
        }
    }

    public void setModuleURL(String moduleURL) {
        this.moduleURL = moduleURL;
    }

    private void registerOSGiService() {
        this.unregisterOSGiService();
        if (this.docURL == null && this.cachedDoc == null && this.swaggerDocAsString == null && !this.annotationScanner.getHasAnnotatedClasses()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Avoiding registration because no annotated classes nor pre-generated swagger docs were found in the web module, and no configuration was set.", (Object[])new Object[0]);
            }
            return;
        }
        this.serviceRegistration = this.cc.getBundleContext().registerService(APIProvider.class, (Object)this, PROPS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
    }

    private void unregisterOSGiService() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        this.serviceRegistration = null;
    }

    public String getDocument(APIProvider.DocType docType) {
        if (this.docType != docType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("APIProvider doesn't support " + docType + ". It only supports " + this.docType + "."), (Object[])new Object[0]);
            }
            return null;
        }
        if (this.cachedDoc != null) {
            return this.cachedDoc;
        }
        if (this.docURL != null) {
            String swaggerDocument;
            String url = "";
            url = this.docURL.charAt(0) == '/' ? this.moduleURL + this.docURL : this.docURL;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to call URL: " + url), (Object[])new Object[0]);
            }
            if ((swaggerDocument = APIDiscoveryUtils.getSwaggerDocumentFromURL(url)) != null) {
                return this.processAndSerialize(APIDiscoveryUtils.parseSwagger(swaggerDocument));
            }
            return null;
        }
        if (this.swaggerDocAsString != null && !this.hasStubDoc) {
            return this.processAndSerialize(APIDiscoveryUtils.parseSwagger(this.swaggerDocAsString));
        }
        Swagger swaggerStub = APIDiscoveryUtils.parseSwagger(this.swaggerDocAsString, false);
        if (swaggerStub != null && this.hasStubDoc || swaggerStub == null && !this.hasStubDoc) {
            return this.processAndSerialize(this.getSwaggerDocFromAnnotatedClasses(this.getAnnotatedClasses(), swaggerStub));
        }
        if (this.swaggerDocAsString != null && swaggerStub == null) {
            return this.processAndSerialize(APIDiscoveryUtils.parseSwagger(this.swaggerDocAsString));
        }
        return null;
    }

    private Swagger processHostPort(Swagger swagger) {
        if (this.nonDefaultHostPort != null) {
            swagger.setHost(this.nonDefaultHostPort);
        }
        return swagger;
    }

    /*
     * WARNING - void declaration
     */
    protected Set<ScannedClass> getAnnotatedClasses() {
        block6: {
            if (this.reader == null) {
                ServiceReference sr = this.cc.getBundleContext().getServiceReference(ClassReader.class);
                if (sr != null) {
                    this.reader = (ClassReader)this.cc.getBundleContext().getService(sr);
                }
                if (this.reader == null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Couldn't find annotation reader service", (Object[])new Object[0]);
                }
            }
            if (this.reader != null) {
                try {
                    return this.annotationScanner.getAnnotatedClasses(this.reader);
                }
                catch (UnableToAdaptException sr) {
                    void u;
                    FFDCFilter.processException((Throwable)sr, (String)"com.ibm.ws.rest.api.discovery.SwaggerWebProvider", (String)"225", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception during annotation scanning: " + u.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return Collections.emptySet();
    }

    public void setNonDefaultHostPort(String nonDefaultHostPort) {
        this.nonDefaultHostPort = nonDefaultHostPort;
    }

    private Swagger getSwaggerDocFromAnnotatedClasses(Set<ScannedClass> classes, Swagger swaggerStubDoc) {
        if (classes != null && !classes.isEmpty() && this.reader != null) {
            return this.annotationScanner.getSwaggerDocFromAnnotatedClasses(this.reader, classes, swaggerStubDoc);
        }
        return swaggerStubDoc;
    }

    private Swagger setContextRoot(Swagger swagger) {
        String path;
        Map paths;
        String contextRoot = this.getContextRoot();
        if (contextRoot == null) {
            return swagger;
        }
        String basePath = swagger.getBasePath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current basePath:" + basePath), (Object[])new Object[0]);
        }
        if ((basePath == null || basePath.isEmpty() || basePath.equals("/")) && (paths = swagger.getPaths()) != null && !paths.isEmpty() && !(path = (String)paths.keySet().iterator().next()).startsWith(contextRoot)) {
            swagger.setBasePath(contextRoot);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"set the contextRoot as the basePath", (Object[])new Object[0]);
            }
        }
        return swagger;
    }

    /*
     * WARNING - void declaration
     */
    private String processAndSerialize(Swagger swagger) {
        if (swagger == null) {
            return null;
        }
        this.setContextRoot(swagger);
        this.processHostPort(swagger);
        try {
            if (this.docType == APIProvider.DocType.Swagger_20_YAML) {
                this.cachedDoc = Yaml.mapper().writeValueAsString((Object)swagger);
                return this.cachedDoc;
            }
            this.cachedDoc = Json.mapper().writeValueAsString((Object)swagger);
            return this.cachedDoc;
        }
        catch (JsonProcessingException jsonProcessingException) {
            FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.rest.api.discovery.SwaggerWebProvider", (String)"284", (Object)this, (Object[])new Object[]{swagger});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void e;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Coudn't serialize document. Exception:" + e.getMessage()), (Object[])new Object[0]);
            }
            this.cachedDoc = null;
            return null;
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("SwaggerWebProvider={");
        if (this.moduleURL == null) {
            sb.append("moduleURL=null");
        } else {
            String contextRoot = this.getContextRoot();
            sb.append("contextRoot=");
            sb.append(contextRoot);
            if (contextRoot == null) {
                sb.append("moduleURL=");
                sb.append(this.moduleURL);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    /*
     * WARNING - void declaration
     */
    public String getContextRoot() {
        String contextRoot;
        block2: {
            contextRoot = null;
            try {
                contextRoot = this.moduleURL.startsWith("/") ? this.moduleURL : new URL(this.moduleURL).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                void e;
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.rest.api.discovery.SwaggerWebProvider", (String)"341", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)"Coudn't create context root URL: ", (Object[])new Object[]{e});
            }
        }
        return contextRoot;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        PROPS.put("service.vendor", "IBM");
    }

    @Trivial
    private final class GetPathAction
    implements PrivilegedExceptionAction<String> {
        private GetPathAction() {
        }

        @Override
        public String run() throws Exception {
            return new URL(SwaggerWebProvider.this.moduleURL).getPath();
        }
    }
}

