/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.CustomCSSWABUpdater;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import v2.io.swagger.models.Info;
import v2.io.swagger.models.Swagger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class CustomCSSProcessor {
    private static final TraceComponent tc = Tr.register(CustomCSSProcessor.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private static final String IBM_CSS_EXTENSION_KEY = "x-ibm-css";
    private static final String SWAGGER_SECTION_START = ".swagger-section #header {";
    private static final String SWAGGER_SECTION_END = "}";
    private final CustomCSSWABUpdater updater;
    private volatile String customCSSURL = null;
    private final ConcurrentLinkedQueue<CSSUpdate> cssUpdates = new ConcurrentLinkedQueue();
    static final long serialVersionUID = 9147402354814071347L;

    public CustomCSSProcessor(CustomCSSWABUpdater updater) {
        this.updater = updater;
    }

    @FFDCIgnore(value={IOException.class, SecurityException.class, MalformedLocationException.class, IllegalArgumentException.class})
    public void process(Swagger swg, WsLocationAdmin locationAdmin, ScheduledExecutorService executor) {
        block11: {
            String cssLocation = this.getCSSLocation(swg);
            if (cssLocation != null) {
                try {
                    WsResource resource = locationAdmin.resolveResource(cssLocation);
                    String uri = resource.toExternalURI().toString();
                    if (uri.equals(this.customCSSURL)) break block11;
                    try {
                        InputStream is = resource.get();
                        String content = this.getSwaggerSectionHeader(is);
                        if (content != null) {
                            HashMap<String, Object> cssData = new HashMap<String, Object>();
                            cssData.put("header-css-url", uri);
                            cssData.put("header-css-content", content);
                            CSSUpdate update = new CSSUpdate();
                            update.updateData = cssData;
                            this.cssUpdates.add(update);
                            this.customCSSURL = uri;
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"CSS_SWAGGER_SECTION_NOT_FOUND", (Object[])new Object[]{uri});
                        }
                    }
                    catch (IOException ioe) {
                        Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, ioe.getClass().getName(), ioe.getMessage()});
                    }
                    catch (SecurityException se) {
                        Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, se.getClass().getName(), se.getMessage()});
                    }
                }
                catch (MalformedLocationException mle) {
                    Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{cssLocation, ((Object)((Object)mle)).getClass().getName(), mle.getMessage()});
                }
                catch (IllegalArgumentException iae) {
                    Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{cssLocation, iae.getClass().getName(), iae.getMessage()});
                }
            } else if (this.customCSSURL != null) {
                CSSUpdate update = new CSSUpdate();
                this.cssUpdates.add(update);
                this.customCSSURL = null;
            }
        }
        this.processCSSUpdates(executor);
    }

    private void processCSSUpdates(ScheduledExecutorService executor) {
        if (this.cssUpdates.size() > 0) {
            final CustomCSSProcessor cssUpdator = this;
            Runnable bundleUpdater = new Runnable(){
                static final long serialVersionUID = 1319660695307590901L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CustomCSSProcessor customCSSProcessor = cssUpdator;
                    synchronized (customCSSProcessor) {
                        Iterator it = CustomCSSProcessor.this.cssUpdates.iterator();
                        while (it.hasNext()) {
                            CSSUpdate update = (CSSUpdate)it.next();
                            if (update.updateData != null) {
                                CustomCSSProcessor.this.updater.update(update.updateData);
                            } else {
                                CustomCSSProcessor.this.updater.restoreDefaults();
                            }
                            it.remove();
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
                }
            };
            executor.execute(bundleUpdater);
        }
    }

    private String getCSSLocation(Swagger swg) {
        Object cssObject;
        Map extensions;
        Info info = swg.getInfo();
        if (info != null && (extensions = info.getVendorExtensions()) != null && (cssObject = extensions.get(IBM_CSS_EXTENSION_KEY)) instanceof String) {
            return (String)cssObject;
        }
        return null;
    }

    private String getSwaggerSectionHeader(InputStream is) throws IOException {
        int endIndex;
        String content = this.getContent(is);
        int startIndex = content.indexOf(SWAGGER_SECTION_START, 0);
        if (startIndex != -1 && (endIndex = content.indexOf(SWAGGER_SECTION_END, startIndex)) != -1) {
            return content.substring(startIndex, endIndex + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(InputStream is) throws IOException {
        try (Reader reader = null;){
            int c;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((c = reader.read()) != -1) {
                builder.append((char)c);
            }
            String string = builder.toString();
            return string;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class CSSUpdate {
        Map<String, Object> updateData;
        static final long serialVersionUID = -618715609238185855L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CSSUpdate.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
        }
    }
}

