/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.CustomCSSWABUpdater;
import com.ibm.ws.rest.api.discovery.internal.SwaggerUIBundlesUpdater;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CustomCSSWABUpdater.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class CustomCSSWABUpdaterImpl
implements CustomCSSWABUpdater {
    private static final TraceComponent tc = Tr.register(CustomCSSWABUpdaterImpl.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    protected static final String PATH_CSS_CUSTOM_HEADER = "css/custom-header.css";
    protected static final String PATH_CSS_DEFAULT_HEADER = "css/default-header.css";
    private static final String PATH_CSS_IMAGES_CUSTOM_LOGO = "css/images/custom-logo.png";
    private static final String PATH_IMAGES_CUSTOM_LOGO = "images/custom-logo.png";
    private static final String EXPECTED_BACKGROUND_IMAGE = "background-image: url(images/custom-logo.png);";
    static final long serialVersionUID = -7300534655543585796L;

    /*
     * WARNING - void declaration
     */
    @Override
    public void restoreDefaults() {
        block3: {
            try {
                HashMap<String, Object> filesToUpdate = new HashMap<String, Object>();
                filesToUpdate.put(PATH_CSS_CUSTOM_HEADER, PATH_CSS_DEFAULT_HEADER);
                SwaggerUIBundlesUpdater.updateResources(filesToUpdate);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Updated the Swagger UI bundles with the default CSS file", (Object[])new Object[0]);
                }
            }
            catch (Exception filesToUpdate) {
                void e;
                FFDCFilter.processException((Throwable)filesToUpdate, (String)"com.ibm.ws.rest.api.discovery.internal.CustomCSSWABUpdaterImpl", (String)"56", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception restoring default CSS headers in WAB", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()});
            }
        }
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    public void update(Map<String, Object> cssData) {
        Object cssUrlObj = cssData.get("header-css-url");
        try {
            HashMap<String, Object> filesToUpdate = new HashMap<String, Object>();
            String cssContent = (String)cssData.get("header-css-content");
            filesToUpdate.put(PATH_CSS_CUSTOM_HEADER, cssContent);
            if (cssContent.contains("background-image:") && cssUrlObj != null && cssUrlObj instanceof String) {
                this.processBackgroundImage((String)cssUrlObj, cssContent, filesToUpdate);
            }
            SwaggerUIBundlesUpdater.updateResources(filesToUpdate);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Updated the Swagger UI bundles with the custom CSS file " + cssUrlObj), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Tr.warning((TraceComponent)tc, (String)"CUSTOM_CSS_NOT_PROCESSED", (Object[])new Object[]{cssUrlObj.toString(), e.getClass().getName(), e.getLocalizedMessage()});
            this.restoreDefaults();
        }
    }

    private void processBackgroundImage(String cssUrl, String cssContent, Map<String, Object> filesToUpdate) throws URISyntaxException, IOException {
        if (!cssContent.contains(EXPECTED_BACKGROUND_IMAGE)) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"UNSUPPORTED_CSS_VALUE", (Object[])new Object[]{"background-image", EXPECTED_BACKGROUND_IMAGE}));
        }
        String parentPath = PathUtils.getParent((String)cssUrl);
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath.concat("/");
        }
        String backgroundImagePath = parentPath.concat(PATH_IMAGES_CUSTOM_LOGO);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("backgroundImagePath=" + backgroundImagePath), (Object[])new Object[0]);
        }
        Serializable image = null;
        image = backgroundImagePath.startsWith("http:") || backgroundImagePath.startsWith("https:") ? new URL(backgroundImagePath) : new File(new URI(backgroundImagePath));
        this.validateImage(image);
        filesToUpdate.put(PATH_CSS_IMAGES_CUSTOM_LOGO, image);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Added image to map at css/images/custom-logo.png", (Object[])new Object[0]);
        }
    }

    private void validateImage(Object img) throws IOException {
        if (img != null) {
            if (img instanceof File) {
                File aFile = (File)img;
                if (FileUtils.fileExists((File)aFile) && FileUtils.fileIsFile((File)aFile) && FileUtils.getInputStream((File)aFile) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("File is valid :" + aFile.getAbsolutePath()), (Object[])new Object[0]);
                    }
                    return;
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CSS_BACKGROUND_IMAGE", (Object[])new Object[]{aFile.getAbsolutePath()}));
            }
            if (img instanceof URL) {
                URL url = (URL)img;
                if (SwaggerUIBundlesUpdater.getUrlAsStream(url, "image/png") != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Image at URL is valid :" + url), (Object[])new Object[0]);
                    }
                    return;
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CSS_BACKGROUND_IMAGE", (Object[])new Object[]{url}));
            }
        }
    }
}

