/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SwaggerUIBundlesUpdater {
    private static final TraceComponent tc = Tr.register(SwaggerUIBundlesUpdater.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private static final Set<String> swaggerUIBundleNames = new HashSet<String>();
    static final long serialVersionUID = 5012855240743497520L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void updateResources(Map<String, Object> resourcesToUpdate) throws IOException, BundleException {
        if (resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return;
        }
        Set<Bundle> allSwaggerUIBundles = SwaggerUIBundlesUpdater.getSwaggerUIBundles();
        boolean result = SwaggerUIBundlesUpdater.waitForBundlesToStart(allSwaggerUIBundles);
        if (!result) {
            return;
        }
        Iterator<Bundle> itr = allSwaggerUIBundles.iterator();
        InputStream updatedBundleStream = null;
        while (itr.hasNext()) {
            Bundle swaggerUIBundle = itr.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to process bundle : " + SwaggerUIBundlesUpdater.getBundleDescription(swaggerUIBundle)), (Object[])new Object[0]);
            }
            try {
                updatedBundleStream = SwaggerUIBundlesUpdater.getUpdatedBundleStream(swaggerUIBundle, resourcesToUpdate);
                if (updatedBundleStream == null) continue;
                swaggerUIBundle.update(updatedBundleStream);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Updated bundle : " + SwaggerUIBundlesUpdater.getBundleDescription(swaggerUIBundle)), (Object[])new Object[0]);
            }
            finally {
                FileUtils.tryToClose((Closeable)updatedBundleStream);
                if (swaggerUIBundle.getState() == 32 || swaggerUIBundle.getState() == 8) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bundle is not active: " + SwaggerUIBundlesUpdater.getBundleDescription(swaggerUIBundle)), (Object[])new Object[0]);
                }
                swaggerUIBundle.start();
            }
        }
    }

    private static boolean verifyRefs(ServiceReference<Bundle>[] refs, Set<String> expectedBundles) {
        if (refs == null) {
            return false;
        }
        int foundBundles = 0;
        for (ServiceReference<Bundle> ref : refs) {
            String bundleKey = (String)ref.getProperty("web.module.key");
            String bundleName = bundleKey.substring(0, bundleKey.indexOf(35));
            if (!expectedBundles.contains(bundleName)) continue;
            ++foundBundles;
        }
        return foundBundles == expectedBundles.size();
    }

    private static Set<Bundle> getSwaggerUIBundles() {
        HashSet<Bundle> swaggerUIBundles = new HashSet<Bundle>();
        BundleContext bundleContext = FrameworkUtil.getBundle(SwaggerUIBundlesUpdater.class).getBundleContext();
        if (bundleContext != null) {
            for (Bundle aBundle : bundleContext.getBundles()) {
                String bundleName = aBundle.getSymbolicName();
                if (!swaggerUIBundleNames.contains(bundleName)) continue;
                swaggerUIBundles.add(aBundle);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found a Swagger-UI bundle: " + bundleName), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found " + swaggerUIBundles.size() + " Swagger-UI bundles in bundleContext=" + bundleContext), (Object[])new Object[0]);
        }
        return swaggerUIBundles;
    }

    @Trivial
    private static String getBundleDescription(Bundle bundle) {
        return bundle == null ? "NULL" : "Bundle Name=" + bundle.getSymbolicName() + " : ID=" + bundle.getBundleId() + " : State=" + bundle.getState();
    }

    private static InputStream getUpdatedBundleStream(Bundle bundle, Map<String, Object> resourcesToUpdate) throws IOException {
        if (bundle == null || resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return null;
        }
        Set<String> resourceKeys = resourcesToUpdate.keySet();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bytesOut);
        int totalEntries = 0;
        int nonDirEntries = 0;
        Enumeration enumer = bundle.findEntries("/", "*", true);
        while (enumer.hasMoreElements()) {
            URL aURL = (URL)enumer.nextElement();
            String path = aURL.getPath();
            if (path.startsWith("/") && !path.equals("/")) {
                path = path.substring(1);
            }
            if (!resourceKeys.contains(path)) {
                ++totalEntries;
                ZipEntry anEntry = new ZipEntry(path);
                zipOut.putNextEntry(anEntry);
                if (!anEntry.isDirectory()) {
                    ++nonDirEntries;
                    SwaggerUIBundlesUpdater.writeStreamToZip(aURL.openStream(), zipOut);
                }
                zipOut.closeEntry();
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDumpEnabled()) continue;
            Tr.dump((TraceComponent)tc, (String)("Not processing resource as it'll be overwritten later : " + path), (Object[])new Object[0]);
        }
        for (String path : resourceKeys) {
            ++totalEntries;
            ZipEntry entry = new ZipEntry(path);
            zipOut.putNextEntry(entry);
            if (!entry.isDirectory()) {
                Object resourceValue;
                ++nonDirEntries;
                if (path.equals("css/custom-header.css") && (resourceValue = resourcesToUpdate.get(path)) instanceof String && ((String)resourceValue).equals("css/default-header.css")) {
                    String contents = SwaggerUIBundlesUpdater.getResource(bundle, "css/default-header.css");
                    resourcesToUpdate.put(path, contents);
                }
                SwaggerUIBundlesUpdater.processResource(path, resourcesToUpdate.get(path), zipOut);
            }
            zipOut.closeEntry();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Zip total Entries = " + totalEntries + " : Non-dir entries " + nonDirEntries), (Object[])new Object[0]);
        }
        zipOut.close();
        bytesOut.close();
        return new ByteArrayInputStream(bytesOut.toByteArray());
    }

    private static void processResource(String resourcePath, Object resourceContents, ZipOutputStream zos) throws UnsupportedEncodingException, IOException {
        if (resourceContents != null) {
            if (resourceContents instanceof String) {
                zos.write(((String)resourceContents).getBytes("UTF-8"));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processed (String) resource at " + resourcePath), (Object[])new Object[0]);
                }
                return;
            }
            if (resourceContents instanceof File) {
                File aFile = (File)resourceContents;
                if (FileUtils.fileExists((File)aFile) && FileUtils.fileIsFile((File)aFile)) {
                    SwaggerUIBundlesUpdater.writeStreamToZip(FileUtils.getInputStream((File)aFile), zos);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processed (File) resource at " + resourcePath), (Object[])new Object[0]);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("File is not valid : " + aFile.getAbsolutePath()), (Object[])new Object[0]);
                }
            } else if (resourceContents instanceof URL) {
                SwaggerUIBundlesUpdater.writeStreamToZip(SwaggerUIBundlesUpdater.getUrlAsStream((URL)resourceContents, null), zos);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processed (URL) resource at " + resourcePath), (Object[])new Object[0]);
                }
                return;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (tc.isDumpEnabled()) {
                Tr.dump((TraceComponent)tc, (String)("Resource not processed  : resourcePath=" + resourcePath + " : resourceContents=" + resourceContents), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Resource not processed  : resourcePath=" + resourcePath), (Object[])new Object[0]);
            }
        }
    }

    private static String getResource(Bundle myBundle, String resourcePath) {
        if (myBundle == null) {
            return null;
        }
        String bundleShortDescription = SwaggerUIBundlesUpdater.getBundleDescription(myBundle);
        StringBuilder responseString = new StringBuilder();
        URL bundleResource = myBundle.getResource(resourcePath);
        if (bundleResource != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(bundleResource.openConnection().getInputStream(), "UTF-8"));
                while (br.ready()) {
                    responseString.append(br.readLine());
                }
                br.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerUIBundlesUpdater", (String)"272", null, (Object[])new Object[]{myBundle, resourcePath});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception trying to read resource at " + resourcePath + " from bundle " + bundleShortDescription), (Object[])new Object[0]);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unexpected error getting resource from WAB bundle.", (Object[])new Object[0]);
        }
        return responseString.toString();
    }

    static InputStream getUrlAsStream(URL url, String acceptValue) throws IOException {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (acceptValue != null && !acceptValue.trim().isEmpty()) {
            connection.setRequestProperty("Accept", acceptValue);
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            return connection.getInputStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Did not find resource at " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static void writeStreamToZip(InputStream stream, ZipOutputStream zos) throws IOException {
        if (stream == null || zos == null) {
            return;
        }
        try {
            int length;
            byte[] buf = new byte[8192];
            while ((length = stream.read(buf)) != -1) {
                zos.write(buf, 0, length);
            }
        }
        finally {
            FileUtils.tryToClose((Closeable)stream);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean waitForBundlesToStart(Set<Bundle> swagegerBundles) {
        boolean waitComplete;
        block4: {
            waitComplete = false;
            HashSet<String> expectedBundleNames = new HashSet<String>();
            for (Bundle bundle : swagegerBundles) {
                expectedBundleNames.add(bundle.getSymbolicName());
            }
            try {
                BundleContext bundleContext = FrameworkUtil.getBundle(SwaggerUIBundlesUpdater.class).getBundleContext();
                ServiceReference[] refs = bundleContext.getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
                waitComplete = SwaggerUIBundlesUpdater.verifyRefs(refs, expectedBundleNames);
                while (!waitComplete) {
                    refs = bundleContext.getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
                    waitComplete = SwaggerUIBundlesUpdater.verifyRefs(refs, expectedBundleNames);
                    if (waitComplete) continue;
                    Thread.sleep(500L);
                }
            }
            catch (Exception bundleContext) {
                void e;
                FFDCFilter.processException((Throwable)bundleContext, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerUIBundlesUpdater", (String)"340", null, (Object[])new Object[]{swagegerBundles});
                waitComplete = false;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Failed waiting for API Discovery bundles before update failed with :", (Object[])new Object[]{e.getMessage()});
            }
        }
        return waitComplete;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        swaggerUIBundleNames.add("com.ibm.ws.rest.api.discovery.ui");
        swaggerUIBundleNames.add("com.ibm.ws.rest.api.discovery.ui.public");
        swaggerUIBundleNames.add("com.ibm.ws.rest.api.discovery.collective.ui");
        swaggerUIBundleNames.add("com.ibm.ws.rest.api.discovery.collective.ui.public");
    }
}

