/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.ClassReader;
import com.ibm.ws.rest.api.discovery.ScannedClass;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import v2.io.swagger.models.Swagger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SwaggerWebAnnotationScanner {
    private static final TraceComponent tc = Tr.register(SwaggerWebAnnotationScanner.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private static final String SWAGGER_API_ANNOTATION_CLASS_NAME = "io.swagger.annotations.Api";
    private static final String SWAGGER_DEF_ANNOTATION_CLASS_NAME = "io.swagger.annotations.SwaggerDefinition";
    private static final String JAX_RS_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.Path";
    private static final String JAX_RS_APPLICATION_CLASS_NAME = "javax.ws.rs.core.Application";
    private static final String JAX_RS_APPLICATION_INIT_PARAM = "javax.ws.rs.Application";
    private static final String JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.ApplicationPath";
    private final ClassLoader webModuleClassLoader;
    private final WebAnnotations webAnnotations;
    private Set<Class<?>> annotatedClasses;
    private Set<ScannedClass> scannedClasses;
    private final WebAppConfig appConfig;
    static final long serialVersionUID = 2736858118656168276L;

    public SwaggerWebAnnotationScanner(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        WebModuleInfo moduleInfo = (WebModuleInfo)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebModuleInfo.class);
        this.webModuleClassLoader = moduleInfo.getClassLoader();
        this.webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)containerToAdapt);
        WebModuleMetaData webMetaData = (WebModuleMetaData)containerToAdapt.adapt(WebModuleMetaData.class);
        this.appConfig = webMetaData.getConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    public boolean getHasAnnotatedClasses() {
        try {
            return !this.getAnnotatedClasses().isEmpty();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner", (String)"74", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void u;
                Tr.event((TraceComponent)tc, (String)("Exception during annotation scanning: " + u.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    private synchronized Set<Class<?>> getAnnotatedClasses() throws UnableToAdaptException {
        if (this.annotatedClasses == null) {
            AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
            HashSet restAPIClasses = new HashSet();
            restAPIClasses.addAll(annotationTargets.getAnnotatedClasses(SWAGGER_API_ANNOTATION_CLASS_NAME, AnnotationTargets_Targets.POLICY_SEED));
            restAPIClasses.addAll(annotationTargets.getAnnotatedClasses(SWAGGER_DEF_ANNOTATION_CLASS_NAME, AnnotationTargets_Targets.POLICY_SEED));
            restAPIClasses.addAll(annotationTargets.getAnnotatedClasses(JAX_RS_PATH_ANNOTATION_CLASS_NAME, AnnotationTargets_Targets.POLICY_SEED));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Found annotated classes: ", (Object[])new Object[]{restAPIClasses});
            }
            HashSet classes = new HashSet();
            for (String className : restAPIClasses) {
                try {
                    classes.add(this.webModuleClassLoader.loadClass(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner", (String)"106", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)("Failed to load class " + className + " returned from the annotation scanner."), (Object[])new Object[0]);
                }
            }
            this.annotatedClasses = Collections.unmodifiableSet(classes);
        }
        return this.annotatedClasses;
    }

    private String getUrlMappingFromServlet(IServletConfig sconfig) {
        if (sconfig.getMappings() != null && sconfig.getMappings().size() > 0) {
            String urlMapping = (String)sconfig.getMappings().get(0);
            if (!urlMapping.startsWith("/")) {
                urlMapping = "/" + urlMapping;
            }
            if (urlMapping.endsWith("/*")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 2);
            }
            if (urlMapping.endsWith("/")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + urlMapping + " in web.xml for " + sconfig.getServletName()), (Object[])new Object[0]);
            }
            return urlMapping;
        }
        return null;
    }

    private String getUrlMappingFromApp(String appName) throws UnableToAdaptException {
        AnnotationInfo aInf;
        ClassInfo cInf = this.webAnnotations.getClassInfo(appName);
        if (cInf != null && (aInf = cInf.getAnnotation(JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME)) != null) {
            String annInfoVal = aInf.getValue("value").getStringValue();
            if (annInfoVal.isEmpty() || annInfoVal.equals("/")) {
                return "";
            }
            if (!annInfoVal.startsWith("/")) {
                annInfoVal = "/" + annInfoVal;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + annInfoVal + " in Application classs " + appName), (Object[])new Object[0]);
            }
            return annInfoVal;
        }
        return null;
    }

    private Set<String> getAllApplicationClasses() throws UnableToAdaptException {
        AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
        HashSet<String> applicationClasses = new HashSet<String>();
        applicationClasses.addAll(annotationTargets.getSubclassNames(JAX_RS_APPLICATION_CLASS_NAME));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Found application classes: ", (Object[])new Object[]{applicationClasses});
        }
        return applicationClasses;
    }

    private String getServletForDefaultApplication() {
        IServletConfig servletConfig = this.appConfig.getServletInfo(JAX_RS_APPLICATION_CLASS_NAME);
        if (servletConfig != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Found servlet javax.ws.rs.core.Application", (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return null;
    }

    private String findServletMappingForApp(String appClassName) throws UnableToAdaptException {
        if (appClassName == null) {
            return null;
        }
        IServletConfig servletConfig = this.appConfig.getServletInfo(appClassName);
        if (servletConfig != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using servlet-name"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        Iterator servletIterator = this.appConfig.getServletInfos();
        while (servletIterator.hasNext()) {
            servletConfig = (IServletConfig)servletIterator.next();
            String servletClass = servletConfig.getClassName();
            if (servletClass != null && servletClass.equals(appClassName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using sevlet-class"), (Object[])new Object[0]);
                }
                return this.getUrlMappingFromServlet(servletConfig);
            }
            String initParam = servletConfig.getInitParameter(JAX_RS_APPLICATION_INIT_PARAM);
            if (initParam == null || !initParam.equals(appClassName)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using init-param"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return this.getUrlMappingFromApp(appClassName);
    }

    private Class<?> loadWebAppClass(String className) {
        try {
            return this.webModuleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner", (String)"236", (Object)this, (Object[])new Object[]{className});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Failed to load Application class " + className), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public synchronized Set<ScannedClass> getAnnotatedClasses(ClassReader reader) throws UnableToAdaptException {
        HashSet<ScannedClass> scanClasses = new HashSet<ScannedClass>();
        Set<Class<?>> annotated = this.getAnnotatedClasses();
        Set<String> appClassNames = this.getAllApplicationClasses();
        if (appClassNames.size() < 2) {
            String urlMapping = null;
            if (appClassNames.size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Found no Application classes. Trying to find default app servlet", (Object[])new Object[0]);
                }
                urlMapping = this.getServletForDefaultApplication();
            }
            if (appClassNames.size() == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Found one Application class. Trying to find url mapping", (Object[])new Object[0]);
                }
                urlMapping = this.findServletMappingForApp(appClassNames.iterator().next());
            }
            for (Class<?> cls : annotated) {
                ScannedClass scls = new ScannedClass(cls, urlMapping);
                scanClasses.add(scls);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Found multiple Application classes", (Object[])new Object[0]);
            }
            for (String appClassName : appClassNames) {
                String urlMapping;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Processing Application class " + appClassName), (Object[])new Object[0]);
                }
                if ((urlMapping = this.findServletMappingForApp(appClassName)) == null) continue;
                Set<Class<?>> classes = null;
                Class<?> appClass = this.loadWebAppClass(appClassName);
                if (appClass != null) {
                    classes = reader.getClassesFromApplication(appClass);
                    if (classes == null) {
                        classes = new HashSet();
                    }
                    classes.add(appClass);
                }
                if (classes == null) continue;
                for (Class<?> cls : classes) {
                    if (!annotated.contains(cls)) continue;
                    ScannedClass scls = new ScannedClass(cls, urlMapping);
                    scanClasses.add(scls);
                }
            }
        }
        this.scannedClasses = Collections.unmodifiableSet(scanClasses);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Finished scanning for annotated classes", (Object[])new Object[0]);
        }
        return this.scannedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Swagger getSwaggerDocFromAnnotatedClasses(ClassReader reader, Set<ScannedClass> classes, Swagger swaggerStubDoc) {
        AtomicReference<ClassLoader> classLoaderRef = SwaggerWebAnnotationScanner.getContextClassLoader();
        try {
            if (classLoaderRef != null) {
                SwaggerWebAnnotationScanner.setContextClassLoader(this.webModuleClassLoader);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The current thread's context ClassLoader cannot be set to the web module's ClassLoader.", (Object[])new Object[0]);
            }
            Swagger swagger = null;
            swagger = swaggerStubDoc != null ? reader.read(swaggerStubDoc, classes) : reader.read(classes);
            Swagger swagger2 = swagger;
            return swagger2;
        }
        finally {
            if (classLoaderRef != null) {
                SwaggerWebAnnotationScanner.setContextClassLoader(classLoaderRef.get());
            }
        }
    }

    private static AtomicReference<ClassLoader> getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<AtomicReference<ClassLoader>>(){
            static final long serialVersionUID = -711722948243531803L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public AtomicReference<ClassLoader> run() {
                try {
                    return new AtomicReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner$1", (String)"349", (Object)this, (Object[])new Object[0]);
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 944677055231338632L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                try {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner$2", (String)"362", (Object)this, (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        });
    }
}

