/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal.mbean;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.rest.api.discovery.APIDiscoveryMBean;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryCollectiveController;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIDiscovery.class, EventHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"jmx.objectname=WebSphere:feature=apiDiscovery,name=APIDiscovery", "publishAttributesToCollectiveController=true", "service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publishStatus/mbean", "event.filter=(mbeanObjectName=WebSphere:feature=apiDiscovery,name=APIDiscovery)"})
public class APIDiscovery
extends StandardMBean
implements APIDiscoveryMBean,
EventHandler {
    private static final TraceComponent tc = Tr.register(APIDiscovery.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    static final String KEY_EVENT_ADMIN = "eventAdmin";
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private static final String DOCUMENTATION_URL_PATH = "/ibm/api/docs";
    private static final String EXPLORER_URL_PATH = "/ibm/api/explorer";
    private static final String DOCS_CONTEXT_PATH_SUFFIX = "/docs";
    private static final String EXPLORER_CONTEXT_PATH_SUFFIX = "/explorer";
    private String PrivateDocumentationURL = null;
    private String PrivateExplorerURL = null;
    private String DocumentationURL = null;
    private String ProtectedDocumentationURL = null;
    private String ExplorerURL = null;
    private String ProtectedExplorerURL = null;
    private String CorsConfig = null;
    private boolean isCollectiveController = false;
    private String hostName = null;
    private String httpPort = null;
    private String httpsPort = null;
    private String publicURL;
    static final long serialVersionUID = -6153774628113564771L;

    public APIDiscovery() throws NotCompliantMBeanException {
        super(APIDiscoveryMBean.class, false);
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) throws IOException {
        this.eventAdminRef.activate(context);
        this.publishURLs();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"APIDiscoveryMBean has been fully activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        EventAdmin eventAdmin;
        if (!FrameworkState.isStopping() && (eventAdmin = this.getEventAdmin()) != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("operation", "DELETE");
            props.put("mbeanObjectName", "WebSphere:feature=apiDiscovery,name=APIDiscovery");
            eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/mbean", props));
        }
        this.eventAdminRef.deactivate(context);
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
        this.publishURLs();
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    protected EventAdmin getEventAdmin() {
        return (EventAdmin)this.eventAdminRef.getService();
    }

    @Reference(service=APIDiscoveryCollectiveController.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setAPIDiscoveryCollectiveController(APIDiscoveryCollectiveController controller) {
        this.isCollectiveController = true;
        this.CorsConfig = this.getCorsValue();
        this.publishCollectiveInfo();
    }

    protected void unsetAPIDiscoveryCollectiveController(APIDiscoveryCollectiveController controller) {
        this.isCollectiveController = false;
        this.CorsConfig = null;
        this.publishCollectiveInfo();
    }

    private void publishCollectiveInfo() {
        this.publishAttribute("CorsConfig", this.CorsConfig);
    }

    public String getDocumentationURL() {
        return this.DocumentationURL;
    }

    public String getProtectedDocumentationURL() {
        return this.ProtectedDocumentationURL;
    }

    public String getPrivateDocumentationURL() {
        return this.PrivateDocumentationURL;
    }

    public String getExplorerURL() {
        return this.ExplorerURL;
    }

    public String getProtectedExplorerURL() {
        return this.ProtectedExplorerURL;
    }

    public String getPrivateExplorerURL() {
        return this.PrivateExplorerURL;
    }

    public String getCorsConfig() {
        return this.CorsConfig;
    }

    public synchronized void setPublicURL(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new publicURL=" + value), (Object[])new Object[0]);
        }
        this.publicURL = value;
        this.updateURLs();
    }

    private void publishAttribute(String attributeName, Object attributeValue) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            this.publishAttribute(eventAdmin, attributeName, attributeValue);
        }
    }

    private void publishAttribute(EventAdmin eventAdmin, String attributeName, Object attributeValue) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", "UPDATE");
        props.put("sendStatusEvent", "true");
        props.put("mbeanObjectName", "WebSphere:feature=apiDiscovery,name=APIDiscovery");
        props.put("mbeanAttributeName", attributeName);
        props.put("mbeanAttributeValue", attributeValue);
        eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/mbean", props));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Updated APIDiscoveryMBean attribute : mbeanAttributeName=" + attributeName + " : mbeanAttributeValue=" + attributeValue), (Object[])new Object[0]);
        }
    }

    public void handleEvent(Event statusEvent) {
        String attributeName = (String)statusEvent.getProperty("mbeanAttributeName");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Attribute Published: " + attributeName), (Object[])new Object[0]);
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateHostPortValues(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateHostPortValues(vhost, props);
    }

    private synchronized void updateHostPortValues(VirtualHost vhost, Map<String, Object> props) {
        Object value = props.get("httpsAlias");
        if (value == null) {
            Object[] aliases = (String[])props.get("aliases");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + Arrays.toString(aliases)), (Object[])new Object[0]);
            }
            for (Object anAlias : aliases) {
                if (((String)anAlias).endsWith(":-1")) continue;
                value = anAlias;
                break;
            }
        }
        String alias = String.valueOf(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        this.hostName = vhost.getHostName(alias);
        this.httpPort = Integer.toString(vhost.getHttpPort(alias));
        this.httpsPort = Integer.toString(vhost.getSecureHttpPort(alias));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("New hostName=" + this.hostName + " : httpPort=" + this.httpPort + " : httpsPort=" + this.httpsPort), (Object[])new Object[0]);
        }
        this.updateURLs();
    }

    private void updateURLs() {
        this.updateURLValues();
        if (this.isCollectiveController) {
            this.CorsConfig = this.getCorsValue();
        }
        this.publishURLs();
    }

    private void publishURLs() {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin != null) {
            if (this.DocumentationURL != null) {
                this.publishAttribute(eventAdmin, "DocumentationURL", this.DocumentationURL);
            }
            if (this.ProtectedDocumentationURL != null) {
                this.publishAttribute(eventAdmin, "ProtectedDocumentationURL", this.ProtectedDocumentationURL);
            }
            if (this.PrivateDocumentationURL != null) {
                this.publishAttribute(eventAdmin, "PrivateDocumentationURL", this.PrivateDocumentationURL);
            }
            if (this.ExplorerURL != null) {
                this.publishAttribute(eventAdmin, "ExplorerURL", this.ExplorerURL);
            }
            if (this.ProtectedExplorerURL != null) {
                this.publishAttribute(eventAdmin, "ProtectedExplorerURL", this.ProtectedExplorerURL);
            }
            if (this.PrivateExplorerURL != null) {
                this.publishAttribute(eventAdmin, "PrivateExplorerURL", this.PrivateExplorerURL);
            }
            if (this.CorsConfig != null) {
                this.publishAttribute(eventAdmin, "CorsConfig", this.CorsConfig);
            }
        }
    }

    private String getCorsValue() {
        String corsValue = "";
        if (this.hostName != null) {
            if (!(this.httpPort == null || this.httpPort.isEmpty() || this.httpPort.equals("-1") || this.httpPort.equals("0"))) {
                corsValue = "http://" + this.hostName + ":" + this.httpPort;
            }
            if (!(this.httpsPort == null || this.httpsPort.isEmpty() || this.httpsPort.equals("-1") || this.httpsPort.equals("0"))) {
                String seperationValue = corsValue.isEmpty() ? "" : ",";
                corsValue = corsValue + seperationValue + "https://" + this.hostName + ":" + this.httpsPort;
            }
        }
        return corsValue;
    }

    private void updateURLValues() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Update URL values : hostName=" + this.hostName + " : httpPort=" + this.httpPort + " : httpsPort=" + this.httpsPort + " : publicURL=" + this.publicURL), (Object[])new Object[0]);
        }
        if (this.hostName != null) {
            if (!(this.publicURL == null || this.httpPort == null || this.httpPort.isEmpty() || this.httpPort.equals("-1") || this.httpPort.equals("0"))) {
                this.DocumentationURL = "http://" + this.hostName + ":" + this.httpPort + this.publicURL + DOCS_CONTEXT_PATH_SUFFIX;
                this.ExplorerURL = "http://" + this.hostName + ":" + this.httpPort + this.publicURL + EXPLORER_CONTEXT_PATH_SUFFIX;
            }
            if (this.httpsPort != null && !this.httpsPort.isEmpty()) {
                if (!this.httpsPort.equals("0") && !this.httpsPort.equals("-1")) {
                    this.PrivateDocumentationURL = "https://" + this.hostName + ":" + this.httpsPort + DOCUMENTATION_URL_PATH;
                    this.PrivateExplorerURL = "https://" + this.hostName + ":" + this.httpsPort + EXPLORER_URL_PATH;
                    if (this.publicURL != null) {
                        this.ProtectedDocumentationURL = "https://" + this.hostName + ":" + this.httpsPort + this.publicURL + DOCS_CONTEXT_PATH_SUFFIX;
                        this.ProtectedExplorerURL = "https://" + this.hostName + ":" + this.httpsPort + this.publicURL + EXPLORER_CONTEXT_PATH_SUFFIX;
                    }
                } else {
                    if (this.PrivateDocumentationURL != null) {
                        this.PrivateDocumentationURL = null;
                        this.publishAttribute("PrivateDocumentationURL", this.PrivateDocumentationURL);
                    }
                    if (this.PrivateExplorerURL != null) {
                        this.PrivateExplorerURL = null;
                        this.publishAttribute("PrivateExplorerURL", this.PrivateExplorerURL);
                    }
                    if (this.ProtectedDocumentationURL != null) {
                        this.ProtectedDocumentationURL = null;
                        this.publishAttribute("ProtectedDocumentationURL", this.ProtectedDocumentationURL);
                    }
                    if (this.ProtectedExplorerURL != null) {
                        this.ProtectedExplorerURL = null;
                        this.publishAttribute("ProtectedExplorerURL", this.ProtectedExplorerURL);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Attributes : DocumentationURL=" + this.DocumentationURL + " : ExplorerURL=" + this.ExplorerURL + " : PrivateDocumentationURL=" + this.PrivateDocumentationURL + " : PrivateExplorerURL=" + this.PrivateExplorerURL + " : ProtectedDocumentationURL=" + this.ProtectedDocumentationURL + " : ProtectedExplorerURL=" + this.ProtectedExplorerURL), (Object[])new Object[0]);
            }
        }
    }
}

