/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.internal.module;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.json2yaml.JSON2YAML;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryUtils;
import com.ibm.ws.rest.api.discovery.SwaggerWebProvider;
import com.ibm.ws.rest.api.discovery.internal.SwaggerWebAnnotationScanner;
import com.ibm.ws.rest.api.discovery.internal.config.APIDiscoveryWebModuleDoc;
import com.ibm.ws.rest.api.discovery.internal.config.APIDiscoveryWebModuleDocListener;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.interceptor.RequestInterceptor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ModuleMetaDataListener.class, ContainerAdapter.class, VirtualHostListener.class, RequestInterceptor.class}, immediate=true, property={"service.vendor=IBM", "toType=com.ibm.ws.rest.api.discovery.SwaggerWebProvider", "InterceptPoint=OnFileNotFound"})
public class APIModuleListener
implements ModuleMetaDataListener,
ContainerAdapter<SwaggerWebProvider>,
VirtualHostListener,
RequestInterceptor,
APIDiscoveryWebModuleDocListener {
    private static final TraceComponent tc = Tr.register(APIModuleListener.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private final String DEFAULT_SWAGGER_JSON_LOCATION = "META-INF/swagger.json";
    private final String DEFAULT_SWAGGER_JSON_STUB_LOCATION = "META-INF/stub/swagger.json";
    private final String DEFAULT_SWAGGER_YAML_LOCATION = "META-INF/swagger.yaml";
    private final String DEFAULT_SWAGGER_YAML_STUB_LOCATION = "META-INF/stub/swagger.yaml";
    ConcurrentHashMap<String, APIDiscoveryWebModuleDoc> webModuleDocsConfig = new ConcurrentHashMap();
    private ComponentContext context;
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final ConcurrentHashMap<String, SwaggerWebProvider> webAPIProviders = new ConcurrentHashMap();
    private static final List<String> contextRootsToIgnore = new ArrayList<String>();
    private static final String KEY_JSON2YAML = "json2yaml";
    private final AtomicServiceReference<JSON2YAML> json2yamlRef = new AtomicServiceReference("json2yaml");
    private ScheduledFuture<?> scheduledWabProcessor;
    static final long serialVersionUID = -8310909578669478064L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        this.json2yamlRef.activate(context);
        this.executorServiceRef.activate(context);
        this.scheduledWabProcessor = this.getExecutorService().scheduleWithFixedDelay(new Runnable(){
            static final long serialVersionUID = 9065594781740160146L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    APIModuleListener.this.processWABs();
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.rest.api.discovery.internal.module.APIModuleListener$1", (String)"144", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Exception while processing WABs: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    throw new RuntimeException((Throwable)e);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        }, 2L, 1L, TimeUnit.SECONDS);
        this.getExecutorService().schedule(new Runnable(){
            static final long serialVersionUID = -1966489443188302889L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Running fail-safe routine to cleanup scheduler", (Object[])new Object[0]);
                }
                APIModuleListener.this.cancelScheduler();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        }, 60L, TimeUnit.SECONDS);
        APIDiscoveryWebModuleDoc.addListener(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        APIDiscoveryWebModuleDoc.removeListener(this);
        this.json2yamlRef.deactivate(context);
        this.executorServiceRef.deactivate(context);
        this.context = null;
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    private ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"ScheduledExecutorService"}));
        }
        return service;
    }

    @Reference(service=APIDiscoveryWebModuleDoc.class, name="apiDiscoveryWebModuleDoc", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        this.webModuleDocsConfig.put(apiDiscoveryWebModuleDoc.getContextRoot(), apiDiscoveryWebModuleDoc);
        this.processConfigToSwaggerAssociation(apiDiscoveryWebModuleDoc);
    }

    private void processConfigToSwaggerAssociation(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        String contextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        SwaggerWebProvider swagger = this.getSwaggerFromRoot(contextRoot);
        if (swagger != null) {
            swagger.setDocURL(apiDiscoveryWebModuleDoc.getDocURL());
            swagger.setIsPublic(apiDiscoveryWebModuleDoc.isPublic());
            swagger.setEnabled(apiDiscoveryWebModuleDoc.getEnabled());
        }
    }

    @Override
    public void modifyApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc, String oldContextRoot) {
        String newContextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        if (!oldContextRoot.equals(newContextRoot)) {
            APIDiscoveryWebModuleDoc webModDoc;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Changing the association of " + apiDiscoveryWebModuleDoc + " from " + oldContextRoot + " to " + newContextRoot), (Object[])new Object[0]);
            }
            if ((webModDoc = this.webModuleDocsConfig.get(oldContextRoot)) != null && webModDoc.equals(apiDiscoveryWebModuleDoc)) {
                SwaggerWebProvider swagger = this.getSwaggerFromRoot(oldContextRoot);
                if (swagger != null) {
                    swagger.setDocURL(null);
                    swagger.setIsPublic(true);
                    swagger.setEnabled(true);
                }
                this.webModuleDocsConfig.remove(oldContextRoot);
            }
            this.webModuleDocsConfig.put(newContextRoot, apiDiscoveryWebModuleDoc);
        }
        this.processConfigToSwaggerAssociation(apiDiscoveryWebModuleDoc);
    }

    protected void unsetApiDiscoveryWebModuleDoc(APIDiscoveryWebModuleDoc apiDiscoveryWebModuleDoc) {
        String contextRoot = apiDiscoveryWebModuleDoc.getContextRoot();
        this.webModuleDocsConfig.remove(contextRoot);
        SwaggerWebProvider swagger = this.getSwaggerFromRoot(contextRoot);
        if (swagger != null) {
            swagger.setDocURL(null);
            swagger.setIsPublic(true);
            swagger.setEnabled(true);
        }
    }

    @Reference(service=JSON2YAML.class, name="json2yaml")
    protected void setJSON2YAML(ServiceReference<JSON2YAML> j2y) {
        this.json2yamlRef.setReference(j2y);
    }

    protected void unsetJSON2YAML(ServiceReference<JSON2YAML> j2y) {
        this.json2yamlRef.unsetReference(j2y);
    }

    private JSON2YAML getJSON2YAMLService() {
        JSON2YAML service = (JSON2YAML)this.json2yamlRef.getService();
        if (service == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"JSON2YAML"}));
        }
        return service;
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata created for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            this.processModule(contextRoot, event.getContainer());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processModule(String contextRoot, Container container) {
        SwaggerWebProvider swagger;
        for (String ignore : contextRootsToIgnore) {
            if (!contextRoot.equals(ignore)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Matched ignored root: " + ignore), (Object[])new Object[0]);
            }
            return true;
        }
        try {
            swagger = (SwaggerWebProvider)container.adapt(SwaggerWebProvider.class);
        }
        catch (UnableToAdaptException ignore) {
            void e;
            FFDCFilter.processException((Throwable)ignore, (String)"com.ibm.ws.rest.api.discovery.internal.module.APIModuleListener", (String)"327", (Object)this, (Object[])new Object[]{contextRoot, container});
            throw new RuntimeException((Throwable)e);
        }
        if (swagger == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unable to adapt contextRoot " + contextRoot), (Object[])new Object[0]);
            }
            return false;
        }
        SwaggerWebProvider oldSwagger = this.webAPIProviders.putIfAbsent(contextRoot, swagger);
        if (oldSwagger != null) {
            swagger = oldSwagger;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Added into the map {" + contextRoot + "," + swagger + "}"), (Object[])new Object[0]);
        }
        return true;
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata destroyed for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            SwaggerWebProvider swagger = this.webAPIProviders.remove(contextRoot);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Removed from map {" + contextRoot + "," + swagger + "}"), (Object[])new Object[0]);
            }
            if (swagger != null) {
                swagger.setEnabled(false);
            }
        }
    }

    public SwaggerWebProvider adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        boolean hasStubDoc = false;
        APIProvider.DocType docType = APIProvider.DocType.Swagger_20_JSON;
        Entry myEntry = this.getEntry("META-INF/swagger.json", containerToAdapt);
        if (myEntry == null && (myEntry = this.getEntry("META-INF/swagger.yaml", containerToAdapt)) != null) {
            docType = APIProvider.DocType.Swagger_20_YAML;
        }
        if (myEntry == null && (myEntry = this.getEntry("META-INF/stub/swagger.json", containerToAdapt)) != null) {
            hasStubDoc = true;
        }
        if (myEntry == null && (myEntry = this.getEntry("META-INF/stub/swagger.yaml", containerToAdapt)) != null) {
            hasStubDoc = true;
            docType = APIProvider.DocType.Swagger_20_YAML;
        }
        SwaggerWebAnnotationScanner scanner = new SwaggerWebAnnotationScanner(root, rootOverlay, artifactContainer, containerToAdapt);
        return new SwaggerWebProvider(this.context, myEntry == null ? null : (InputStream)myEntry.adapt(InputStream.class), hasStubDoc, scanner, docType);
    }

    private SwaggerWebProvider getSwaggerFromRoot(String contextRoot) {
        return this.webAPIProviders.get(contextRoot);
    }

    public void contextRootAdded(String contextRoot, VirtualHost virtualHost) {
        SwaggerWebProvider swagger = this.getSwaggerFromRoot(contextRoot = APIDiscoveryUtils.normalizeContextRoot(contextRoot));
        if (swagger != null) {
            APIDiscoveryWebModuleDoc config;
            String moduleURL = virtualHost.getUrlString(contextRoot, false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to update moduleURL: " + moduleURL), (Object[])new Object[0]);
            }
            swagger.setModuleURL(moduleURL.endsWith("/") ? moduleURL.substring(0, moduleURL.length() - 1) : moduleURL);
            if (!"default_host".equals(virtualHost.getName())) {
                int protocolIndex = moduleURL.indexOf("://");
                int contextRootIndex = moduleURL.lastIndexOf(contextRoot);
                swagger.setNonDefaultHostPort(moduleURL.substring(protocolIndex + 3, contextRootIndex));
            }
            if ((config = this.webModuleDocsConfig.get(contextRoot)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Found an existing configuration for this context root.  Update swagger obj.", (Object[])new Object[0]);
                }
                swagger.setDocURL(config.getDocURL());
                swagger.setIsPublic(config.isPublic());
                swagger.setEnabled(config.getEnabled());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No existing configuration found, just enable the swagger obj.", (Object[])new Object[0]);
                }
                swagger.setEnabled(true);
            }
        }
    }

    public void contextRootRemoved(String contextRoot, VirtualHost virtualHost) {
    }

    private Entry getEntry(String pathAndName, Container containerToAdapt) {
        Entry myEntry = containerToAdapt.getEntry(pathAndName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (myEntry != null) {
                Tr.debug((TraceComponent)tc, (String)("Found " + pathAndName + ", with size: " + myEntry.getSize()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)(pathAndName + " was not found."), (Object[])new Object[0]);
            }
        }
        return myEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean requestSwaggerYAML;
        boolean processRequest = false;
        boolean requestSwaggerJSON = request.getPathInfo().equals("/swagger.json");
        boolean bl = requestSwaggerYAML = request.getPathInfo().equals("/swagger.yaml");
        if (requestSwaggerJSON || requestSwaggerYAML) {
            String contextRoot = request.getContextPath();
            SwaggerWebProvider provider = this.getSwaggerFromRoot(contextRoot);
            String swagger = null;
            if (provider != null) {
                String docURL = provider.getDocURL();
                if ((requestSwaggerJSON && "/swagger.json".equals(docURL) || requestSwaggerYAML && "/swagger.yaml".equals(docURL)) && provider.getCachedDoc() == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Avoid looping around : provider=" + provider + " : docURL=" + docURL + " : request=" + request), (Object[])new Object[0]);
                    }
                } else {
                    swagger = provider.getDocument(requestSwaggerJSON ? APIProvider.DocType.Swagger_20_JSON : APIProvider.DocType.Swagger_20_YAML);
                    if (swagger == null && (swagger = provider.getDocument(requestSwaggerJSON ? APIProvider.DocType.Swagger_20_YAML : APIProvider.DocType.Swagger_20_JSON)) != null) {
                        try {
                            swagger = requestSwaggerJSON ? this.getJSON2YAMLService().createJSON(swagger) : this.getJSON2YAMLService().createYAML(swagger);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rest.api.discovery.internal.module.APIModuleListener", (String)"543", (Object)this, (Object[])new Object[]{request, response});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                void e;
                                Tr.event((TraceComponent)tc, (String)("Exception occurred during conversion. requestSwaggerJSON=" + requestSwaggerJSON + " : swagger=" + swagger + " \n exception=" + e), (Object[])new Object[0]);
                            }
                            swagger = null;
                        }
                    }
                }
            }
            PrintWriter writer = null;
            try {
                writer = response.getWriter();
                if (swagger != null) {
                    writer.write(swagger);
                } else {
                    response.setStatus(404);
                    writer.write(Tr.formatMessage((TraceComponent)tc, (String)"SWAGGER_NOT_FOUND", (Object[])new Object[]{requestSwaggerJSON ? "/swagger.json" : "/swagger.yaml"}));
                }
                processRequest = true;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rest.api.discovery.internal.module.APIModuleListener", (String)"563", (Object)this, (Object[])new Object[]{request, response});
                processRequest = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to write master Swagger to response. isSwaggerJSON=" + requestSwaggerJSON + " : \n response=" + response + " : \n exception=" + e), (Object[])new Object[0]);
                }
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
        }
        return processRequest;
    }

    protected void processWABs() throws InvalidSyntaxException {
        if (this.context == null) {
            return;
        }
        ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
        if (refs != null) {
            for (ServiceReference ref : refs) {
                String contextRoot = (String)ref.getProperty("installed.wab.contextRoot");
                Container container = (Container)ref.getProperty("installed.wab.container");
                SwaggerWebProvider swagger = this.getSwaggerFromRoot(contextRoot);
                if (swagger != null) continue;
                boolean processedModule = this.processModule(contextRoot, container);
                if (!processedModule) {
                    return;
                }
                swagger = this.getSwaggerFromRoot(contextRoot);
                if (swagger == null) continue;
                swagger.setModuleURL(contextRoot);
                swagger.setEnabled(true);
            }
        }
        this.getExecutorService().execute(new Runnable(){
            static final long serialVersionUID = -4870183027944035979L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Finished processing WABs, so cleaning up scheduler", (Object[])new Object[0]);
                }
                APIModuleListener.this.cancelScheduler();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        });
    }

    private void cancelScheduler() {
        if (!this.scheduledWabProcessor.isCancelled()) {
            this.scheduledWabProcessor.cancel(true);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        contextRootsToIgnore.add("/ibm/api");
        contextRootsToIgnore.add("/ibm/api/docs/subscription/websocket");
        contextRootsToIgnore.add("/ibm/api/explorer");
        contextRootsToIgnore.add("/ibm/api/collective/explorer");
        contextRootsToIgnore.add("/IBMJMXConnectorREST");
    }
}

