/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.connector.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.connector.ConnectorProvider;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.ServiceManager;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import com.ibm.wsspi.rtcomm.service.sip.UABridge;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.ibm.ws.rtcomm.connector"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={ConnectorProvider.class}, property={"service.vendor=IBM"})
public class ConnectorProviderImpl
implements ConnectorProvider {
    private static final TraceComponent tc = Tr.register(ConnectorProviderImpl.class, (String)"Rtcomm", (String)"com.ibm.ws.rtcomm.resources.Rtcomm");
    private RtcommRegistry registry = null;
    private ServiceManager serviceManager = null;
    private boolean sslConfigReady = false;
    private static Timer timer = new Timer(true);
    private static String messageServerHost = null;
    private static String messageServerPort = null;
    private static String backupMessageServerHost = null;
    private static String backupMessageServerPort = null;
    private static Boolean sslEnabled = false;
    private static String sslRef = null;
    private static String connectionTimeout = null;
    private static Map<String, Object> localProperties = null;
    private static final int SSL_CONFIG_CHECK = 1000;
    private static TimerTask checkSSLConfigurationTimerTask = null;

    @Activate
    protected void activate(Map<String, Object> properties, ComponentContext context) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"ACTIVATE", (Object[])new Object[]{this.getClass().getSimpleName(), "properties=" + properties});
        }
        this.initialize(properties, context);
    }

    private void initialize(Map<String, Object> properties, ComponentContext context) {
        messageServerHost = (String)properties.get("messageServerHost");
        messageServerPort = properties.get("messageServerPort").toString();
        backupMessageServerHost = (String)properties.get("backupMessageServerHost");
        backupMessageServerPort = properties.get("backupMessageServerPort").toString();
        connectionTimeout = (String)properties.get("connectionTimeout");
        sslEnabled = (Boolean)properties.get("sslEnabled");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslEnabled = " + sslEnabled), (Object[])new Object[0]);
        }
        if (sslEnabled.booleanValue()) {
            sslRef = (String)properties.get("sslRef");
            if (sslRef != null && sslRef.isEmpty()) {
                sslRef = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslRef = " + sslRef), (Object[])new Object[0]);
            }
            localProperties = new HashMap<String, Object>();
            localProperties.putAll(properties);
            checkSSLConfigurationTimerTask = new CheckSSLConfigurationTimerTask();
            timer.schedule(checkSSLConfigurationTimerTask, 1000L, 1000L);
        } else {
            this.startRTComm(properties);
        }
    }

    @Override
    public void sslConfigEnabled() {
        this.sslConfigReady = true;
    }

    @Override
    public boolean isSSLEnabled() {
        return sslEnabled;
    }

    @Override
    public String getSSLRef() {
        return sslRef;
    }

    @Override
    public String getMessageServerHost() {
        return messageServerHost;
    }

    @Override
    public String getMessageServerPort() {
        return messageServerPort;
    }

    private void startRTComm(Map<String, Object> properties) {
        String alternateEndpointRoutingEnabledString;
        Boolean alternateEndpointRoutingEnabled;
        String useProtocol = "tcp";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"startRTComm:", (Object[])new Object[0]);
        }
        if (tc.isErrorEnabled()) {
            String[] errorString = new String[1];
            if (messageServerHost == null || messageServerHost.isEmpty()) {
                errorString[0] = messageServerHost;
                Tr.error((TraceComponent)tc, (String)"CWRTC0004E", (Object[])errorString);
            }
            if (messageServerPort == null || messageServerPort.isEmpty() || messageServerPort.compareTo("0") == 0) {
                errorString[0] = messageServerPort;
                Tr.error((TraceComponent)tc, (String)"CWRTC0005E", (Object[])errorString);
            }
        }
        if (sslEnabled.booleanValue()) {
            useProtocol = "ssl";
        }
        String messageServerURL = useProtocol + "://" + messageServerHost + ":" + messageServerPort;
        String backupMessageServerURL = null;
        backupMessageServerURL = backupMessageServerHost.isEmpty() ? messageServerURL : useProtocol + "://" + backupMessageServerHost + ":" + backupMessageServerPort;
        if (connectionTimeout != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connectionTimeout = " + connectionTimeout), (Object[])new Object[0]);
            }
            int intConnectionTimeout = Integer.parseInt(connectionTimeout);
            RTCommProvider.setConnectionTimeout((int)intConnectionTimeout);
        }
        if ((alternateEndpointRoutingEnabled = Boolean.valueOf(alternateEndpointRoutingEnabledString = properties.get("alternateEndpointRoutingEnabled").toString())).booleanValue()) {
            String rtcommTopicPath = (String)properties.get("rtcommTopicPath");
            String topicName = (String)properties.get("alternateEndpointRoutingTopicName");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("alternateEndpointRoutingTopicName = " + topicName), (Object[])new Object[0]);
            }
            if (topicName != null && !topicName.isEmpty()) {
                this.registry.setAlternateEndpointRoutingTopic(rtcommTopicPath + topicName);
            }
        }
        this.serviceManager = ServiceManager.createServiceManager(properties, (String)messageServerURL, (String)backupMessageServerURL, (RtcommRegistry)this.registry);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RTComm Feature initialized", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"MODIFIED", (Object[])new Object[]{this.getClass().getSimpleName(), "properties=" + properties});
        }
        if (this.serviceManager != null) {
            this.serviceManager.destroy();
            this.initialize(properties, null);
        }
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext context) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"DEACTIVATE", (Object[])new Object[]{this.getClass().getSimpleName(), "reason=" + reason});
        }
        if (this.serviceManager != null) {
            this.serviceManager.destroy();
            this.serviceManager = null;
        }
        SipGateway.destory();
    }

    @Reference(name="RtcommRegistry", service=RtcommRegistry.class, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setRtcommRegistry(RtcommRegistry p) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"SET", (Object[])new Object[]{this.getClass().getSimpleName(), "p=" + p, "prev=" + this.registry});
        }
        this.registry = p;
    }

    protected void unsetRtcommRegistry(RtcommRegistry p) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"UNSET", (Object[])new Object[]{this.getClass().getSimpleName(), "p=" + p, "prev=" + this.registry});
        }
        if (this.registry == p) {
            this.registry = null;
        }
    }

    @Reference(name="LocMgr")
    protected void setLocMgr(WsLocationAdmin ref) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("setLocMgr: ServerId = " + ref.getServerId()), (Object[])new Object[0]);
        }
        RTCommProvider.setServerID((String)ref.getServerId().toString());
    }

    protected void unsetLocMgr(WsLocationAdmin ref) {
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setUABridge(UABridge sipUaBridge) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setUaBridge = " + sipUaBridge), (Object[])new Object[0]);
        }
        SipGateway.setSipUaBridge((UABridge)sipUaBridge);
    }

    protected synchronized void unsetUABridge(UABridge sipUaBridge) {
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin ca) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConfigurationAdmin ", (Object[])new Object[]{ca});
        }
        ServiceManager.getConfigadminref().set(ca);
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin ca) {
        ServiceManager.getConfigadminref().compareAndSet(ca, null);
    }

    public class CheckSSLConfigurationTimerTask
    extends TimerTask {
        private int SSL_CONFIG_TIMEOUT = 20000;
        int numTries = 0;

        @Override
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CheckSSLConfigurationTimerTask", (Object[])new Object[0]);
            }
            boolean cancelTimer = false;
            ++this.numTries;
            if (ConnectorProviderImpl.this.sslConfigReady) {
                ConnectorProviderImpl.this.startRTComm(localProperties);
                cancelTimer = true;
            } else if (this.numTries * 1000 >= this.SSL_CONFIG_TIMEOUT) {
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"CWRTC0011E", (Object[])null);
                }
                cancelTimer = true;
            }
            if (cancelTimer) {
                checkSSLConfigurationTimerTask = null;
                this.cancel();
            }
        }
    }
}

