/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.registry.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.registry.internal.RtcommEndpointDocumentImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.RTCommProviderListener;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistryListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.ibm.ws.rtcomm.registry"}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, service={RtcommRegistry.class}, property={"service.vendor=IBM"})
public class RtcommRegistryImpl
extends RtcommRegistry
implements RTCommProviderListener {
    private static final TraceComponent tc = Tr.register(RtcommRegistryImpl.class);
    private int endpointRegistrationTimeout = 120000;
    private Vector<RtcommRegistryListener> listenerVector = new Vector();
    private RTCommProvider provider = null;
    private Hashtable<String, Hashtable<String, RtcommEndpointDocumentImpl>> registrationTable = new Hashtable();
    private RtcommEndpointDocumentImpl alternateEndpointRoutingDocument = null;
    private boolean registryEnabled = true;

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"ACTIVATE", (Object[])new Object[]{this.getClass().getSimpleName(), "properties=" + properties});
        }
    }

    @Deactivate
    protected void deactivate(int reason) {
        block4: {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"DEACTIVATE", (Object[])new Object[]{this.getClass().getSimpleName(), "reason=" + reason});
            }
            if (this.provider != null) {
                try {
                    this.provider.unregisterListener((RTCommProviderListener)this);
                    this.provider = null;
                }
                catch (RTCommException ex) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred unregistering from provider   ex = " + (Object)((Object)ex)), (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void setAlternateEndpointRoutingTopic(String topic) {
        if (topic != null && !topic.isEmpty()) {
            this.alternateEndpointRoutingDocument = new RtcommEndpointDocumentImpl(this, null);
            this.alternateEndpointRoutingDocument.setContact(topic);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("alternateEndpintRouting is enabled.   topic = " + topic), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"alternateEndpintRouting is NOT enabled", (Object[])new Object[0]);
        }
    }

    @Override
    public void disableRegistry() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Registry is being disabled.", (Object[])new Object[0]);
        }
        this.registryEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEndpointDocument(RtcommEndpointDocument document) {
        Cloneable cloneable;
        String endpointID = null;
        String appContext = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding document to registry.  endpoint <" + document.getEndpointID() + ">   appContext <" + document.getAppContext() + ">   sphereTopicName <" + document.getSphereTopic() + ">"), (Object[])new Object[0]);
        }
        if (this.registryEnabled) {
            cloneable = this.registrationTable;
            synchronized (cloneable) {
                endpointID = document.getEndpointID();
                Hashtable<String, RtcommEndpointDocumentImpl> endpointTable = this.registrationTable.get(endpointID);
                if (endpointTable == null) {
                    endpointTable = new Hashtable();
                    this.registrationTable.put(endpointID, endpointTable);
                }
                RtcommEndpointDocumentImpl documentImpl = null;
                if (endpointTable.containsKey(document.getAppContext()) && (documentImpl = endpointTable.remove(document.getAppContext())) != null) {
                    documentImpl.destroy();
                }
                appContext = document.getAppContext();
                documentImpl = (RtcommEndpointDocumentImpl)document;
                endpointTable.put(appContext, documentImpl);
                int timeout = documentImpl.getTimeout();
                if (timeout != 0) {
                    documentImpl.startTimer(timeout);
                }
            }
        }
        cloneable = this.listenerVector;
        synchronized (cloneable) {
            for (int i = 0; i < this.listenerVector.size(); ++i) {
                this.listenerVector.get(i).endpointAdded(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEndpointDocument(String endpointID, String sphereTopicName) {
        RtcommEndpointDocument document = null;
        if (this.registryEnabled) {
            Hashtable<String, Hashtable<String, RtcommEndpointDocumentImpl>> hashtable = this.registrationTable;
            synchronized (hashtable) {
                Hashtable<String, RtcommEndpointDocumentImpl> endpointTable = this.registrationTable.get(endpointID);
                if (endpointTable != null) {
                    Enumeration<String> keyEnum = endpointTable.keys();
                    while (keyEnum.hasMoreElements()) {
                        String key = keyEnum.nextElement();
                        document = endpointTable.get(key);
                        String tempSphereTopic = document.getSphereTopic();
                        if (tempSphereTopic != null && sphereTopicName.compareTo(tempSphereTopic) == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("removing document from registry.  endpoint <" + document.getEndpointID() + ">   appContext <" + document.getAppContext() + ">   sphereTopicName <" + document.getSphereTopic() + ">"), (Object[])new Object[0]);
                            }
                            endpointTable.remove(key);
                            if (!endpointTable.isEmpty()) break;
                            this.registrationTable.remove(endpointID);
                            break;
                        }
                        document = null;
                    }
                }
            }
        } else {
            document = this.createEndpointDocument(endpointID);
        }
        if (document != null) {
            this.notifyListenerOfRemoval(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtcommEndpointDocument getDocument(String endpointID, String appContext) {
        RtcommEndpointDocumentImpl documentImpl = null;
        String tempAppContext = appContext;
        if (tempAppContext == null) {
            tempAppContext = "";
        }
        Hashtable<String, Hashtable<String, RtcommEndpointDocumentImpl>> hashtable = this.registrationTable;
        synchronized (hashtable) {
            Hashtable<String, RtcommEndpointDocumentImpl> endpointTable = this.registrationTable.get(endpointID);
            if (endpointTable != null && (documentImpl = endpointTable.get(tempAppContext)) == null) {
                if (tempAppContext.compareTo("") == 0) {
                    documentImpl = endpointTable.elements().nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to find endpoint (" + endpointID + "/" + tempAppContext + ") --  returning alternate appContext document"), (Object[])new Object[0]);
                    }
                } else {
                    documentImpl = endpointTable.get("");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to find endpoint (" + endpointID + "/" + tempAppContext + ") --  returning NO appContext document"), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (documentImpl == null && this.alternateEndpointRoutingDocument != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to find endpoint.    Returning alternateEndpointRoutingDocument", (Object[])new Object[0]);
            }
            documentImpl = this.alternateEndpointRoutingDocument;
        }
        return documentImpl;
    }

    @Override
    public RtcommEndpointDocument createEndpointDocument(String endpointID) {
        RtcommEndpointDocumentImpl document = new RtcommEndpointDocumentImpl(this, endpointID);
        document.setTimeout(this.endpointRegistrationTimeout);
        return document;
    }

    @Override
    public void setRegistrationTimeout(int endpointRegistrationTimeout) {
        if (endpointRegistrationTimeout != 0) {
            this.endpointRegistrationTimeout = endpointRegistrationTimeout * 1000;
        }
    }

    @Override
    public int getRegistrationTimeout() {
        return this.endpointRegistrationTimeout / 1000;
    }

    @Override
    public void setSphereTopicName(String primaryMessageServerURL, String secondaryMessageServerURL, String sphereTopicName) {
        block3: {
            if (this.provider == null) {
                this.provider = RTCommProvider.createRTCommProvider((String)primaryMessageServerURL, (String)secondaryMessageServerURL);
                try {
                    this.provider.registerListener((RTCommProviderListener)this, null, null, sphereTopicName);
                }
                catch (RTCommException ex) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred registering Listener = " + (Object)((Object)ex)), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointDocumentTimedOut(String endpointID, String appContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpointDocumentTimedOut:  endpointID = " + endpointID + "  appContext = " + appContext), (Object[])new Object[0]);
        }
        RtcommEndpointDocumentImpl documentImpl = null;
        String tempAppContext = appContext;
        if (tempAppContext == null) {
            tempAppContext = "";
        }
        Hashtable<String, Hashtable<String, RtcommEndpointDocumentImpl>> hashtable = this.registrationTable;
        synchronized (hashtable) {
            Hashtable<String, RtcommEndpointDocumentImpl> endpointTable = this.registrationTable.get(endpointID);
            if (endpointTable != null) {
                documentImpl = endpointTable.remove(tempAppContext);
                if (endpointTable.isEmpty()) {
                    this.registrationTable.remove(endpointID);
                }
            }
        }
        if (documentImpl != null) {
            this.notifyListenerOfRemoval(documentImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RtcommRegistryListener listener) {
        Vector<RtcommRegistryListener> vector = this.listenerVector;
        synchronized (vector) {
            this.listenerVector.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RtcommRegistryListener listener) {
        Vector<RtcommRegistryListener> vector = this.listenerVector;
        synchronized (vector) {
            this.listenerVector.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerOfRemoval(RtcommEndpointDocument document) {
        Vector<RtcommRegistryListener> vector = this.listenerVector;
        synchronized (vector) {
            for (int i = 0; i < this.listenerVector.size(); ++i) {
                this.listenerVector.get(i).endpointRemoved(document);
            }
        }
    }

    public void messageReceived(String sphereTopicName, JSONObject content) {
        String fromEndpointID = null;
        if (sphereTopicName.contains("/")) {
            int slash = sphereTopicName.lastIndexOf("/");
            fromEndpointID = sphereTopicName.substring(slash + 1, sphereTopicName.length());
        } else {
            fromEndpointID = sphereTopicName;
        }
        if (content == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("messageReceived:  LWT received for endpoint <" + fromEndpointID + ">"), (Object[])new Object[0]);
            }
            this.removeEndpointDocument(fromEndpointID, sphereTopicName);
            return;
        }
        SigMessage sigMessage = SigProvider.deserializeMessage((JSONObject)content);
        if (sigMessage.getMethod() == SigMessage.SigMethod.DOCUMENT) {
            String versionNumber = sigMessage.getVersion();
            if (versionNumber == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("messageReceived:  DOCUMENT message received without version number --- endpoint <" + fromEndpointID + ">"), (Object[])new Object[0]);
                }
                return;
            }
            if (!sigMessage.isVersionCompatible(null)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("****   Unsupported version number[!=v1.0.0] received = " + versionNumber + "  from endpoint <" + fromEndpointID + ">"), (Object[])new Object[0]);
                }
                return;
            }
            String addressTopic = sigMessage.getAddressTopic();
            if (addressTopic == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("messageReceived:  DOCUMENT message received without addressTopic --- endpoint <" + fromEndpointID + ">"), (Object[])new Object[0]);
                }
                return;
            }
            RtcommEndpointDocument document = this.createEndpointDocument(fromEndpointID);
            document.setVersionNumber(versionNumber);
            document.setContact(addressTopic);
            String appContext = sigMessage.getAppContext();
            if (appContext != null) {
                document.setAppContext(appContext);
            }
            document.setTimeout(0);
            document.setSphereTopic(sphereTopicName);
            RtcommEndpointDocument existingDocument = this.getDocument(fromEndpointID, appContext);
            if (existingDocument != null) {
                String existingFromEndpointID = existingDocument.getEndpointID();
                String existingAppContext = existingDocument.getAppContext();
                if (existingFromEndpointID != null && existingFromEndpointID.compareTo(document.getEndpointID()) == 0 && document.getAppContext().compareTo(existingAppContext) == 0 && document.getContact().compareTo(existingDocument.getContact()) != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"messageReceived:  Sending DOCUMENT_REPLACED to existing client", (Object[])new Object[0]);
                    }
                    SigMessage documentReplaced = SigProvider.createMessage((SigMessage.SigMethod)SigMessage.SigMethod.DOCUMENT_REPLACED, (RTCommProvider)this.provider, (String)existingDocument.getContact());
                    documentReplaced.setFromEndpointID("SERVER");
                    documentReplaced.send();
                }
            }
            this.addEndpointDocument(document);
        }
    }
}

