/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.callqueue.CallQueueServiceImpl;
import com.ibm.ws.rtcomm.service.cc.CallControlServiceImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcConnectorServiceImpl;
import com.ibm.ws.rtcomm.service.sip.SipServiceImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.Service;
import com.ibm.wsspi.rtcomm.service.ServiceManager;
import com.ibm.wsspi.rtcomm.service.rtcconnector.GroupConnectorFactory;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceManagerImpl
extends ServiceManager
implements SigProviderListener {
    private static final TraceComponent tc = Tr.register(ServiceManagerImpl.class);
    private Map<String, Service> serviceMap = new HashMap<String, Service>();
    private SigProvider sigProvider = null;

    public static void setGroupConnectorFactory(GroupConnectorFactory factory) {
        RtcConnectorServiceImpl.setGroupConnectorFactory(factory);
    }

    public ServiceManagerImpl(Map<String, Object> properties, String primaryMessageServerURL, String secondaryMessageServerURL, RtcommRegistry registry) {
        String sharedSubscriptionPrefix;
        String registryEnabledString;
        String rtcommTopicPath = (String)properties.get("rtcommTopicPath");
        if (rtcommTopicPath == null) {
            rtcommTopicPath = "/";
        }
        if (!rtcommTopicPath.endsWith("/")) {
            rtcommTopicPath = rtcommTopicPath + "/";
        }
        if (!Boolean.valueOf(registryEnabledString = properties.get("registryEnabled").toString()).booleanValue()) {
            registry.disableRegistry();
        }
        if ((sharedSubscriptionPrefix = (String)properties.get("sharedSubscriptionPath")) == null || sharedSubscriptionPrefix.isEmpty()) {
            sharedSubscriptionPrefix = "";
        } else if (sharedSubscriptionPrefix.endsWith("/")) {
            sharedSubscriptionPrefix = sharedSubscriptionPrefix.substring(0, sharedSubscriptionPrefix.length() - 1);
        }
        String sphereTopicName = (String)properties.get("sphereTopicName");
        String registryTopicName = null;
        registryTopicName = sharedSubscriptionPrefix.isEmpty() ? rtcommTopicPath + sphereTopicName : sharedSubscriptionPrefix + "_" + sphereTopicName + "/" + rtcommTopicPath + sphereTopicName;
        registry.setSphereTopicName(primaryMessageServerURL, secondaryMessageServerURL, registryTopicName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rtcommTopicPath = " + rtcommTopicPath), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sharedSubscriptionPath = " + sharedSubscriptionPrefix), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sphereTopicName = " + sphereTopicName), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"creating RtcConnector service", (Object[])new Object[0]);
        }
        Service service = RtcConnectorServiceImpl.createService();
        this.serviceMap.put(service.getServiceType(), service);
        service.init(primaryMessageServerURL, secondaryMessageServerURL, rtcommTopicPath, sharedSubscriptionPrefix, true, registry, sphereTopicName);
        service.provisionService(properties);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"constructor:  creating 3PCC service", (Object[])new Object[0]);
        }
        service = CallControlServiceImpl.createService();
        this.serviceMap.put(service.getServiceType(), service);
        service.init(primaryMessageServerURL, secondaryMessageServerURL, rtcommTopicPath, sharedSubscriptionPrefix, true, registry, sphereTopicName);
        service.provisionService(properties);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"constructor:  creating Call Queue service", (Object[])new Object[0]);
        }
        service = CallQueueServiceImpl.createService();
        this.serviceMap.put(service.getServiceType(), service);
        service.init(primaryMessageServerURL, secondaryMessageServerURL, rtcommTopicPath, sharedSubscriptionPrefix, true, registry, sphereTopicName);
        service.provisionService(properties);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"constructor:  creating SIP Connector service", (Object[])new Object[0]);
        }
        service = SipServiceImpl.createService();
        this.serviceMap.put(service.getServiceType(), service);
        service.init(primaryMessageServerURL, secondaryMessageServerURL, rtcommTopicPath, sharedSubscriptionPrefix, true, registry, sphereTopicName);
        service.provisionService(properties);
        String managementTopicName = (String)properties.get("managementTopicName");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("constructor:  managementTopicName = " + managementTopicName), (Object[])new Object[0]);
        }
        this.sigProvider = SigProvider.createSigProvider((String)managementTopicName, (String)rtcommTopicPath, (String)primaryMessageServerURL, (String)secondaryMessageServerURL, (String)rtcommTopicPath, (String)sphereTopicName);
        this.sigProvider.setSigProviderListener((SigProviderListener)this);
    }

    @Override
    public void update(Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"update:  updating rtcomm services", (Object[])new Object[0]);
        }
        Iterator<Service> iterator = this.serviceMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().provisionService(properties);
        }
    }

    @Override
    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy:  destroying rtcomm services", (Object[])new Object[0]);
        }
        Iterator<Service> iterator = this.serviceMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
        this.serviceMap.clear();
        if (this.sigProvider != null) {
            this.sigProvider.destroy();
            this.sigProvider = null;
        }
    }

    public void doRefer(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doRefer:  ServiceManager:   NOT SUPPORTED", (Object[])new Object[0]);
        }
    }

    public void doPranswer(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doPranswer:  ServiceManager:   NOT SUPPORTED", (Object[])new Object[0]);
        }
    }

    public void doServiceQuery(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doServiceQuery: Service query: ", (Object[])new Object[0]);
        }
        JSONObject responseObject = null;
        for (String serviceType : this.serviceMap.keySet()) {
            Service service = this.serviceMap.get(serviceType);
            JSONObject serviceObject = service.queryService();
            if (serviceObject == null) continue;
            if (responseObject == null) {
                responseObject = new JSONObject();
            }
            responseObject.put((Object)serviceType, (Object)serviceObject);
        }
        SigResponseMessage response = this.sigProvider.createResponse(message, fromEndpointID, null);
        if (responseObject != null) {
            response.setServices(responseObject);
        }
        response.setResult(SigResponseMessage.Result.SUCCEEDED);
        response.send();
    }

    public void doResponse(SigProvider provider, String fromEndpointID, SigResponseMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: doResponse: currently unsupported at the ServiceManager.", (Object[])new Object[0]);
        }
    }

    public void doMessage(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: doMessage: currently unsupported at the ServiceManager.", (Object[])new Object[0]);
        }
    }

    public void doStartLeg(SigProvider provider, String fromEndpointID, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: doStartLeg: currently unsupported at the ServiceManager.", (Object[])new Object[0]);
        }
    }

    public void doGroupUpdate(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: doGroupUpdate: currently unsupported at the ServiceManager.", (Object[])new Object[0]);
        }
    }
}

