/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.callqueue;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.callqueue.CallQueueProviderImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventMonitorImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;

public class CallQueueConnectorImpl
implements SigLegListener {
    private static final TraceComponent tc = Tr.register(CallQueueConnectorImpl.class);
    protected static final String LEG_BINDING_ATTRIBUTE_KEY = "legBinding";
    protected SigProvider sigProvider = null;
    protected String connectorID = UUID.randomUUID().toString();
    protected RtcommRegistry registry;
    protected Vector<SigLeg> legVector = new Vector();
    protected CallQueueProviderImpl connectorProvider = null;
    protected String callQueueTopicName = null;
    protected int callRetransmissionTimeout = 0;
    protected int callTimeout = 0;
    SigLeg initialOutboundLeg = null;
    private String queuePosition = null;

    public CallQueueConnectorImpl(String callQueueTopicName, int callRetransmissionTimeout, int callTimeout, SigProvider provider, RtcommRegistry registry, RtcEventMonitorImpl rtcommEventObserver, CallQueueProviderImpl connectorProvider) {
        this.sigProvider = provider;
        this.registry = registry;
        this.connectorProvider = connectorProvider;
        this.callQueueTopicName = callQueueTopicName;
        this.callTimeout = callTimeout * 1000;
        this.callRetransmissionTimeout = callRetransmissionTimeout * 1000;
    }

    public String getConnectorID() {
        return this.connectorID;
    }

    public String addLeg(SigLeg inboundLeg, SigMessage message) {
        inboundLeg.setListener((SigLegListener)this);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg session id = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        String sigSessionID = UUID.randomUUID().toString();
        String clientID = this.sigProvider.getClientID();
        this.initialOutboundLeg = this.sigProvider.createLeg(inboundLeg.getLocalEndpointID(), inboundLeg.getRemoteEndpointID(), message.getProtocols(), message.getPayload(), this.callQueueTopicName + "/" + clientID, message.getAppContext(), (SigLegListener)this, (long)this.callRetransmissionTimeout, (long)this.callTimeout, 0L, message.getTransactionID(), true, sigSessionID, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg2 session id = " + this.initialOutboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        inboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)this.initialOutboundLeg);
        this.initialOutboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)inboundLeg);
        this.legVector.add(inboundLeg);
        this.legVector.add(this.initialOutboundLeg);
        SigMessage pranswer = inboundLeg.createMessage(SigMessage.SigMethod.PRANSWER);
        pranswer.setHoldTimeout(this.callTimeout / 1000);
        if (this.queuePosition != null) {
            pranswer.setQueuePosition(this.queuePosition);
        }
        pranswer.setProtocols(message.getProtocols());
        pranswer.setPayload(message.getPayload());
        pranswer.send();
        return null;
    }

    public void setQueuePosition(String queuePosition) {
        if (this.queuePosition != null && queuePosition.compareTo(this.queuePosition) == 0) {
            return;
        }
        this.queuePosition = queuePosition;
        if (this.initialOutboundLeg != null) {
            SigLeg inboundLeg = this.getAssociatedLeg(this.initialOutboundLeg);
            SigMessage pranswer = inboundLeg.createMessage(SigMessage.SigMethod.PRANSWER);
            pranswer.setHoldTimeout(this.callTimeout / 1000);
            pranswer.setQueuePosition(queuePosition);
            pranswer.send();
        }
    }

    public void activateOutbound() {
        this.initialOutboundLeg.activateOutbound();
    }

    public String getSourceEndpointID() {
        if (this.initialOutboundLeg != null) {
            return this.initialOutboundLeg.getLocalEndpointID();
        }
        return null;
    }

    public void destroy(String reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        if (reason == null) {
            reason = "Server initiated close.";
        }
        Iterator<SigLeg> iterator = this.legVector.iterator();
        while (iterator.hasNext()) {
            iterator.next().stop(reason);
        }
    }

    public void doLegAccepted(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegAccepted: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            inboundLeg.setLocalEndpointID(sigLeg.getRemoteEndpointID());
            inboundLeg.acceptLeg(message.getProtocols(), message.getPayload());
            this.connectorProvider.callQueueConnectorActivateCompleted(this);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionAccepted: WARNING: response could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegRejected(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegRejected: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            outboundLeg.rejectLeg(message.getReason());
            this.legVector.remove(outboundLeg);
            this.connectorProvider.callQueueConnectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionRejected: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doMessage(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doMessage: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            SigMessage outboundMessage = outboundLeg.createMessage(message.getMethod());
            outboundMessage.setPayload(message.getPayload());
            String transactionID = message.getTransactionID();
            if (transactionID != null) {
                outboundMessage.setTransactionID(transactionID);
            }
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doMessage: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegStopped(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg associatedLeg = this.getAssociatedLeg(sigLeg);
        if (associatedLeg != null) {
            associatedLeg.stop(message.getReason());
            this.legVector.remove(sigLeg);
            this.legVector.remove(associatedLeg);
            this.connectorProvider.callQueueConnectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doEndSession: WARNING: end session could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegTimedout(SigProvider provider, SigLeg sigLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegTimedout: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            outboundLeg.rejectLeg(reason);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.callQueueConnectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doLegTimedout: WARNING: timeout could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doPranswer(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doPranswer: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            this.connectorProvider.callQueueConnectorActivateCompleted(this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doPranswer: updating localEndpoint to <" + sigLeg.getRemoteEndpointID() + ">"), (Object[])new Object[0]);
            }
            inboundLeg.setLocalEndpointID(sigLeg.getRemoteEndpointID());
            SigMessage outboundMessage = inboundLeg.createMessage(message.getMethod());
            outboundMessage.setProtocols(message.getProtocols());
            outboundMessage.setPayload(message.getPayload());
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doPranswer: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doICECandidate(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doICECandidate: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            SigMessage outboundMessage = outboundLeg.createMessage(message.getMethod());
            outboundMessage.setPayload(message.getPayload());
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doICECandidate: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void destroyed(SigProvider provider, SigLeg inboundLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyed: sigSessionID = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(inboundLeg)) != null) {
            outboundLeg.stop(reason);
            this.legVector.remove(inboundLeg);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.callQueueConnectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroyed: WARNING: session destroyed could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    protected SigLeg getAssociatedLeg(SigLeg leg) {
        SigLeg outboundLeg = (SigLeg)leg.getAttribute(LEG_BINDING_ATTRIBUTE_KEY);
        if (outboundLeg == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: getAssociatedLeg: No outbound leg found.", (Object[])new Object[0]);
        }
        return outboundLeg;
    }
}

