/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.callqueue;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.ProviderImpl;
import com.ibm.ws.rtcomm.service.callqueue.CallQueueConnectorImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.RTCommProviderListener;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CallQueueProviderImpl
extends ProviderImpl
implements RTCommProviderListener,
SigProviderListener {
    private static final TraceComponent tc = Tr.register(CallQueueProviderImpl.class);
    private Map<String, CallQueueConnectorImpl> callQueueConnectorMap = new HashMap<String, CallQueueConnectorImpl>();
    private RTCommProvider rtCommProvider;
    private String callQueueTopicPath = null;
    private String callQueueTopicName = null;
    private int callTimeout = 0;
    private int callRetransmissionTimeout = 0;
    private SigProvider callQueueSigProvider = null;
    private Vector<String> pendingConnectors = new Vector();
    private String activeConnectorID = null;

    public CallQueueProviderImpl(String endpointID, String callQueueTopicPath, String callQueueTopicName, String callQueueServiceTopicName, int callRetransmissionTimeout, int callTimeout, RTCommProvider rtCommProvider, SigProvider callQueueSigProvider, RtcommRegistry registry) {
        this.rtCommProvider = rtCommProvider;
        this.callQueueTopicPath = callQueueTopicPath;
        this.callQueueTopicName = callQueueTopicName;
        this.callTimeout = callTimeout;
        this.registry = registry;
        this.callQueueSigProvider = callQueueSigProvider;
        this.callRetransmissionTimeout = callRetransmissionTimeout;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("REGISTERING Call Queue Service Topic Name = " + endpointID + " / " + callQueueTopicPath + callQueueServiceTopicName), (Object[])new Object[0]);
        }
        RtcommEndpointDocument document = registry.createEndpointDocument(endpointID);
        document.setContact(callQueueTopicPath + callQueueServiceTopicName);
        document.setTimeout(0);
        registry.addEndpointDocument(document);
        callQueueSigProvider.setSigProviderListener((SigProviderListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        Map<String, CallQueueConnectorImpl> map = this.callQueueConnectorMap;
        synchronized (map) {
            for (CallQueueConnectorImpl connector : this.callQueueConnectorMap.values()) {
                connector.destroy(null);
            }
        }
        if (this.callQueueSigProvider != null) {
            this.callQueueSigProvider.destroy();
            this.callQueueSigProvider = null;
        }
    }

    public void update(String newCallQueueTopicName) {
        block3: {
            try {
                if (!this.callQueueTopicName.equals(newCallQueueTopicName)) {
                    this.rtCommProvider.unregisterListener((RTCommProviderListener)this);
                    this.rtCommProvider.registerListener((RTCommProviderListener)this, newCallQueueTopicName, null, null);
                }
            }
            catch (RTCommException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void doServiceQuery(SigProvider provider, String fromEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doServiceQuery: Service query: ", (Object[])new Object[0]);
        }
        SigResponseMessage response = this.callQueueSigProvider.createResponse(message, fromEndpointID, null);
        response.setResult(SigResponseMessage.Result.SUCCEEDED);
        response.send();
    }

    @Override
    public void doPranswer(SigProvider provider, String toEndpointID, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ERROR: doPranswer: PRANSWER received that is not associated w/ a session.  toEndpointID = " + toEndpointID), (Object[])new Object[0]);
        }
        if (toEndpointID != null) {
            this.clearRetainedMessage(toEndpointID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStartLeg(SigProvider provider, String fromEndpointID, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doStartLeg; received", (Object[])new Object[0]);
        }
        CallQueueConnectorImpl connector = new CallQueueConnectorImpl(this.callQueueTopicPath + this.callQueueTopicName, this.callRetransmissionTimeout, this.callTimeout, this.callQueueSigProvider, this.registry, null, this);
        Map<String, CallQueueConnectorImpl> map = this.callQueueConnectorMap;
        synchronized (map) {
            this.callQueueConnectorMap.put(connector.getConnectorID(), connector);
        }
        if (this.activeConnectorID == null) {
            connector.setQueuePosition("0");
        } else {
            connector.setQueuePosition(Integer.toString(this.pendingConnectors.size() + 1));
        }
        String errorReason = connector.addLeg(sigLeg, message);
        if (errorReason != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ERROR: doStartSession: rejecting leg due to: " + errorReason), (Object[])new Object[0]);
            }
            Map<String, CallQueueConnectorImpl> map2 = this.callQueueConnectorMap;
            synchronized (map2) {
                this.callQueueConnectorMap.remove(connector.getConnectorID());
            }
            SigResponseMessage response = this.callQueueSigProvider.createResponse(message, fromEndpointID, null);
            response.setResult(SigResponseMessage.Result.FAILED);
            response.setReason(errorReason);
            response.send();
        } else {
            Map<String, CallQueueConnectorImpl> map3 = this.callQueueConnectorMap;
            synchronized (map3) {
                if (this.activeConnectorID == null) {
                    this.activeConnectorID = connector.getConnectorID();
                    connector.activateOutbound();
                } else {
                    this.pendingConnectors.add(connector.getConnectorID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callQueueConnectorActivateCompleted(CallQueueConnectorImpl connector) {
        String connectorID = connector.getConnectorID();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("callQueueConnectorActivateCompleted:   (" + connectorID + ")   activeConnectorID = " + this.activeConnectorID), (Object[])new Object[0]);
        }
        Map<String, CallQueueConnectorImpl> map = this.callQueueConnectorMap;
        synchronized (map) {
            if (this.pendingConnectors.contains(connectorID)) {
                this.pendingConnectors.remove(connectorID);
            }
            if (this.activeConnectorID != null && connectorID.compareTo(this.activeConnectorID) == 0) {
                this.activeConnectorID = null;
                this.clearRetainedMessage(connector.getSourceEndpointID());
                if (!this.pendingConnectors.isEmpty()) {
                    this.activeConnectorID = this.pendingConnectors.remove(0);
                    CallQueueConnectorImpl callQueueConnector = this.callQueueConnectorMap.get(this.activeConnectorID);
                    callQueueConnector.setQueuePosition("0");
                    callQueueConnector.activateOutbound();
                }
            }
            this.updateCallQueuePositions();
        }
    }

    private void updateCallQueuePositions() {
        for (int i = 0; i < this.pendingConnectors.size(); ++i) {
            String connectorID = this.pendingConnectors.get(i);
            CallQueueConnectorImpl callQueueConnector = this.callQueueConnectorMap.get(connectorID);
            callQueueConnector.setQueuePosition(Integer.toString(i + 1));
        }
    }

    private void clearRetainedMessage(String endpointID) {
        SigMessage retainMessage = this.callQueueSigProvider.createMessage(SigMessage.SigMethod.MESSAGE, this.callQueueTopicPath + this.callQueueTopicName + "/" + this.callQueueSigProvider.getClientID() + "/" + endpointID, null, null);
        retainMessage.clear();
        retainMessage.setRetain(true);
        retainMessage.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callQueueConnectorDestroyed(String connectorID) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("callQueueConnectorDestroyed:   removing (" + connectorID + ") from callQueueConnectorMap"), (Object[])new Object[0]);
        }
        Map<String, CallQueueConnectorImpl> map = this.callQueueConnectorMap;
        synchronized (map) {
            if (this.callQueueConnectorMap.containsKey(connectorID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"callQueueConnectorDestroyed:   connector successfully removed", (Object[])new Object[0]);
                }
                CallQueueConnectorImpl connector = this.callQueueConnectorMap.remove(connectorID);
                this.callQueueConnectorActivateCompleted(connector);
            }
        }
    }

    public void messageReceived(String topicName, JSONObject message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallQueueProviderImpl:ServiceListener:   MESSAGE RECEIVED = " + message + "  topicName = " + topicName), (Object[])new Object[0]);
        }
    }
}

