/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.callqueue;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.rtcomm.service.callqueue.CallQueueProviderImpl;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.Service;
import com.ibm.wsspi.rtcomm.service.ServiceMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CallQueueServiceImpl
implements Service {
    private static final TraceComponent tc = Tr.register(CallQueueServiceImpl.class);
    private static final String RTCOMM_CALL_QUEUES = "queues";
    private static final String RTCOMM_CALL_QUEUE_TOPIC = "topic";
    private static final String RTCOMM_CALL_QUEUE_ENDPOINT_ID = "endpointID";
    private static final String RTCOMM_CALL_QUEUE_SIGNALING = "signalingTopic";
    private static final String RTCOMM_CALL_QUEUE_DESCRIPTION = "description";
    private static final String CALL_QUEUE_CONFIG = "callQueue";
    private static final String CALL_QUEUE_TOPIC_NAME = "topicName";
    private static final String CALL_QUEUE_SIGNALING_TOPIC_NAME = "signalingTopicName";
    private static final String CALL_QUEUE_ENDPOINT_ID = "callQueueID";
    private static final String CALL_TIMEOUT = "timeout";
    private static final String CALL_QUEUE_DESCRIPTION = "description";
    private static final String CALL_RETRANSMISSION_TIMEOUT = "retransmissionTimeout";
    private static final String CALL_QUEUE_SIGNALING = "Signaling";
    private static final int DEFAULT_CALL_TIMEOUT = 600;
    private static final int DEFAULT_CALL_RETRANSMISSION_TIMEOUT = 30;
    private static CallQueueServiceImpl callQueueService = null;
    private String primaryMessageServerURL = null;
    private String secondaryMessageServerURL = null;
    private String rtcommTopicPath = null;
    private String sharedSubscriptionPath = null;
    private Boolean sharedSubscriptionsEnabled = false;
    private RtcommRegistry registry = null;
    private String sphereTopicName = null;
    private JSONObject serviceObject = null;
    private ArrayList<CallQueueProviderImpl> providerList = new ArrayList();

    public static Service createService() {
        if (callQueueService == null) {
            callQueueService = new CallQueueServiceImpl();
        }
        return callQueueService;
    }

    @Override
    public void init(String primaryURL, String secondaryURL, String rtcommTopicPath, String sharedSubscriptionPath, Boolean sharedSubscriptionsEnabled, RtcommRegistry registry, String sphereTopicName) {
        this.primaryMessageServerURL = primaryURL;
        this.secondaryMessageServerURL = secondaryURL;
        this.rtcommTopicPath = rtcommTopicPath;
        this.sharedSubscriptionPath = sharedSubscriptionPath;
        this.sharedSubscriptionsEnabled = sharedSubscriptionsEnabled;
        this.registry = registry;
        this.sphereTopicName = sphereTopicName;
    }

    @Override
    public void provisionService(Map<String, Object> properties) {
        if (!this.sharedSubscriptionsEnabled.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"shared subscriptions are not enabled.   No call queues will be enabled.", (Object[])new Object[0]);
            }
            return;
        }
        Map<String, List<Map<String, Object>>> nestedConfig = Nester.nest(properties, CALL_QUEUE_CONFIG);
        if (nestedConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Call Queue not provisioned", (Object[])new Object[0]);
            }
            return;
        }
        List<Map<String, Object>> callQueueConfig = nestedConfig.get(CALL_QUEUE_CONFIG);
        if (callQueueConfig == null || callQueueConfig.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Call Queue not provisioned", (Object[])new Object[0]);
            }
            return;
        }
        JSONArray serviceArray = null;
        for (int i = 0; i < callQueueConfig.size(); ++i) {
            Long callTimeoutLong;
            int callTimeout;
            String callQueueSignalingTopicName;
            Map<String, Object> map = callQueueConfig.get(i);
            CallQueueProviderImpl callQueueProvider = null;
            String endpointID = (String)map.get(CALL_QUEUE_ENDPOINT_ID);
            String callQueueTopicName = (String)map.get(CALL_QUEUE_TOPIC_NAME);
            if (callQueueTopicName.isEmpty()) {
                callQueueTopicName = endpointID;
            }
            if ((callQueueSignalingTopicName = (String)map.get(CALL_QUEUE_SIGNALING_TOPIC_NAME)).isEmpty()) {
                callQueueSignalingTopicName = endpointID + CALL_QUEUE_SIGNALING;
            }
            if ((callTimeout = (callTimeoutLong = (Long)map.get(CALL_TIMEOUT)).intValue()) == 0) {
                callTimeout = 600;
            }
            String callQueueDescription = (String)map.get("description");
            String derivedSharedSubscriptionPath = this.sharedSubscriptionPath;
            if (!this.sharedSubscriptionPath.isEmpty()) {
                derivedSharedSubscriptionPath = this.sharedSubscriptionPath + "_" + callQueueTopicName + "/";
            }
            String callRetransmissonTimeoutString = (String)map.get(CALL_RETRANSMISSION_TIMEOUT);
            int callRetransmissionTimeout = 30;
            if (callRetransmissonTimeoutString != null && !callRetransmissonTimeoutString.isEmpty()) {
                callRetransmissionTimeout = Integer.parseInt(callRetransmissonTimeoutString);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("derived Shared Subscription = " + derivedSharedSubscriptionPath + this.rtcommTopicPath + callQueueTopicName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("callQueueEndpointID = " + endpointID), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("callQueueSignalingTopicName = " + callQueueSignalingTopicName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("callTimeout = " + callTimeout), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("callQueueDescription = " + callQueueDescription), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("callRetransmissionTimeout = " + callRetransmissionTimeout), (Object[])new Object[0]);
            }
            if (callQueueTopicName != null && !callQueueTopicName.isEmpty()) {
                RTCommProvider rtcommServiceProvider = RTCommProvider.createRTCommProvider((String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL);
                SigProvider sigProvider = SigProvider.createSigProvider((String)callQueueSignalingTopicName, (String)this.rtcommTopicPath, (String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL, (String)this.rtcommTopicPath, (String)this.sphereTopicName);
                callQueueProvider = new CallQueueProviderImpl(endpointID, this.rtcommTopicPath, callQueueTopicName, callQueueSignalingTopicName, callRetransmissionTimeout, callTimeout, rtcommServiceProvider, sigProvider, this.registry);
                this.providerList.add(callQueueProvider);
                if (serviceArray == null) {
                    serviceArray = new JSONArray();
                }
                JSONObject queue = new JSONObject();
                queue.put((Object)RTCOMM_CALL_QUEUE_TOPIC, (Object)(derivedSharedSubscriptionPath + this.rtcommTopicPath + callQueueTopicName));
                queue.put((Object)RTCOMM_CALL_QUEUE_ENDPOINT_ID, (Object)endpointID);
                queue.put((Object)RTCOMM_CALL_QUEUE_SIGNALING, (Object)(this.rtcommTopicPath + callQueueSignalingTopicName));
                if (callQueueDescription != null) {
                    queue.put((Object)"description", (Object)callQueueDescription);
                }
                serviceArray.add((Object)queue);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Call Queue not provisioned", (Object[])new Object[0]);
        }
        if (serviceArray != null) {
            this.serviceObject = new JSONObject();
            this.serviceObject.put((Object)RTCOMM_CALL_QUEUES, serviceArray);
        }
    }

    @Override
    public void provisionService(ServiceMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"callQueue provisioning via MQTT is NOT currently supported", (Object[])new Object[0]);
        }
    }

    @Override
    public String getServiceType() {
        return "RTCOMM_CALL_QUEUE_SERVICE";
    }

    @Override
    public JSONObject queryService() {
        return this.serviceObject;
    }

    @Override
    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        for (int i = 0; i < this.providerList.size(); ++i) {
            this.providerList.get(i).destroy();
        }
        this.providerList.clear();
    }
}

