/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.cc;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.ProviderImpl;
import com.ibm.ws.rtcomm.service.cc.CallControlMessageImpl;
import com.ibm.ws.rtcomm.service.cc.ReferConnectorImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.RTCommProviderListener;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.HashMap;
import java.util.Map;

public class CallControlProviderImpl
extends ProviderImpl
implements RTCommProviderListener {
    private static final TraceComponent tc = Tr.register(CallControlProviderImpl.class);
    private Map<String, ReferConnectorImpl> referConnectorMap;
    private RTCommProvider rtCommProvider;
    private String callControlTopicName;
    private RtcommRegistry registry;
    private SigProvider referSigProvider;

    public CallControlProviderImpl(String callControlTopicName, RTCommProvider rtCommProvider, SigProvider referSigProvider, RtcommRegistry registry) {
        block2: {
            this.referConnectorMap = new HashMap<String, ReferConnectorImpl>();
            this.callControlTopicName = null;
            this.registry = null;
            this.referSigProvider = null;
            this.rtCommProvider = rtCommProvider;
            this.callControlTopicName = callControlTopicName;
            this.registry = registry;
            this.referSigProvider = referSigProvider;
            referSigProvider.setSigProviderListener((SigProviderListener)this);
            try {
                rtCommProvider.registerListener((RTCommProviderListener)this, callControlTopicName, null, null);
            }
            catch (RTCommException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.rtCommProvider != null) {
            block4: {
                try {
                    this.rtCommProvider.unregisterListener((RTCommProviderListener)this);
                }
                catch (RTCommException e) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
                }
            }
            this.rtCommProvider = null;
        }
        if (this.referSigProvider != null) {
            this.referSigProvider.destroy();
            this.referSigProvider = null;
        }
    }

    public void update(String newCallControlTopicName) {
        block3: {
            try {
                if (!this.callControlTopicName.equals(newCallControlTopicName)) {
                    this.rtCommProvider.unregisterListener((RTCommProviderListener)this);
                    this.rtCommProvider.registerListener((RTCommProviderListener)this, newCallControlTopicName, null, null);
                }
            }
            catch (RTCommException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void referConnectorDestroyed(String connectorID) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("referConnectorDestroyed:   removing (" + connectorID + ") from referConnectorMap"), (Object[])new Object[0]);
        }
        Map<String, ReferConnectorImpl> map = this.referConnectorMap;
        synchronized (map) {
            if (this.referConnectorMap.containsKey(connectorID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connectorDestroyed:   connector successfully removed", (Object[])new Object[0]);
                }
                this.referConnectorMap.remove(connectorID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRefer(CallControlMessageImpl ccMessage, ReferResultObserver resultObserver) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"startRefer: ", (Object[])new Object[0]);
        }
        ReferConnectorImpl connector = new ReferConnectorImpl(this.referSigProvider, this.registry, resultObserver, this);
        Map<String, ReferConnectorImpl> map = this.referConnectorMap;
        synchronized (map) {
            this.referConnectorMap.put(connector.getConnectorID(), connector);
        }
        try {
            connector.start(ccMessage);
        }
        catch (Exception e) {
            this.referConnectorMap.remove(connector.getConnectorID());
        }
    }

    @Override
    public void doResponse(SigProvider provider, String fromEndpointID, SigResponseMessage message) {
        SigResponseMessage.SigResponseType method;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doResponse: SigProvider: " + provider + " fromEndpointID: " + fromEndpointID + " message " + message), (Object[])new Object[0]);
        }
        if ((method = message.getResponseType()) != SigResponseMessage.SigResponseType.REFER_RESPONSE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doResponse: Invalid response received = " + method), (Object[])new Object[0]);
            }
            return;
        }
        String transID = message.getTransactionID();
        for (ReferConnectorImpl connector : this.referConnectorMap.values()) {
            if (!connector.processReferResponse(message, transID)) continue;
            this.referConnectorDestroyed(connector.getConnectorID());
            break;
        }
    }

    public void messageReceived(String topicName, JSONObject message) {
        String method;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServiceListener:   MESSAGE RECEIVED = " + message + "  topicName = " + topicName), (Object[])new Object[0]);
        }
        if ((method = (String)message.get((Object)"method")) != null && method.equals("3PCC_PLACE_CALL")) {
            CallControlMessageImpl ccMessage = new CallControlMessageImpl();
            ccMessage.parse(message);
            if (ccMessage.isVersionCompatible(null)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ServiceListener:  starting refer", (Object[])new Object[0]);
                }
                this.startRefer(ccMessage, new ReferResultObserver(ccMessage));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("****   Unsupported version number received = " + ccMessage.getVersion()), (Object[])new Object[0]);
                }
                ReferResultObserver responder = new ReferResultObserver(ccMessage);
                responder.fireResult("FAILURE", "Incompatible Version Number");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServiceManagerImpl:ServiceListener:  WARNING: unknown message received:" + message), (Object[])new Object[0]);
        }
    }

    public class ReferResultObserver {
        private CallControlMessageImpl referRequest;

        public ReferResultObserver(CallControlMessageImpl referRequest) {
            this.referRequest = referRequest;
        }

        public void fireResult(String result, String reason) {
            block3: {
                try {
                    CallControlMessageImpl responseMessage = new CallControlMessageImpl();
                    responseMessage.setTransactionID(this.referRequest.getTransactionID());
                    responseMessage.setMethod("RESPONSE");
                    responseMessage.setResult(result);
                    if (result.equals("FAILURE")) {
                        responseMessage.setReason(reason);
                    }
                    CallControlProviderImpl.this.rtCommProvider.sendMessage(responseMessage.serialize(), this.referRequest.getFromTopic(), null, false);
                }
                catch (RTCommException e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("publishEvent: ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
                }
            }
        }
    }
}

