/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.cc;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.cc.CallControlProviderImpl;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.Service;
import com.ibm.wsspi.rtcomm.service.ServiceMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import java.util.Map;

public class CallControlServiceImpl
implements Service {
    private static final TraceComponent tc = Tr.register(CallControlServiceImpl.class);
    private static final String RTCOMM_CALL_CONTROL_TOPIC = "topic";
    private String primaryMessageServerURL = null;
    private String secondaryMessageServerURL = null;
    private String rtcommTopicPath = null;
    private RtcommRegistry registry = null;
    private CallControlProviderImpl callControlProvider = null;
    private JSONObject serviceObject = null;
    private String sphereTopicName = null;

    public static Service createService() {
        return new CallControlServiceImpl();
    }

    @Override
    public void init(String primaryURL, String secondaryURL, String rtcommTopicPath, String sharedSubscriptionPath, Boolean sharedSubscriptionsEnabled, RtcommRegistry registry, String sphereTopicName) {
        this.primaryMessageServerURL = primaryURL;
        this.secondaryMessageServerURL = secondaryURL;
        this.rtcommTopicPath = rtcommTopicPath;
        this.registry = registry;
        this.sphereTopicName = sphereTopicName;
    }

    @Override
    public void provisionService(Map<String, Object> properties) {
        String callControlTopicName = (String)properties.get("callControlTopicName");
        if (this.callControlProvider == null) {
            if (!callControlTopicName.isEmpty()) {
                callControlTopicName = this.rtcommTopicPath + callControlTopicName;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create 3PCC provider: callControlTopicName = " + callControlTopicName), (Object[])new Object[0]);
                }
                RTCommProvider rtcommServiceProvider = RTCommProvider.createRTCommProvider((String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL);
                SigProvider referSigProvider = SigProvider.createSigProvider(null, (String)this.rtcommTopicPath, (String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL, (String)this.rtcommTopicPath, (String)this.sphereTopicName);
                this.callControlProvider = new CallControlProviderImpl(callControlTopicName, rtcommServiceProvider, referSigProvider, this.registry);
                this.serviceObject = new JSONObject();
                this.serviceObject.put((Object)RTCOMM_CALL_CONTROL_TOPIC, (Object)callControlTopicName);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"3PCC not provisioned", (Object[])new Object[0]);
            }
        } else {
            this.callControlProvider.update(callControlTopicName);
        }
    }

    @Override
    public void provisionService(ServiceMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"3PCC provisioning via MQTT not supported", (Object[])new Object[0]);
        }
    }

    @Override
    public String getServiceType() {
        return "RTCOMM_CALL_CONTROL_SERVICE";
    }

    @Override
    public JSONObject queryService() {
        return this.serviceObject;
    }

    @Override
    public void destroy() {
        if (this.callControlProvider != null) {
            this.callControlProvider.destroy();
            this.callControlProvider = null;
        }
    }
}

