/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.cc;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.cc.CallControlMessageImpl;
import com.ibm.ws.rtcomm.service.cc.CallControlProviderImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.UUID;

public class ReferConnectorImpl
implements SigLegListener {
    private static final TraceComponent tc = Tr.register(ReferConnectorImpl.class);
    private SigLeg referLeg = null;
    private SigProvider sigProvider = null;
    private RtcommRegistry registry;
    private String connectorID = UUID.randomUUID().toString();
    private CallControlProviderImpl callControlProvider;
    private CallControlProviderImpl.ReferResultObserver resultObserver;
    private String transID = null;

    public ReferConnectorImpl(SigProvider provider, RtcommRegistry registry, CallControlProviderImpl.ReferResultObserver resultObserver, CallControlProviderImpl callControlProvider) {
        this.callControlProvider = callControlProvider;
        this.registry = registry;
        this.resultObserver = resultObserver;
        this.sigProvider = provider;
    }

    public void start(CallControlMessageImpl ccMessage) {
        String calleeEndpoint;
        RtcommEndpointDocument calleeEndpointDocument;
        String callerEndpoint = ccMessage.getCallerEndpoint();
        String appContext = ccMessage.getAppContext();
        if (appContext == null) {
            appContext = "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start:  (" + callerEndpoint + "/" + appContext + ")"), (Object[])new Object[0]);
        }
        RtcommEndpointDocument callerEndpointDocument = this.registry.getDocument(callerEndpoint, appContext);
        String callerEndpointTopic = null;
        if (callerEndpointDocument != null) {
            callerEndpointTopic = callerEndpointDocument.getContact();
            if (callerEndpointTopic == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("start: Caller endpoint (" + callerEndpoint + ") is not registered"), (Object[])new Object[0]);
                }
                this.resultObserver.fireResult("FAILURE", "Unknown caller endpoint");
                throw new IllegalArgumentException("Unknown caller endpoint");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start: Unknown caller endpoint", (Object[])new Object[0]);
            }
            this.resultObserver.fireResult("FAILURE", "Unknown caller endpoint");
            throw new IllegalArgumentException("Unknown caller endpoint");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start: Caller topic pulled from registratiomMap = " + callerEndpointTopic), (Object[])new Object[0]);
        }
        if ((calleeEndpointDocument = this.registry.getDocument(calleeEndpoint = ccMessage.getCalleeEndpoint(), appContext)) != null) {
            String calleeEndpointTopic = calleeEndpointDocument.getContact();
            if (calleeEndpointTopic == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"start: Callee endpoint is not registered", (Object[])new Object[0]);
                }
                this.resultObserver.fireResult("FAILURE", "Unknown callee endpoint");
                throw new IllegalArgumentException("Unknown callee endpoint");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown callee endpoint", (Object[])new Object[0]);
            }
            this.resultObserver.fireResult("FAILURE", "Unknown callee endpoint: " + calleeEndpoint);
            throw new IllegalArgumentException("Unknown callee endpoint");
        }
        JSONObject referDetails = new JSONObject();
        referDetails.put((Object)"toEndpointID", (Object)calleeEndpoint);
        String referSessionID = ccMessage.getSessionID();
        if (referSessionID != null) {
            referDetails.put((Object)"sessionID", (Object)referSessionID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start: create refer leg: callerEndpointTopic: " + callerEndpointTopic), (Object[])new Object[0]);
        }
        SigMessage sigMessage = this.sigProvider.createMessage(SigMessage.SigMethod.REFER, callerEndpointTopic, callerEndpoint, callerEndpoint);
        sigMessage.setDetails(referDetails);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start: Send REFER request to:  " + callerEndpoint), (Object[])new Object[0]);
        }
        this.transID = sigMessage.getTransactionID();
        sigMessage.send();
    }

    public boolean processReferResponse(SigResponseMessage message, String transID) {
        if (this.transID != null && transID.compareTo(this.transID) != 0) {
            return false;
        }
        if (message.getResult().compareTo((Enum)SigResponseMessage.Result.SUCCEEDED) == 0) {
            this.resultObserver.fireResult("SUCCESS", null);
        } else {
            this.resultObserver.fireResult("FAILURE", message.getReason());
        }
        return true;
    }

    public String getConnectorID() {
        return this.connectorID;
    }

    public void doPranswer(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doPranswer: refer is ringing for sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
    }

    public void doLegAccepted(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doLegAccepted: Refer leg accepted!", (Object[])new Object[0]);
        }
        this.resultObserver.fireResult("SUCCESS", null);
        this.referLeg.stop("refer completed");
        this.callControlProvider.referConnectorDestroyed(this.connectorID);
    }

    public void doLegRejected(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegRejected: Refer leg rejected because: " + message.getReason()), (Object[])new Object[0]);
        }
        this.resultObserver.fireResult("FAILURE", message.getReason());
        this.callControlProvider.referConnectorDestroyed(this.connectorID);
    }

    public void doMessage(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doMessage(3PCC): ERROR: no messages should be sent to a Refer signaling leg: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
    }

    public String addLeg(SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: addLeg should never be called for a Refer Connector", (Object[])new Object[0]);
        }
        return null;
    }

    public void destroyed(SigProvider provider, SigLeg inboundLeg, String reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyed: sigSessionID = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        this.callControlProvider.referConnectorDestroyed(this.connectorID);
    }

    public void doLegTimedout(SigProvider provider, SigLeg sigLeg, String reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegTimedout: refer sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        this.resultObserver.fireResult("FAILURE", "Timed out waiting for caller to respond");
        this.callControlProvider.referConnectorDestroyed(this.connectorID);
    }

    public void doICECandidate(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doICECandidate: ERROR: no ICE candidates should be sent to a Refer signaling leg: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
    }

    public void doLegStopped(SigProvider provider, SigLeg sigLeg, SigMessage message) {
    }
}

