/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.rtcconnector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcConnectorProviderImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventMonitorImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;

public class RtcConnectorImpl
implements SigLegListener {
    private static final TraceComponent tc = Tr.register(RtcConnectorImpl.class);
    protected static final String LEG_BINDING_ATTRIBUTE_KEY = "legBinding";
    protected SigProvider sigProvider = null;
    protected String connectorID = UUID.randomUUID().toString();
    protected RtcommRegistry registry;
    protected Vector<SigLeg> legVector = new Vector();
    protected RtcConnectorProviderImpl connectorProvider = null;
    protected RtcEventMonitorImpl rtcommEventObserver = null;

    public RtcConnectorImpl(SigProvider provider, RtcommRegistry registry, RtcEventMonitorImpl rtcommEventObserver, RtcConnectorProviderImpl connectorProvider) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Constructor", (Object[])new Object[0]);
        }
        this.sigProvider = provider;
        this.registry = registry;
        this.rtcommEventObserver = rtcommEventObserver;
        this.connectorProvider = connectorProvider;
    }

    public String getConnectorID() {
        return this.connectorID;
    }

    public String addLeg(SigLeg inboundLeg, SigMessage message) {
        String appContext;
        inboundLeg.setListener((SigLegListener)this);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg session id = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((appContext = message.getAppContext()) == null) {
            appContext = "";
        }
        String toEndpointTopic = null;
        RtcommEndpointDocument document = this.registry.getDocument(inboundLeg.getLocalEndpointID(), appContext);
        if (document != null) {
            toEndpointTopic = document.getContact();
            if (toEndpointTopic == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("endpoint (" + inboundLeg.getLocalEndpointID() + "/" + appContext + ") is not registered"), (Object[])new Object[0]);
                }
                return "Unknown to endpoint received: " + inboundLeg.getLocalEndpointID();
            }
        } else {
            return "Unknown to endpoint received: " + inboundLeg.getLocalEndpointID() + "/" + appContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("regTopic pulled from registratiomMap = " + toEndpointTopic), (Object[])new Object[0]);
        }
        SigLeg outboundLeg = this.sigProvider.createLeg(inboundLeg.getLocalEndpointID(), inboundLeg.getRemoteEndpointID(), message.getProtocols(), message.getPayload(), toEndpointTopic, message.getAppContext(), (SigLegListener)this, 0L, 0L, 0L, message.getTransactionID(), false, null, message);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg2 session id = " + outboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        inboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)outboundLeg);
        outboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)inboundLeg);
        this.legVector.add(inboundLeg);
        this.legVector.add(outboundLeg);
        outboundLeg.activateOutbound();
        return null;
    }

    public void destroy(String reason) {
        if (reason == null) {
            reason = "Server initiated close.";
        }
        Iterator<SigLeg> iterator = this.legVector.iterator();
        while (iterator.hasNext()) {
            iterator.next().stop(reason);
        }
    }

    public void doLegAccepted(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegAccepted: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            inboundLeg.setLocalEndpointID(sigLeg.getRemoteEndpointID());
            inboundLeg.acceptLeg(message.getProtocols(), message.getPayload(), message);
            this.publishSessionEvent(inboundLeg, sigLeg, RtcEventImpl.Category.SESSION, RtcEventImpl.Action.STARTED, sigLeg.getSigLegID(), null, sigLeg.getAppContext());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionAccepted: WARNING: response could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegRejected(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegRejected: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            outboundLeg.rejectLeg(message.getReason());
            this.legVector.remove(outboundLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
            this.publishSessionEvent(outboundLeg, sigLeg, RtcEventImpl.Category.SESSION, RtcEventImpl.Action.FAILED, sigLeg.getSigLegID(), "session rejected", sigLeg.getAppContext());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionRejected: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doMessage(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doMessage: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            SigMessage outboundMessage = outboundLeg.createMessage(message);
            outboundMessage.setPayload(message.getPayload());
            String transactionID = message.getTransactionID();
            if (transactionID != null) {
                outboundMessage.setTransactionID(transactionID);
            }
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doMessage: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegStopped(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg associatedLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegStopped ENTRY: " + message), (Object[])new Object[0]);
        }
        if ((associatedLeg = this.getAssociatedLeg(sigLeg)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doLegStopped: Stopping the Associated Leg reason: " + message.getReason()), (Object[])new Object[0]);
            }
            associatedLeg.stop(message.getReason(), message);
            this.legVector.remove(sigLeg);
            this.legVector.remove(associatedLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
            this.publishSessionEvent(sigLeg, associatedLeg, RtcEventImpl.Category.SESSION, RtcEventImpl.Action.STOPPED, sigLeg.getSigLegID(), null, sigLeg.getAppContext());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doEndSession: WARNING: end session could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegTimedout(SigProvider provider, SigLeg sigLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegTimedout: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            outboundLeg.rejectLeg(reason);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
            this.publishSessionEvent(outboundLeg, sigLeg, RtcEventImpl.Category.SESSION, RtcEventImpl.Action.FAILED, sigLeg.getSigLegID(), "timed out", sigLeg.getAppContext());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doLegTimedout: WARNING: timeout could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doPranswer(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doPranswer: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            String queuePosition;
            outboundLeg.setLocalEndpointID(sigLeg.getRemoteEndpointID());
            SigMessage outboundMessage = outboundLeg.createMessage(message);
            int holdTimeout = message.getHoldTimeout();
            if (holdTimeout != 0) {
                outboundMessage.setHoldTimeout(holdTimeout);
            }
            if ((queuePosition = message.getQueuePosition()) != null) {
                outboundMessage.setQueuePosition(queuePosition);
            }
            outboundMessage.setProtocols(message.getProtocols());
            outboundMessage.setPayload(message.getPayload());
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doPranswer: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doICECandidate(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doICECandidate: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            SigMessage outboundMessage = outboundLeg.createMessage(message.getMethod());
            outboundMessage.setPayload(message.getPayload());
            outboundMessage.send();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doICECandidate: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void destroyed(SigProvider provider, SigLeg inboundLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyed: sigSessionID = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(inboundLeg)) != null) {
            outboundLeg.stop(reason);
            this.legVector.remove(inboundLeg);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
            this.publishSessionEvent(outboundLeg, inboundLeg, RtcEventImpl.Category.SESSION, RtcEventImpl.Action.STOPPED, inboundLeg.getSigLegID(), null, inboundLeg.getAppContext());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroyed: WARNING: session destroyed could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    protected SigLeg getAssociatedLeg(SigLeg leg) {
        SigLeg outboundLeg = (SigLeg)leg.getAttribute(LEG_BINDING_ATTRIBUTE_KEY);
        if (outboundLeg == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: getAssociatedLeg: No outbound leg found.", (Object[])new Object[0]);
        }
        return outboundLeg;
    }

    protected void publishSessionEvent(SigLeg sigLeg, SigLeg associatedLeg, RtcEventImpl.Category category, RtcEventImpl.Action action, String sessionID, String reason, String appContext) {
        if (this.rtcommEventObserver == null) {
            return;
        }
        String fromEndpoint = null;
        String toEndpoint = null;
        if (sigLeg.isOutbound()) {
            toEndpoint = sigLeg.getRemoteEndpointID();
            fromEndpoint = associatedLeg.getRemoteEndpointID();
        } else {
            fromEndpoint = sigLeg.getRemoteEndpointID();
            toEndpoint = associatedLeg.getRemoteEndpointID();
        }
        RtcEventImpl event = this.rtcommEventObserver.createEvent();
        if (sessionID != null) {
            event.setSessionID(sessionID);
        }
        if (reason != null) {
            event.setReason(reason);
        }
        event.set(category, action, fromEndpoint, toEndpoint, appContext);
        this.rtcommEventObserver.publishEvent(event);
    }
}

