/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.rtcconnector;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.ProviderImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcConnectorImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventMonitorImpl;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.rtcconnector.GroupConnector;
import com.ibm.wsspi.rtcomm.service.rtcconnector.GroupConnectorFactory;
import com.ibm.wsspi.rtcomm.service.rtcconnector.GroupConnectorListener;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RtcConnectorProviderImpl
extends ProviderImpl
implements SigProviderListener,
GroupConnectorListener {
    private static final TraceComponent tc = Tr.register(RtcConnectorProviderImpl.class, (String)"Rtcomm", (String)"com.ibm.ws.rtcomm.resources.Rtcomm");
    private static GroupConnectorFactory groupConnectorFactory = null;
    private Map<String, RtcConnectorImpl> connectorMap = new HashMap<String, RtcConnectorImpl>();
    private Map<String, GroupConnector> groupConnectorMap = new HashMap<String, GroupConnector>();
    private String iceServerURLs = null;
    private String primaryMessageServerURL;
    private String secondaryMessageServerURL;
    private boolean eventRegistrationEnabled = false;
    private boolean eventSessionEnabled = false;
    private String eventTopicName = null;
    private String connectorTopicName = null;
    private String rtcommTopicPath = null;
    private RTCommProvider rtCommProvider = null;
    private String sphereTopicName = null;

    public static void setGroupConnectorFactory(GroupConnectorFactory factory) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setGroupConnectorFactory:   ", (Object[])new Object[0]);
        }
        groupConnectorFactory = factory;
    }

    public RtcConnectorProviderImpl(String primaryMessageServerURL, String secondaryMessageServerURL, RtcommRegistry registry, String sphereTopicName) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Group support is enabled", (Object[])new Object[0]);
        }
        this.primaryMessageServerURL = primaryMessageServerURL;
        this.secondaryMessageServerURL = secondaryMessageServerURL;
        this.registry = registry;
        this.sphereTopicName = sphereTopicName;
    }

    public void provisionService(Map<String, Object> properties) {
        String sharedSubscriptionPrefix;
        if (this.sigProvider != null) {
            this.sigProvider.destroy();
        }
        Collection configICEStrings = MetatypeUtils.parseStringCollection((Object)"rtcomm", (String)"iceServerURL", (Object)properties.get("iceServerURL"), null);
        Iterator iterator = configICEStrings.iterator();
        while (iterator.hasNext()) {
            this.iceServerURLs = this.iceServerURLs == null ? "" : this.iceServerURLs + ",";
            this.iceServerURLs = this.iceServerURLs + (String)iterator.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("iceServerURLs = " + this.iceServerURLs), (Object[])new Object[0]);
        }
        this.connectorTopicName = (String)properties.get("connectorTopicName");
        this.rtcommTopicPath = (String)properties.get("rtcommTopicPath");
        if (tc.isInfoEnabled() && (this.rtcommTopicPath == null || this.rtcommTopicPath.isEmpty())) {
            Tr.info((TraceComponent)tc, (String)"CWRTC0008E", (Object[])null);
        }
        if ((sharedSubscriptionPrefix = (String)properties.get("sharedSubscriptionPath")) == null || sharedSubscriptionPrefix.isEmpty()) {
            sharedSubscriptionPrefix = "";
        } else if (sharedSubscriptionPrefix.endsWith("/")) {
            sharedSubscriptionPrefix = sharedSubscriptionPrefix.substring(0, sharedSubscriptionPrefix.length() - 1);
        }
        this.eventTopicName = (String)properties.get("eventTopicName");
        if (this.eventTopicName.isEmpty()) {
            this.eventTopicName = null;
        }
        if (this.eventTopicName != null) {
            this.eventTopicName = this.rtcommTopicPath + this.eventTopicName;
        }
        String eventRegistrationEnabledString = properties.get("eventRegistrationEnabled").toString();
        String eventSessionEnabledString = properties.get("eventSessionEnabled").toString();
        this.eventRegistrationEnabled = Boolean.valueOf(eventRegistrationEnabledString);
        this.eventSessionEnabled = Boolean.valueOf(eventSessionEnabledString);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("provisionService: eventTopicName = " + this.eventTopicName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("provisionService: eventRegistrationEnabledString = " + eventRegistrationEnabledString + "   eventSessionEnabledString = " + eventSessionEnabledString), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("provisionService: eventRegistrationEnabled = " + this.eventRegistrationEnabled + "   eventSessionEnabled = " + this.eventSessionEnabled), (Object[])new Object[0]);
        }
        if (this.connectorTopicName != null) {
            block14: {
                this.rtcEventMonitorImpl = new RtcEventMonitorImpl();
                if (this.eventTopicName != null) {
                    this.rtCommProvider = RTCommProvider.createRTCommProvider((String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL);
                    try {
                        this.rtCommProvider.registerListener(null, null, null, null);
                        this.rtcEventMonitorImpl.initialize(this.eventTopicName, this.rtCommProvider, this.eventRegistrationEnabled, this.eventSessionEnabled, this.registry);
                    }
                    catch (RTCommException e) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)("serviceManagerImpl: ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
                    }
                }
            }
            String sharedSubscriptionPath = "";
            sharedSubscriptionPath = sharedSubscriptionPrefix.isEmpty() ? this.rtcommTopicPath : sharedSubscriptionPrefix + "_" + this.connectorTopicName + "/" + this.rtcommTopicPath;
            this.sigProvider = SigProvider.createSigProvider((String)this.connectorTopicName, (String)sharedSubscriptionPath, (String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL, (String)this.rtcommTopicPath, (String)this.sphereTopicName);
            this.sigProvider.setSigProviderListener((SigProviderListener)this);
        }
    }

    @Override
    public void destroy() {
        if (this.sigProvider != null) {
            this.sigProvider.destroy();
            this.sigProvider = null;
        }
        if (this.rtCommProvider != null) {
            block5: {
                try {
                    this.rtCommProvider.unregisterListener(null);
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("exception caught while unregistering w/ rtcommprovider =  " + ex.toString()), (Object[])new Object[0]);
                }
            }
            this.rtCommProvider = null;
        }
        if (this.rtcEventMonitorImpl != null) {
            this.rtcEventMonitorImpl = null;
        }
    }

    @Override
    public void doServiceQuery(SigProvider provider, String fromEndpointID, SigMessage message) {
        SigResponseMessage response = this.sigProvider.createResponse(message, fromEndpointID, null);
        response.setResult(SigResponseMessage.Result.SUCCEEDED);
        JSONObject serviceDetails = this.queryService();
        response.setServices(serviceDetails);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("queryService: Service query: serviceDetails: " + serviceDetails), (Object[])new Object[0]);
        }
        response.send();
    }

    public JSONObject queryService() {
        JSONObject serviceDetails = new JSONObject();
        if (this.rtcommTopicPath != null && this.connectorTopicName != null) {
            serviceDetails.put((Object)"topic", (Object)(this.rtcommTopicPath + this.connectorTopicName));
        }
        if (this.iceServerURLs != null) {
            serviceDetails.put((Object)"iceURL", (Object)this.iceServerURLs);
        }
        if (this.eventTopicName != null) {
            serviceDetails.put((Object)"eventMonitoringTopic", (Object)this.eventTopicName);
        }
        if (this.rtcommTopicPath != null && this.sphereTopicName != null) {
            serviceDetails.put((Object)"sphereTopic", (Object)(this.rtcommTopicPath + this.sphereTopicName));
        }
        return serviceDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStartLeg(SigProvider provider, String fromEndpointID, SigLeg sigLeg, SigMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doStartLeg: received", (Object[])new Object[0]);
        }
        String errorReason = null;
        GroupConnector groupConnector = null;
        String toEndpoint = message.getHeader("toEndpointID");
        if (toEndpoint.startsWith("group:")) {
            boolean newConnector = false;
            String sdp = this.getSDP(message);
            if (sdp != null) {
                if (this.groupConnectorMap.containsKey(toEndpoint)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("doStartLeg:   groupID = <" + toEndpoint + ">   Existing group connector found"), (Object[])new Object[0]);
                    }
                    groupConnector = this.groupConnectorMap.get(toEndpoint);
                } else if (groupConnectorFactory != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("doStartLeg:  groupID = <" + toEndpoint + ">   Creating new group connector"), (Object[])new Object[0]);
                    }
                    newConnector = true;
                    groupConnector = groupConnectorFactory.createInstance();
                    groupConnector.init(toEndpoint, this.sigProvider, this);
                    boolean videoEnabled = false;
                    if (sdp.contains("m=video")) {
                        videoEnabled = true;
                    }
                    if (!groupConnector.createGroup(videoEnabled)) {
                        groupConnector.destroy(null);
                        groupConnector = null;
                        errorReason = "Unable to create MRF";
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"doStartLeg:  MRF is not configured, rejecting call", (Object[])new Object[0]);
                    }
                    errorReason = "No MRF is configured to support group calls";
                }
            } else {
                errorReason = "SDP is not available.";
            }
            if (errorReason == null) {
                errorReason = groupConnector.addLeg(sigLeg, sdp);
                if (newConnector) {
                    if (errorReason == null) {
                        Map<String, RtcConnectorImpl> map = this.connectorMap;
                        synchronized (map) {
                            this.groupConnectorMap.put(toEndpoint, groupConnector);
                        }
                    } else {
                        groupConnector.destroy(null);
                    }
                }
            }
        } else {
            RtcConnectorImpl connector = new RtcConnectorImpl(this.sigProvider, this.registry, this.rtcEventMonitorImpl, this);
            errorReason = connector.addLeg(sigLeg, message);
            if (errorReason == null) {
                Map<String, RtcConnectorImpl> map = this.connectorMap;
                synchronized (map) {
                    this.connectorMap.put(connector.getConnectorID(), connector);
                }
            }
        }
        if (errorReason != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ERROR: doStartSession: rejecting leg due to: " + errorReason), (Object[])new Object[0]);
            }
            sigLeg.rejectLeg(errorReason);
        }
    }

    private String getSDP(SigMessage message) {
        String sdp = null;
        SigPayload payload = message.getPayload();
        if (payload == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR:    no -payload- in message", (Object[])new Object[0]);
            }
            return null;
        }
        SigPeerContent peerContent = (SigPeerContent)payload.get("webrtc");
        if (peerContent.getType() != SigPeerContent.SigPeerContentType.offer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ERROR:    invalid SDP Type = " + peerContent.getType()), (Object[])new Object[0]);
            }
            return null;
        }
        sdp = peerContent.getRawSDP();
        if (sdp == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR:    rawSDP is null", (Object[])new Object[0]);
            }
            return null;
        }
        return sdp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectorDestroyed(String connectorID) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("connectorDestroyed:   removing (" + connectorID + ") from Map"), (Object[])new Object[0]);
        }
        Map<String, RtcConnectorImpl> map = this.connectorMap;
        synchronized (map) {
            if (this.connectorMap.containsKey(connectorID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connectorDestroyed:   connector successfully removed from connectorMap", (Object[])new Object[0]);
                }
                this.connectorMap.remove(connectorID);
            } else if (this.groupConnectorMap.containsKey(connectorID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connectorDestroyed:   connector successfully removed from groupConnectorMap", (Object[])new Object[0]);
                }
                this.groupConnectorMap.remove(connectorID);
            }
        }
    }
}

