/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.rtcconnector;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcConnectorProviderImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.Service;
import com.ibm.wsspi.rtcomm.service.ServiceMessage;
import com.ibm.wsspi.rtcomm.service.rtcconnector.GroupConnectorFactory;
import com.ibm.wsspi.rtcomm.service.rtcconnector.RtcConnectorService;
import java.util.Map;

public class RtcConnectorServiceImpl
implements Service,
RtcConnectorService {
    private static final TraceComponent tc = Tr.register(RtcConnectorServiceImpl.class);
    private RtcommRegistry registry = null;
    private String primaryMessageServerURL;
    private String secondaryMessageServerURL;
    private RtcConnectorProviderImpl rtcConnectorProviderImpl = null;
    private String sphereTopicName = null;

    public static void setGroupConnectorFactory(GroupConnectorFactory factory) {
        RtcConnectorProviderImpl.setGroupConnectorFactory(factory);
    }

    public static Service createService() {
        return new RtcConnectorServiceImpl();
    }

    @Override
    public void init(String primaryMessageServerURL, String secondaryMessageServerURL, String rtcommTopicPath, String sharedSubscriptionPrefix, Boolean sharedSubscriptionsEnabled, RtcommRegistry registry, String sphereTopicName) {
        this.registry = registry;
        this.primaryMessageServerURL = primaryMessageServerURL;
        this.secondaryMessageServerURL = secondaryMessageServerURL;
        this.sphereTopicName = sphereTopicName;
    }

    @Override
    public void provisionService(Map<String, Object> properties) {
        if (this.rtcConnectorProviderImpl == null) {
            this.rtcConnectorProviderImpl = new RtcConnectorProviderImpl(this.primaryMessageServerURL, this.secondaryMessageServerURL, this.registry, this.sphereTopicName);
        }
        this.rtcConnectorProviderImpl.provisionService(properties);
    }

    @Override
    public void provisionService(ServiceMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RtcConnector service provisioning via MQTT not supported", (Object[])new Object[0]);
        }
    }

    @Override
    public String getServiceType() {
        return "RTCOMM_CONNECTOR_SERVICE";
    }

    @Override
    public JSONObject queryService() {
        if (this.rtcConnectorProviderImpl != null) {
            return this.rtcConnectorProviderImpl.queryService();
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.rtcConnectorProviderImpl != null) {
            this.rtcConnectorProviderImpl.destroy();
            this.rtcConnectorProviderImpl = null;
        }
    }
}

