/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.rtcconnector;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.rtcomm.service.rtcconnector.RtcEvent;
import java.sql.Timestamp;
import java.util.Date;

public class RtcEventImpl
implements RtcEvent {
    private static final TraceComponent tc = Tr.register(RtcEventImpl.class);
    public static final String TIMED_OUT = "timed out";
    public static final String SESSION_REJECTED = "session rejected";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String SESSIONID = "sigSessID";
    private static final String FROM_SERVER = "fromServer";
    private static final String MQTT_TOPIC = "topic";
    private static final String REASON = "reason";
    private static final String EMPTY_STRING = "";
    private static final String RTCOMM_EVENT_FIRED = "RTCOMM_EVENT_FIRED";
    private static Date date = new Date();
    private Category category = null;
    private Action action = null;
    private String fromEndpoint = null;
    private String toEndpoint = null;
    private String topic = null;
    private String timeStamp = null;
    private String sessionID = null;
    private String fromServer = null;
    private String mqttTopic = null;
    private String reason = null;
    private String appContext = null;
    private JSONObject object = new JSONObject();

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void setFromEndpointID(String fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    public String getFromEndpointID() {
        return this.fromEndpoint;
    }

    public void setToEndpointID(String toEndpoint) {
        this.toEndpoint = toEndpoint;
    }

    public String getToEndpointID() {
        return this.toEndpoint;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setFromServer(String fromServer) {
        this.fromServer = fromServer;
    }

    public String getFromServer() {
        return this.fromServer;
    }

    public void setMQTTTopic(String mqttTopic) {
        this.mqttTopic = mqttTopic;
    }

    public String getMQTTTopic() {
        return this.mqttTopic;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public void setAppContext(String appContext) {
        this.appContext = appContext;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void set(Category category, Action action, String fromEndpoint, String toEndpoint, String appContext) {
        this.category = category;
        this.action = action;
        this.fromEndpoint = fromEndpoint;
        this.toEndpoint = toEndpoint;
        this.appContext = appContext;
    }

    public JSONObject serialize() {
        this.object.put((Object)"rtcommVer", (Object)"v1.0.0");
        this.object.put((Object)METHOD, (Object)RTCOMM_EVENT_FIRED);
        switch (this.category) {
            case REGISTRATION: {
                this.topic = "registration";
                break;
            }
            case SESSION: {
                this.topic = "session";
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("invalid category = " + (Object)((Object)this.category)), (Object[])new Object[0]);
            }
        }
        switch (this.action) {
            case STARTED: {
                this.topic = this.topic + "/started";
                break;
            }
            case MODIFIED: {
                this.topic = this.topic + "/modified";
                break;
            }
            case STOPPED: {
                this.topic = this.topic + "/stopped";
                break;
            }
            case FAILED: {
                this.topic = this.topic + "/failed";
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("invalid action = " + (Object)((Object)this.action)), (Object[])new Object[0]);
            }
        }
        if (this.fromEndpoint != null) {
            this.topic = this.topic + "/" + this.fromEndpoint;
        }
        if (this.toEndpoint != null) {
            this.topic = this.topic + "/" + this.toEndpoint;
        }
        this.timeStamp = new Timestamp(date.getTime()).toString();
        this.object.put((Object)TIMESTAMP, (Object)this.timeStamp);
        if (this.sessionID != null) {
            this.object.put((Object)SESSIONID, (Object)this.sessionID);
        }
        if (this.fromServer != null) {
            this.object.put((Object)FROM_SERVER, (Object)this.fromServer);
        }
        if (this.mqttTopic != null) {
            this.object.put((Object)MQTT_TOPIC, (Object)this.mqttTopic);
        }
        if (this.reason != null) {
            this.object.put((Object)REASON, (Object)this.reason);
        }
        if (this.appContext != null && this.appContext.compareTo(EMPTY_STRING) != 0) {
            this.object.put((Object)"appContext", (Object)this.appContext);
        }
        return this.object;
    }

    public String getTopic() {
        if (this.topic == null) {
            this.serialize();
        }
        return this.topic;
    }

    public static enum Action {
        STARTED,
        MODIFIED,
        STOPPED,
        FAILED;

    }

    public static enum Category {
        REGISTRATION,
        SESSION;

    }
}

