/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.rtcconnector;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistryListener;

public class RtcEventMonitorImpl
implements RtcommRegistryListener {
    private static final TraceComponent tc = Tr.register(RtcEventMonitorImpl.class);
    private RTCommProvider rtCommProvider = null;
    private String eventTopicName = null;
    private boolean registrationEnabled = false;
    private boolean sessionEnabled = false;

    public void initialize(String eventTopicName, RTCommProvider rtCommProvider, boolean registrationEnabled, boolean sessionEnabled, RtcommRegistry registry) {
        this.eventTopicName = eventTopicName;
        this.rtCommProvider = rtCommProvider;
        this.registrationEnabled = registrationEnabled;
        this.sessionEnabled = sessionEnabled;
        registry.addListener((RtcommRegistryListener)this);
    }

    public String getTopic() {
        return this.eventTopicName;
    }

    public void publishEvent(RtcEventImpl.Category category, RtcEventImpl.Action action, String fromEndpoint, String toEndpoint, String appContext) {
        if (this.rtCommProvider == null) {
            return;
        }
        RtcEventImpl event = this.createEvent();
        event.set(category, action, fromEndpoint, toEndpoint, appContext);
        this.publishEvent(event);
    }

    public void publishEvent(RtcEventImpl event) {
        block8: {
            if (this.rtCommProvider == null) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"publishEvent", (Object[])new Object[0]);
            }
            switch (event.getCategory()) {
                case REGISTRATION: {
                    if (this.registrationEnabled) break;
                    return;
                }
                case SESSION: {
                    if (this.sessionEnabled) break;
                    return;
                }
            }
            JSONObject eventObject = event.serialize();
            try {
                this.rtCommProvider.sendMessage(eventObject, this.eventTopicName + "/" + event.getTopic(), null, false);
            }
            catch (RTCommException e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("publishEvent: ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    public RtcEventImpl createEvent() {
        return new RtcEventImpl();
    }

    public void endpointAdded(RtcommEndpointDocument document) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpointAdded:   endpoint = " + document.getEndpointID() + "  appContext = " + document.getAppContext()), (Object[])new Object[0]);
        }
        RtcEventImpl event = this.createEvent();
        event.setMQTTTopic(document.getContact());
        event.set(RtcEventImpl.Category.REGISTRATION, RtcEventImpl.Action.STARTED, document.getEndpointID(), null, document.getAppContext());
        this.publishEvent(event);
    }

    public void endpointRemoved(RtcommEndpointDocument record) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpointRemoved:   endpoint = " + record.getEndpointID() + "  appContext = " + record.getAppContext()), (Object[])new Object[0]);
        }
        this.publishEvent(RtcEventImpl.Category.REGISTRATION, RtcEventImpl.Action.STOPPED, record.getEndpointID(), null, record.getAppContext());
    }
}

