/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.sip;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.sip.OutboundSipSigLegListener;
import com.ibm.ws.rtcomm.service.sip.SipProviderImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.UUID;
import java.util.Vector;

public class SipConnectorImpl
implements SigLegListener {
    private static final TraceComponent tc = Tr.register(SipConnectorImpl.class);
    public static final String LEG_BINDING_ATTRIBUTE_KEY = "legBinding";
    protected SigProvider sigProvider = null;
    protected String connectorID = UUID.randomUUID().toString();
    protected RtcommRegistry registry;
    protected Vector<SigLeg> legVector = new Vector();
    protected SipProviderImpl connectorProvider = null;

    public SipConnectorImpl(SigProvider provider, RtcommRegistry registry, SipProviderImpl connectorProvider) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Constructor", (Object[])new Object[0]);
        }
        this.sigProvider = provider;
        this.registry = registry;
        this.connectorProvider = connectorProvider;
    }

    public String getConnectorID() {
        return this.connectorID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String attachOutboundLeg(SigLeg inboundLeg, SigMessage message, boolean comingFromSip) {
        block13: {
            block12: {
                if (SipConnectorImpl.tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)SipConnectorImpl.tc, (String)"attachOutboundLeg", (Object[])new Object[]{inboundLeg, message, comingFromSip});
                }
                errorCode = null;
                try {
                    if (SipConnectorImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SipConnectorImpl.tc, (String)("leg session id = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
                    }
                    if ((appContext = message.getAppContext()) == null) {
                        appContext = "";
                    }
                    outboundLeg = null;
                    if (!comingFromSip) ** GOTO lbl30
                    toEndpointTopic = message.getAddressTopic();
                    if (toEndpointTopic != null) break block12;
                    if (SipConnectorImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SipConnectorImpl.tc, (String)("endpoint (" + inboundLeg.getRemoteEndpointID() + "/" + appContext + ") is not registered"), (Object[])new Object[0]);
                    }
                    var8_8 = errorCode = "Unknown to endpoint received: " + inboundLeg.getRemoteEndpointID();
                }
                catch (Throwable var9_9) {
                    if (SipConnectorImpl.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)SipConnectorImpl.tc, (String)"attachOutboundLeg", errorCode);
                    }
                    throw var9_9;
                }
                if (SipConnectorImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)SipConnectorImpl.tc, (String)"attachOutboundLeg", (Object)errorCode);
                }
                return var8_8;
            }
            if (SipConnectorImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SipConnectorImpl.tc, (String)("regTopic pulled from registratiomMap = " + toEndpointTopic), (Object[])new Object[0]);
            }
            outboundLeg = this.sigProvider.createLeg(inboundLeg.getRemoteEndpointID(), inboundLeg.getLocalEndpointID(), message.getProtocols(), message.getPayload(), toEndpointTopic, message.getAppContext(), (SigLegListener)this, 0L, 0L, 0L, message.getTransactionID(), false, null, null);
            outboundLeg.setListener(this);
            break block13;
lbl30:
            // 1 sources

            outboundLeg = new SipSigLeg(message, true);
            outboundLeg.setListener(new OutboundSipSigLegListener(this.sigProvider));
            inboundLeg.setListener((SigLegListener)this);
            outboundLeg.setLocalEndpointID(inboundLeg.getLocalEndpointID());
            outboundLeg.setRemoteEndpointID(inboundLeg.getRemoteEndpointID());
        }
        if (SipConnectorImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SipConnectorImpl.tc, (String)("outbound session id = " + outboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        inboundLeg.addAttribute("legBinding", (Object)outboundLeg);
        outboundLeg.addAttribute("legBinding", inboundLeg);
        this.legVector.add(inboundLeg);
        this.legVector.add(outboundLeg);
        outboundLeg.activateOutbound();
        var7_7 = errorCode;
        if (SipConnectorImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SipConnectorImpl.tc, (String)"attachOutboundLeg", (Object)errorCode);
        }
        return var7_7;
    }

    public void destroy(String reason) {
        if (reason == null) {
            reason = "Server initiated close.";
        }
        for (SigLeg nextSigLeg : this.legVector) {
            if (nextSigLeg.getState().equals((Object)SigLeg.SigLegState.STOPPED)) continue;
            nextSigLeg.stop(reason);
        }
    }

    public void doLegAccepted(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegAccepted: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            inboundLeg.setLocalEndpointID(sigLeg.getLocalEndpointID());
            inboundLeg.acceptLeg(message.getProtocols(), message.getPayload());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionAccepted: WARNING: response could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegRejected(SigProvider provider, SigLeg sigLeg, SigResponseMessage message) {
        SigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegRejected: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            inboundLeg.setLocalEndpointID(sigLeg.getLocalEndpointID());
            inboundLeg.rejectLeg(message.getReason());
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doSessionRejected: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doMessage(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SipSigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doMessage: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = (SipSigLeg)this.getAssociatedLeg(sigLeg)) != null) {
            SigPayload sigPayload = message.getPayload();
            inboundLeg.sendMessage(sigPayload);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doMessage: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegStopped(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SigLeg associatedLeg = this.getAssociatedLeg(sigLeg);
        if (associatedLeg != null) {
            associatedLeg.stop(message.getReason());
            this.legVector.remove(sigLeg);
            this.legVector.remove(associatedLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doEndSession: WARNING: end session could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doLegTimedout(SigProvider provider, SigLeg sigLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doLegTimedout: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(sigLeg)) != null) {
            outboundLeg.rejectLeg(reason);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doLegTimedout: WARNING: timeout could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doPranswer(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SipSigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doPranswer: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = (SipSigLeg)this.getAssociatedLeg(sigLeg)) != null) {
            SigPayload sigPayload = message.getPayload();
            String[] protocols = message.getProtocols();
            inboundLeg.provisionLeg(protocols, sigPayload);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doPranswer: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void doICECandidate(SigProvider provider, SigLeg sigLeg, SigMessage message) {
        SipSigLeg inboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doICECandidate: sigSessionID = " + sigLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((inboundLeg = (SipSigLeg)this.getAssociatedLeg(sigLeg)) != null) {
            SigPayload sigPayload = message.getPayload();
            inboundLeg.sendIceCandidate(sigPayload);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doICECandidate: WARNING: message could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    public void destroyed(SigProvider provider, SigLeg inboundLeg, String reason) {
        SigLeg outboundLeg;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroyed: sigSessionID = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((outboundLeg = this.getAssociatedLeg(inboundLeg)) != null && !outboundLeg.getState().equals((Object)SigLeg.SigLegState.STOPPED)) {
            outboundLeg.stop(reason);
            this.legVector.remove(inboundLeg);
            this.legVector.remove(outboundLeg);
            this.connectorProvider.connectorDestroyed(this.connectorID);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroyed: WARNING: session destroyed could not be forwarded. No leg found.", (Object[])new Object[0]);
        }
    }

    protected SigLeg getAssociatedLeg(SigLeg leg) {
        SigLeg outboundLeg = (SigLeg)leg.getAttribute(LEG_BINDING_ATTRIBUTE_KEY);
        if (outboundLeg == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ERROR: getAssociatedLeg: No outbound leg found.", (Object[])new Object[0]);
        }
        return outboundLeg;
    }

    public boolean nodeRemoved(String nodeID, String appContext) {
        boolean nodeIDFound = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("nodeRemoved:   check nodeID(" + nodeID + "/" + appContext + ") to see if it involves this Connector"), (Object[])new Object[0]);
        }
        for (SigLeg sigLeg : this.legVector) {
            if (nodeID.compareTo(sigLeg.getRemoteEndpointID()) != 0 || appContext.compareTo(sigLeg.getAppContext()) != 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"nodeReviewed:   nodeID found, destroying Connector", (Object[])new Object[0]);
            }
            this.destroy("Node(" + nodeID + "/ + " + appContext + ") is no longer registered, ending session.");
            nodeIDFound = true;
            break;
        }
        return nodeIDFound;
    }

    public String attachRTCommOutboundLeg(SigLeg inboundLeg, SigMessage message) {
        String appContext;
        inboundLeg.setListener((SigLegListener)this);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg session id = " + inboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        if ((appContext = message.getAppContext()) == null) {
            appContext = "";
        }
        RtcommEndpointDocument document = this.registry.getDocument(inboundLeg.getLocalEndpointID(), appContext);
        String toEndpointTopic = null;
        if (document != null) {
            toEndpointTopic = document.getContact();
            if (toEndpointTopic == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("endpoint (" + inboundLeg.getLocalEndpointID() + "/" + appContext + ") is not registered"), (Object[])new Object[0]);
                }
                return "Unknown to endpoint received: " + inboundLeg.getLocalEndpointID();
            }
        } else {
            return "Unknown to endpoint received: " + inboundLeg.getLocalEndpointID();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("regTopic pulled from registratiomMap = " + toEndpointTopic), (Object[])new Object[0]);
        }
        SigLeg outboundLeg = this.sigProvider.createLeg(inboundLeg.getLocalEndpointID(), inboundLeg.getRemoteEndpointID(), message.getProtocols(), message.getPayload(), toEndpointTopic, message.getAppContext(), (SigLegListener)this, 0L, 0L, 0L, message.getTransactionID(), false, null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("leg2 session id = " + outboundLeg.getSigLegID()), (Object[])new Object[0]);
        }
        inboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)outboundLeg);
        outboundLeg.addAttribute(LEG_BINDING_ATTRIBUTE_KEY, (Object)inboundLeg);
        this.legVector.add(inboundLeg);
        this.legVector.add(outboundLeg);
        outboundLeg.activateOutbound();
        return null;
    }
}

