/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.sip;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.service.ProviderImpl;
import com.ibm.ws.rtcomm.service.rtcconnector.RtcEventImpl;
import com.ibm.ws.rtcomm.service.sip.SipConnectorImpl;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.rtcomm.registry.RtcommEndpointDocument;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistryListener;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLeg;
import com.ibm.wsspi.rtcomm.service.sip.UABridge;
import com.ibm.wsspi.rtcomm.service.sip.UABridgeDirection;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SipProviderImpl
extends ProviderImpl
implements RtcommRegistryListener {
    private static final TraceComponent tc = Tr.register(SipProviderImpl.class);
    private Map<String, SipConnectorImpl> connectorMap = new HashMap<String, SipConnectorImpl>();
    private String primaryMessageServerURL;
    private String secondaryMessageServerURL;
    private String connectorTopicName = null;
    private String rtcommTopicPath = null;
    private String sphereTopicName;
    private String iceServerURLs = null;
    private String[] supportedProtocolSchemes = new String[]{"sip", "sips", "tel"};

    public SipProviderImpl(String primaryMessageServerURL, String secondaryMessageServerURL, RtcommRegistry registry, String sphereTopicName) {
        this.primaryMessageServerURL = primaryMessageServerURL;
        this.secondaryMessageServerURL = secondaryMessageServerURL;
        this.registry = registry;
        this.registry.addListener((RtcommRegistryListener)this);
        this.sphereTopicName = sphereTopicName;
    }

    public void provisionService(Map<String, Object> properties) {
        if (this.sigProvider != null) {
            this.sigProvider.destroy();
        }
        this.connectorTopicName = SipGateway.getConnectorTopic();
        this.rtcommTopicPath = (String)properties.get("rtcommTopicPath");
        Collection configICEStrings = MetatypeUtils.parseStringCollection((Object)"rtcomm", (String)"iceServerURL", (Object)properties.get("iceServerURL"), null);
        Iterator iterator = configICEStrings.iterator();
        while (iterator.hasNext()) {
            this.iceServerURLs = this.iceServerURLs == null ? "" : this.iceServerURLs + ",";
            this.iceServerURLs = this.iceServerURLs + (String)iterator.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("iceServerURLs = " + this.iceServerURLs), (Object[])new Object[0]);
        }
        String sharedSubscriptionPath = null;
        String sharedSubscriptionPrefix = (String)properties.get("sharedSubscriptionPath");
        if (sharedSubscriptionPrefix == null || sharedSubscriptionPrefix.isEmpty()) {
            sharedSubscriptionPath = this.rtcommTopicPath;
        } else {
            if (sharedSubscriptionPrefix.endsWith("/")) {
                sharedSubscriptionPrefix = sharedSubscriptionPrefix.substring(0, sharedSubscriptionPrefix.length() - 1);
            }
            sharedSubscriptionPath = sharedSubscriptionPrefix + "_" + this.connectorTopicName + "/" + this.rtcommTopicPath;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("provisionService: Creating rtcomm leg provider. connectorTopicName=" + this.connectorTopicName + ", rtcommTopicPath=" + this.rtcommTopicPath + ", primaryMessageServerURL=" + this.primaryMessageServerURL + ", secondaryMessageServerURL=" + this.secondaryMessageServerURL + ", rtcommTopicPath=" + this.rtcommTopicPath + ", sphereTopicName=" + this.sphereTopicName + ", iceServerURLs=" + this.iceServerURLs + ", sharedSubscriptionPath=" + sharedSubscriptionPath), (Object[])new Object[0]);
        }
        this.sigProvider = SigProvider.createSigProvider((String)this.connectorTopicName, (String)sharedSubscriptionPath, (String)this.primaryMessageServerURL, (String)this.secondaryMessageServerURL, (String)this.rtcommTopicPath, (String)this.sphereTopicName);
        this.sigProvider.setSigProviderListener((SigProviderListener)this);
        SipGateway.setSigProvider(this.sigProvider);
        SipGateway.setProviderListener(this);
        UABridge sipBridge = SipGateway.getSipUaBridge();
        if (sipBridge != null) {
            sipBridge.setSigProvider(this.sigProvider);
            sipBridge.setProviderListener(this);
        }
    }

    @Override
    public void destroy() {
        if (this.sigProvider != null) {
            this.sigProvider.destroy();
            this.sigProvider = null;
        }
    }

    @Override
    public void doServiceQuery(SigProvider provider, String fromEndpointID, SigMessage message) {
        SigResponseMessage response = this.sigProvider.createResponse(message, fromEndpointID, null);
        response.setResult(SigResponseMessage.Result.SUCCEEDED);
        JSONObject serviceDetails = this.queryService();
        response.setServices(serviceDetails);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("queryService: Service query: serviceDetails: " + serviceDetails), (Object[])new Object[0]);
        }
        response.send();
    }

    public JSONObject queryService() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queryService", (Object[])new Object[0]);
        }
        JSONObject serviceDetails = new JSONObject();
        if (this.rtcommTopicPath != null && this.connectorTopicName != null) {
            serviceDetails.put((Object)"topic", (Object)(this.rtcommTopicPath + this.connectorTopicName));
        }
        JSONArray array = new JSONArray();
        array.addAll(Arrays.asList(this.supportedProtocolSchemes));
        serviceDetails.put((Object)"schemes", (Object)array);
        if (this.iceServerURLs != null) {
            serviceDetails.put((Object)"iceURL", (Object)this.iceServerURLs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryService", (Object)serviceDetails);
        }
        return serviceDetails;
    }

    public void doStartLeg(SipSigLeg sipLeg) {
        this.doBackToBack(sipLeg.getRemoteEndpointID(), sipLeg, sipLeg.getInitialMessage(), true);
    }

    @Override
    public void doStartLeg(SigProvider provider, String fromEndpointID, SigLeg sigLeg, SigMessage message) {
        this.doBackToBack(fromEndpointID, sigLeg, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackToBack(String fromEndpointID, SigLeg sigLeg, SigMessage message, boolean comingFromSip) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doBackToBack", (Object[])new Object[]{fromEndpointID, sigLeg, message, comingFromSip});
        }
        SipConnectorImpl connector = new SipConnectorImpl(this.sigProvider, this.registry, this);
        Map<String, SipConnectorImpl> map = this.connectorMap;
        synchronized (map) {
            this.connectorMap.put(connector.getConnectorID(), connector);
        }
        String errorReason = connector.attachOutboundLeg(sigLeg, message, comingFromSip);
        if (errorReason != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ERROR: doStartSession: rejecting leg due to: " + errorReason), (Object[])new Object[0]);
            }
            Map<String, SipConnectorImpl> map2 = this.connectorMap;
            synchronized (map2) {
                this.connectorMap.remove(connector.getConnectorID());
            }
            SigResponseMessage response = this.sigProvider.createResponse(message, fromEndpointID, null);
            response.setResult(SigResponseMessage.Result.FAILED);
            response.setReason(errorReason);
            response.send();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doBackToBack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(String nodeID, String appContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("nodeRemoved:   nodeID = " + nodeID + "  appContext = " + appContext), (Object[])new Object[0]);
        }
        this.rtcEventMonitorImpl.publishEvent(RtcEventImpl.Category.REGISTRATION, RtcEventImpl.Action.STOPPED, nodeID, null, appContext);
        Map<String, SipConnectorImpl> map = this.connectorMap;
        synchronized (map) {
            Iterator<SipConnectorImpl> iterator = this.connectorMap.values().iterator();
            while (iterator.hasNext()) {
                SipConnectorImpl connector = iterator.next();
                boolean nodeIDFound = connector.nodeRemoved(nodeID, appContext);
                if (!nodeIDFound) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing ConnectorID(" + connector.getConnectorID() + ")"), (Object[])new Object[0]);
                }
                this.connectorMap.remove(connector.getConnectorID());
                iterator = this.connectorMap.values().iterator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectorDestroyed(String connectorID) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("connectorDestroyed:   removing (" + connectorID + ") from connectorMap"), (Object[])new Object[0]);
        }
        Map<String, SipConnectorImpl> map = this.connectorMap;
        synchronized (map) {
            if (this.connectorMap.containsKey(connectorID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"connectorDestroyed:   connector successfully removed", (Object[])new Object[0]);
                }
                this.connectorMap.remove(connectorID);
            }
        }
    }

    public void endpointAdded(RtcommEndpointDocument document) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endpointAdded", (Object[])new Object[]{document});
        }
        UABridge sipBridge = SipGateway.getSipUaBridge();
        if (this.isInSchemes(document.getEndpointID())) {
            sipBridge.register(document, UABridgeDirection.TO_SIP);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("aor scheme is not supported=" + document.getEndpointID()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endpointAdded");
        }
    }

    private boolean isInSchemes(String aor) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isInSchemes", (Object[])new Object[]{aor});
        }
        boolean result = false;
        if (aor != null && aor.length() > 3) {
            String aorScheme = aor.substring(0, 3);
            for (String scheme : this.supportedProtocolSchemes) {
                if (!scheme.equals(aorScheme)) continue;
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isInSchemes", (Object)result);
        }
        return result;
    }

    public void endpointRemoved(RtcommEndpointDocument document) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endpointRemoved", (Object[])new Object[]{document});
        }
        UABridge sipBridge = SipGateway.getSipUaBridge();
        if (this.isInSchemes(document.getEndpointID())) {
            sipBridge.unregister(document, UABridgeDirection.TO_SIP);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("aor scheme is not supported=" + document.getEndpointID()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endpointRemoved");
        }
    }

    public RtcommEndpointDocument getDocumentFromRegistry(String endpointId, String appContext) {
        return this.registry.getDocument(endpointId, appContext);
    }
}

