/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.service.sip;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.rtcomm.service.sip.SipProviderImpl;
import com.ibm.wsspi.rtcomm.registry.RtcommRegistry;
import com.ibm.wsspi.rtcomm.service.Service;
import com.ibm.wsspi.rtcomm.service.ServiceMessage;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import java.util.List;
import java.util.Map;

public class SipServiceImpl
implements Service {
    private static final TraceComponent tc = Tr.register(SipServiceImpl.class);
    private static final String CONNECTOR_ID = "gateway";
    private static final String CONNECTOR_TOPIC_NAME = "topicName";
    private static final String EXTERNAL_PROXY_REGISTRAR = "externalPR";
    private static final String ROUTE_TO_SIP_CONTAINER = "sipContainer";
    private static final String ALLOW_FROM_SIP_EP = "allowFromSipEndpointRef";
    private static final SipServiceImpl instance = new SipServiceImpl();
    private RtcommRegistry registry = null;
    private String primaryMessageServerURL;
    private String secondaryMessageServerURL;
    private SipProviderImpl SipProviderImpl = null;
    private String sphereTopicName = null;

    public static Service createService() {
        return instance;
    }

    @Override
    public void init(String primaryMessageServerURL, String secondaryMessageServerURL, String rtcommTopicPath, String sharedSubscriptionPath, Boolean sharedSubscriptionsEnabled, RtcommRegistry registry, String sphereTopicName) {
        this.registry = registry;
        this.primaryMessageServerURL = primaryMessageServerURL;
        this.secondaryMessageServerURL = secondaryMessageServerURL;
        this.sphereTopicName = sphereTopicName;
    }

    @Override
    public void provisionService(Map<String, Object> properties) {
        Map<String, List<Map<String, Object>>> nestedConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"provisionService", (Object[])new Object[]{properties});
        }
        if (this.SipProviderImpl == null) {
            this.SipProviderImpl = new SipProviderImpl(this.primaryMessageServerURL, this.secondaryMessageServerURL, this.registry, this.sphereTopicName);
        }
        if ((nestedConfig = Nester.nest(properties, CONNECTOR_ID)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"provisionService", (Object)"WebRTC Gateway not provisioned");
            }
            return;
        }
        List<Map<String, Object>> sipConnectorConfig = nestedConfig.get(CONNECTOR_ID);
        if (sipConnectorConfig == null || sipConnectorConfig.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"provisionService", (Object)"WebRTC Gateway not provisioned");
            }
            return;
        }
        for (int i = 0; i < sipConnectorConfig.size(); ++i) {
            Map<String, Object> map = sipConnectorConfig.get(i);
            SipGateway.setExternalPR((String)map.get(EXTERNAL_PROXY_REGISTRAR));
            SipGateway.setRouteToContainer(map.get(ROUTE_TO_SIP_CONTAINER) == null ? false : (Boolean)map.get(ROUTE_TO_SIP_CONTAINER));
            SipGateway.setConnectorEndPoints((String[])map.get(ALLOW_FROM_SIP_EP));
            SipGateway.setConnectorTopic((String)map.get(CONNECTOR_TOPIC_NAME));
        }
        this.SipProviderImpl.provisionService(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"provisionService");
        }
    }

    @Override
    public void provisionService(ServiceMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RtcConnector service provisioning via MQTT not supported", (Object[])new Object[0]);
        }
    }

    @Override
    public String getServiceType() {
        return "RTCOMM_SIP_CONNECTOR_SERVICE";
    }

    @Override
    public JSONObject queryService() {
        if (this.SipProviderImpl != null) {
            return this.SipProviderImpl.queryService();
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.SipProviderImpl != null) {
            this.SipProviderImpl.destroy();
            this.SipProviderImpl = null;
        }
    }
}

