/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rtcomm.service.sip;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.rtcomm.service.ServiceManager;
import com.ibm.wsspi.rtcomm.service.sip.UABridge;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.StringTokenizer;

public class SipGateway {
    private static final TraceComponent tc = Tr.register(SipGateway.class);
    private static final String EP_HOST_KEY = "host";
    private static final String EP_TCP_PORT_KEY = "sipTCPPort";
    private static final String EP_TLS_PORT_KEY = "sipTLSPort";
    private static final String EP_UDP_PORT_KEY = "sipUDPPort";
    private static UABridge sipUaBridge;
    private static String externalPRHost;
    private static int externalPRPort;
    private static String[] connectorEndPoints;
    private static boolean routeToContainer;
    private static String connectorTopic;
    private static String connectorHost;
    private static SigProvider sigProvider;
    private static SigProviderListener sigProviderListener;

    public static UABridge getSipUaBridge() {
        return sipUaBridge;
    }

    public static void setSipUaBridge(UABridge sipUaBridge) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setting sipUaBridge=" + sipUaBridge), (Object[])new Object[0]);
        }
        if ((SipGateway.sipUaBridge = sipUaBridge).getSigProvider() == null) {
            SipGateway.sipUaBridge.setSigProvider(sigProvider);
        }
        if (SipGateway.sipUaBridge.getProviderListener() == null) {
            SipGateway.sipUaBridge.setProviderListener(sigProviderListener);
        }
    }

    public static void destory() {
        if (SipGateway.getSipUaBridge() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroy sipUaBridge=" + sipUaBridge), (Object[])new Object[0]);
            }
            sipUaBridge.setSigProvider(null);
            sipUaBridge.setProviderListener(null);
            sipUaBridge = null;
        }
    }

    public static String getExternalPRHost() {
        return externalPRHost;
    }

    public static int getExternalPRPort() {
        return externalPRPort;
    }

    public static void setExternalPR(String externalPR) {
        String portDelimiter = ":";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setting externalPR=" + externalPR), (Object[])new Object[0]);
        }
        if (externalPR == null || externalPR.length() <= 0) {
            return;
        }
        if (externalPR.contains(":")) {
            StringTokenizer t = new StringTokenizer(externalPR, ":");
            externalPRHost = t.nextToken();
            try {
                externalPRPort = Integer.decode(t.nextToken());
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setExternalPR bad host:port format: " + externalPR), (Object[])new Object[0]);
                }
            }
        } else {
            externalPRHost = externalPR;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setting externalPRHost=" + externalPRHost + ", externalPRPort=" + externalPRPort), (Object[])new Object[0]);
        }
    }

    public static void setSigProvider(SigProvider sigProvider) {
        SipGateway.sigProvider = sigProvider;
    }

    public static void setProviderListener(SigProviderListener providerListener) {
        sigProviderListener = providerListener;
    }

    public static void setConnectorTopic(String connectorTopic) {
        SipGateway.connectorTopic = connectorTopic;
    }

    public static String getConnectorTopic() {
        return connectorTopic;
    }

    public static boolean isRouteToContainer() {
        return routeToContainer;
    }

    public static void setRouteToContainer(boolean routeToContainer) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setting routeToContainer=" + routeToContainer), (Object[])new Object[0]);
        }
        SipGateway.routeToContainer = routeToContainer;
    }

    public static void setConnectorEndPoints(String[] connectorEndPoints) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConnectorEndPoints=" + Arrays.toString(connectorEndPoints)), (Object[])new Object[0]);
        }
        SipGateway.connectorEndPoints = connectorEndPoints;
    }

    public static String getConnectorHost() {
        try {
            if (connectorHost == null || connectorHost.length() <= 0) {
                String host = (String)SipGateway.getEndpointDictionary().get(EP_HOST_KEY);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("host in dictionary=" + host), (Object[])new Object[0]);
                }
                connectorHost = SipGateway.normlizeHost(host);
            }
        }
        catch (UnknownHostException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not resolve local host", (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rtcomm.service.sip.SipGateway", (String)"1");
        }
        return connectorHost;
    }

    private static String normlizeHost(String host) throws UnknownHostException {
        InetAddress iaHost;
        InetAddress inetAddress = iaHost = host == null || host.length() <= 0 || host.equals("*") || host.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        if (iaHost.isLoopbackAddress()) {
            iaHost = InetAddress.getLocalHost();
        }
        return iaHost.getCanonicalHostName();
    }

    public static int getPort() {
        Integer udpPort = (Integer)SipGateway.getEndpointDictionary().get(EP_UDP_PORT_KEY);
        if (udpPort == null) {
            return -1;
        }
        return udpPort;
    }

    private static Dictionary<String, Object> getEndpointDictionary() {
        if (connectorEndPoints.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SIP Connector endpoint=" + connectorEndPoints[0]), (Object[])new Object[0]);
            }
            try {
                Dictionary dictionary = ServiceManager.getConfigadminref().get().getConfiguration(connectorEndPoints[0], null).getProperties();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SIP Connector endpoint dictionary=" + dictionary), (Object[])new Object[0]);
                }
                return dictionary;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Could not resolve configuration for=" + connectorEndPoints[0]), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rtcomm.service.sip.SipGateway", (String)"2");
            }
        }
        return null;
    }

    static {
        externalPRPort = 5060;
    }
}

