/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rtcomm.service.sip;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.rtcomm.service.sip.SipGateway;
import com.ibm.wsspi.rtcomm.service.sip.SipSigLegListener;
import com.ibm.wsspi.rtcomm.service.sip.UABridgeDirection;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.HashMap;

public class SipSigLeg
implements SigLeg {
    private static final TraceComponent tc = Tr.register(SipSigLeg.class);
    private SigMessage origMessage;
    private SipSigLegListener listener;
    private boolean isOutbound;
    private String sasID;
    private String localEndpointID;
    private String remoteEndpointID = null;
    private HashMap<String, Object> attributes = new HashMap();
    private SigLeg.SigLegState state = SigLeg.SigLegState.IDLE;

    public SipSigLeg(SigMessage origMessage, boolean isOutbound) {
        this.origMessage = origMessage;
        this.isOutbound = isOutbound;
    }

    public void activateOutbound() {
        this.state = SigLeg.SigLegState.STARTING;
        SipGateway.getSipUaBridge().initiateOutboundLeg(this, UABridgeDirection.TO_SIP);
    }

    public void setListener(SigLegListener listener) {
        this.listener = (SipSigLegListener)listener;
    }

    public long getInitialResponseTimeout() {
        return 0L;
    }

    public long getFinalResponseTimeout() {
        return 0L;
    }

    public SigLeg.SigLegState getState() {
        return this.state;
    }

    public void sendIceCandidate(SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendIceCandidate", (Object[])new Object[]{sigPayload != null ? sigPayload.toString() : null});
        }
        this.listener.doIceCandidate(this, sigPayload);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendIceCandidate");
        }
    }

    public void sendMessage(SigPayload sigPayload) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendMessage", (Object[])new Object[]{sigPayload != null ? sigPayload.toString() : null});
        }
        this.listener.doMessage(this, sigPayload);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendMessage");
        }
    }

    public void rejectLeg(String reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rejectLeg", (Object[])new Object[]{reason});
        }
        this.state = SigLeg.SigLegState.FAILED;
        this.listener.doLegRejected(this, reason);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rejectLeg");
        }
    }

    public String getSigLegID() {
        return null;
    }

    public String getRemoteEndpointID() {
        return this.remoteEndpointID;
    }

    public void setLocalEndpointID(String localEndointID) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLocalEndpointID = " + localEndointID), (Object[])new Object[0]);
        }
        this.localEndpointID = localEndointID;
    }

    public void setRemoteEndpointID(String remoteEndpointID) {
        this.remoteEndpointID = remoteEndpointID;
    }

    public String getLocalEndpointID() {
        return this.localEndpointID;
    }

    public String getAppContext() {
        return null;
    }

    public SigMessage createMessage(SigMessage.SigMethod method) {
        return SipGateway.getSipUaBridge().getSigProvider().createMessage(method, null, this.remoteEndpointID, this.localEndpointID);
    }

    public void stop(String reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object[])new Object[]{reason});
        }
        this.listener.doLegStopped(null, this, this.origMessage);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void stopOutbound(String reason) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopOutbound", (Object[])new Object[]{reason});
        }
        this.listener.doLegStopped(this, reason);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopOutbound");
        }
    }

    public void addAttribute(String id, Object attr) {
        this.attributes.put(id, attr);
    }

    public Object getAttribute(String id) {
        return this.attributes.get(id);
    }

    public Object removeAttribute(String id) {
        return this.attributes.remove(id);
    }

    public boolean isOutbound() {
        return this.isOutbound;
    }

    public SigMessage getInitialMessage() {
        return this.origMessage;
    }

    public String getSasID() {
        return this.sasID;
    }

    public void setSasID(String sasID) {
        this.sasID = sasID;
    }

    public void acceptLeg(String[] protocols, SigPayload payload) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"acceptLeg", (Object[])new Object[0]);
        }
        this.state = SigLeg.SigLegState.STARTED;
        this.listener.doLegAccepted(this, protocols, payload);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"acceptLeg");
        }
    }

    public void provisionLeg(String[] protocols, SigPayload payload) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"provisionLeg", (Object[])new Object[0]);
        }
        this.listener.doLegProvisioned(this, protocols, payload);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"provisionLeg");
        }
    }

    public void stop(SigMessage message) {
        if (this.listener != null) {
            this.listener.doLegStopped(SipGateway.getSipUaBridge().getSigProvider(), this, message);
        }
    }

    public void acceptLeg(String[] protocols, SigPayload payload, SigResponseMessage message) {
    }

    public SigMessage createMessage(SigMessage message) {
        return null;
    }

    public void stop(String reason, SigMessage message) {
    }
}

