/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.sig.SigMessageImpl;
import com.ibm.ws.rtcomm.sig.SigResponseMessageImpl;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class SigLegImpl
implements SigLeg {
    private static final TraceComponent tc = Tr.register(SigLegImpl.class);
    private static Timer timer = new Timer(true);
    private static long LEG_INITIAL_RESPONSE_TIMEOUT = 10000L;
    private static long LEG_FINAL_RESPONSE_TIMEOUT = 30000L;
    private static final String EMPTY_STRING = "";
    RTCommProvider rtCommProvider;
    SigProvider sigProvider;
    private String sigSessionID;
    private SigLegListener listener;
    private String remoteEndpointID;
    private String localEndpointID;
    private Map<String, Object> attributeMap;
    private String startTransactionID;
    private String remoteTopic;
    private String localTopic;
    private SigMessage origStartMessage;
    private SigLeg.SigLegState state;
    private TimerTask retransmissionTimerTask;
    private TimerTask initialResponseTimerTask;
    private TimerTask finalResponseTimerTask;
    private long retransmissionTimeout;
    private long initialResponseTimeout;
    private long finalResponseTimeout;
    private boolean isOutbound;
    private String appContext;

    public SigLegImpl(SigMessage message, SigProvider sigProvider, RTCommProvider rtCommProvider, String localEndpointID, String remoteEndpointID, String sigSessionID, String localTopic) {
        this.rtCommProvider = null;
        this.sigProvider = null;
        this.sigSessionID = null;
        this.listener = null;
        this.remoteEndpointID = null;
        this.localEndpointID = null;
        this.attributeMap = new HashMap<String, Object>();
        this.startTransactionID = null;
        this.remoteTopic = null;
        this.localTopic = null;
        this.origStartMessage = null;
        this.state = SigLeg.SigLegState.STARTING;
        this.retransmissionTimerTask = null;
        this.initialResponseTimerTask = null;
        this.finalResponseTimerTask = null;
        this.retransmissionTimeout = 0L;
        this.initialResponseTimeout = LEG_INITIAL_RESPONSE_TIMEOUT;
        this.finalResponseTimeout = LEG_FINAL_RESPONSE_TIMEOUT;
        this.isOutbound = false;
        this.appContext = EMPTY_STRING;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SigLegImpl: new inbound leg created: sigSessID = " + sigSessionID), (Object[])new Object[0]);
        }
        this.sigProvider = sigProvider;
        this.rtCommProvider = rtCommProvider;
        this.sigSessionID = sigSessionID;
        this.remoteEndpointID = remoteEndpointID;
        this.localEndpointID = localEndpointID;
        this.localTopic = localTopic;
        this.origStartMessage = message;
        this.remoteTopic = ((SigMessageImpl)message).getHeader("fromTopic");
    }

    public SigLegImpl(SigProvider sigProvider, RTCommProvider rtCommProvider, SigLegListener listener, String remoteEndpointID, String localEndpointID, String remoteTopic, String[] protocols, SigPayload payload, String context, String localTopic, long retransmissionTimeout, long initialResponseTimeout, long finalResponseTimeout, String transactionID, boolean retainMessage, String sigSessionID, SigMessage message) {
        block13: {
            this.rtCommProvider = null;
            this.sigProvider = null;
            this.sigSessionID = null;
            this.listener = null;
            this.remoteEndpointID = null;
            this.localEndpointID = null;
            this.attributeMap = new HashMap<String, Object>();
            this.startTransactionID = null;
            this.remoteTopic = null;
            this.localTopic = null;
            this.origStartMessage = null;
            this.state = SigLeg.SigLegState.STARTING;
            this.retransmissionTimerTask = null;
            this.initialResponseTimerTask = null;
            this.finalResponseTimerTask = null;
            this.retransmissionTimeout = 0L;
            this.initialResponseTimeout = LEG_INITIAL_RESPONSE_TIMEOUT;
            this.finalResponseTimeout = LEG_FINAL_RESPONSE_TIMEOUT;
            this.isOutbound = false;
            this.appContext = EMPTY_STRING;
            this.sigProvider = sigProvider;
            this.rtCommProvider = rtCommProvider;
            this.listener = listener;
            this.remoteTopic = remoteTopic;
            this.remoteEndpointID = remoteEndpointID;
            this.localEndpointID = localEndpointID;
            this.localTopic = localTopic;
            this.state = SigLeg.SigLegState.IDLE;
            this.isOutbound = true;
            if (context != null) {
                this.appContext = context;
            }
            if (retransmissionTimeout != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLegImpl: retransmission timeout = " + retransmissionTimeout), (Object[])new Object[0]);
                }
                this.retransmissionTimeout = retransmissionTimeout;
            }
            if (initialResponseTimeout != 0L) {
                this.initialResponseTimeout = initialResponseTimeout;
            }
            if (finalResponseTimeout != 0L) {
                this.finalResponseTimeout = finalResponseTimeout;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SigLegImpl: STARTING new session   remoteTopic = " + remoteTopic + "  sigSessID = " + sigSessionID), (Object[])new Object[0]);
            }
            this.origStartMessage = message != null ? new SigMessageImpl(SigMessage.SigMethod.START, rtCommProvider, remoteTopic, remoteEndpointID, localEndpointID, localTopic, message) : new SigMessageImpl(SigMessage.SigMethod.START, rtCommProvider, remoteTopic, remoteEndpointID, localEndpointID, localTopic);
            this.origStartMessage.setRetain(retainMessage);
            if (transactionID != null) {
                this.origStartMessage.setTransactionID(transactionID);
                this.startTransactionID = transactionID;
            } else {
                this.startTransactionID = this.origStartMessage.getTransactionID();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SigLegImpl: startTransactionID = " + this.startTransactionID), (Object[])new Object[0]);
            }
            this.sigSessionID = sigSessionID == null ? UUID.randomUUID().toString() : sigSessionID;
            try {
                ((SigMessageImpl)this.origStartMessage).setHeader("toEndpointID", remoteEndpointID);
                ((SigMessageImpl)this.origStartMessage).setHeader("sigSessID", this.sigSessionID);
                this.origStartMessage.setPayload(payload);
                this.origStartMessage.setAppContext(context);
                if (protocols != null) {
                    this.origStartMessage.setProtocols(protocols);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)("Exception occured converting message = " + ex), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SigLegImpl: new outbound leg created: sigSessID = " + this.sigSessionID), (Object[])new Object[0]);
        }
    }

    @Override
    public void activateOutbound() {
        if (this.state != SigLeg.SigLegState.IDLE) {
            throw new IllegalStateException("Can only activate legs in an idle state,");
        }
        if (!this.isOutbound) {
            throw new IllegalStateException("Attempting to activate INBOUND Leg.   This should only be done for OUTBOUND Leg.");
        }
        if (this.origStartMessage != null) {
            this.state = SigLeg.SigLegState.STARTING;
            if (this.retransmissionTimeout != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SigLegImpl: Starting retransmission timer", (Object[])new Object[0]);
                }
                this.retransmissionTimerTask = new RetransmissionTimerTask();
                timer.scheduleAtFixedRate(this.retransmissionTimerTask, this.retransmissionTimeout, this.retransmissionTimeout);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SigLeg:   Starting PranswerTimerTask  -  initialResponseTimeout = " + this.initialResponseTimeout + "    retransmissionTimeout = " + this.retransmissionTimeout), (Object[])new Object[0]);
            }
        } else {
            throw new IllegalStateException("No start message to send.");
        }
        this.initialResponseTimerTask = new PranswerTimerTask();
        timer.schedule(this.initialResponseTimerTask, this.initialResponseTimeout);
        this.origStartMessage.send();
    }

    @Override
    public SigLeg.SigLegState getState() {
        return this.state;
    }

    @Override
    public void acceptLeg(String[] protocols, SigPayload payload) {
        this.acceptLeg(protocols, payload, null);
    }

    @Override
    public void acceptLeg(String[] protocols, SigPayload payload, SigResponseMessage message) {
        if (this.origStartMessage == null) {
            throw new IllegalStateException("This leg did not originate from a remote request.");
        }
        this.state = SigLeg.SigLegState.STARTED;
        SigResponseMessageImpl response = message != null ? new SigResponseMessageImpl(this.origStartMessage, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic, message) : new SigResponseMessageImpl(this.origStartMessage, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic);
        response.setPayload(payload);
        response.setResult(SigResponseMessage.Result.SUCCEEDED);
        response.setTransactionID(this.origStartMessage.getTransactionID());
        if (protocols != null) {
            response.setProtocols(protocols);
        }
        response.send();
    }

    @Override
    public void provisionLeg(String[] protocols, SigPayload payload) {
        if (this.origStartMessage == null) {
            throw new IllegalStateException("This leg did not originate from a remote request.");
        }
        SigMessageImpl sigMessage = new SigMessageImpl(SigMessage.SigMethod.PRANSWER, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic);
        sigMessage.setHeader("sigSessID", this.sigSessionID);
        sigMessage.setPayload(payload);
        sigMessage.setTransactionID(this.origStartMessage.getTransactionID());
        if (protocols != null) {
            sigMessage.setProtocols(protocols);
        }
        sigMessage.send();
    }

    @Override
    public void rejectLeg(String reason) {
        if (this.origStartMessage == null) {
            throw new IllegalStateException("This leg did not originate from a remote request.");
        }
        this.state = SigLeg.SigLegState.FAILED;
        SigResponseMessageImpl response = new SigResponseMessageImpl(this.origStartMessage, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic);
        response.setResult(SigResponseMessage.Result.FAILED);
        response.setReason(reason);
        response.setTransactionID(this.origStartMessage.getTransactionID());
        response.send();
    }

    @Override
    public void setListener(SigLegListener listener) {
        this.listener = listener;
    }

    @Override
    public SigMessage createMessage(SigMessage.SigMethod method) {
        SigMessageImpl message = new SigMessageImpl(method, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic);
        message.setHeader("sigSessID", this.sigSessionID);
        if ((this.state == SigLeg.SigLegState.STARTING || this.state == SigLeg.SigLegState.RINGING) && this.origStartMessage != null) {
            message.setTransactionID(this.origStartMessage.getTransactionID());
        }
        return message;
    }

    @Override
    public SigMessage createMessage(SigMessage message) {
        SigMessageImpl outMessage = new SigMessageImpl(message.getMethod(), this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic, message);
        outMessage.setHeader("sigSessID", this.sigSessionID);
        if ((this.state == SigLeg.SigLegState.STARTING || this.state == SigLeg.SigLegState.RINGING) && this.origStartMessage != null) {
            message.setTransactionID(this.origStartMessage.getTransactionID());
        }
        return outMessage;
    }

    @Override
    public String getSigLegID() {
        return this.sigSessionID;
    }

    @Override
    public String getRemoteEndpointID() {
        return this.remoteEndpointID;
    }

    @Override
    public void setRemoteEndpointID(String remoteEndpointID) {
        this.remoteEndpointID = remoteEndpointID;
    }

    @Override
    public String getAppContext() {
        return this.appContext;
    }

    @Override
    public void setLocalEndpointID(String localEndointID) {
        this.localEndpointID = localEndointID;
    }

    @Override
    public String getLocalEndpointID() {
        return this.localEndpointID;
    }

    @Override
    public void stop(String reason, SigMessage message) {
        SigMessageImpl outMessage;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SigLeg:   stop:  reason = " + reason + " message is: " + message), (Object[])new Object[0]);
        }
        this.cleanupTimerTasks();
        if (message != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SigLeg:   stop:  reason = " + reason + " message is: " + message), (Object[])new Object[0]);
            }
            outMessage = new SigMessageImpl(SigMessage.SigMethod.STOP, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic, message);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SigLeg:   message is null", (Object[])new Object[0]);
            }
            outMessage = new SigMessageImpl(SigMessage.SigMethod.STOP, this.rtCommProvider, this.remoteTopic, this.remoteEndpointID, this.localEndpointID, this.localTopic);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SigLeg: created message: " + outMessage.toString()), (Object[])new Object[0]);
        }
        if (reason != null) {
            outMessage.setReason(reason);
        }
        outMessage.setSigLegID(this.sigSessionID);
        outMessage.send();
        this.state = SigLeg.SigLegState.STOPPED;
    }

    @Override
    public void stop(String reason) {
        this.stop(reason, null);
    }

    @Override
    public long getInitialResponseTimeout() {
        return this.initialResponseTimeout;
    }

    @Override
    public long getFinalResponseTimeout() {
        return this.finalResponseTimeout;
    }

    @Override
    public void addAttribute(String id, Object attr) {
        this.attributeMap.put(id, attr);
    }

    @Override
    public Object getAttribute(String id) {
        return this.attributeMap.get(id);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.attributeMap.remove(id);
    }

    public void setRemoteTopic(String remoteTopic) {
        this.remoteTopic = remoteTopic;
    }

    @Override
    public boolean isOutbound() {
        return this.isOutbound;
    }

    public SigMessage getOrigStartMessage() {
        return this.origStartMessage;
    }

    public void processMessage(SigMessage message) {
        String tempRemoteTopic;
        SigMessage.SigMethod method = message.getMethod();
        if (method == SigMessage.SigMethod.RESPONSE || method == SigMessage.SigMethod.PRANSWER) {
            String transactionID = message.getTransactionID();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SigLeg:   processMessage:  transaction ID: " + transactionID + " startTransaction ID: " + this.startTransactionID), (Object[])new Object[0]);
            }
            if (transactionID == null || !transactionID.equals(this.startTransactionID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg:   processMessage:  ERROR: returned without processing message due to invalid transaction ID: " + transactionID), (Object[])new Object[0]);
                }
                return;
            }
        }
        if ((tempRemoteTopic = ((SigMessageImpl)message).getHeader("fromTopic")) != null) {
            this.remoteTopic = tempRemoteTopic;
        }
        if (this.retransmissionTimerTask != null) {
            this.retransmissionTimerTask.cancel();
            this.retransmissionTimerTask = null;
        }
        if (this.initialResponseTimerTask != null) {
            this.initialResponseTimerTask.cancel();
            this.initialResponseTimerTask = null;
        }
        SigPayload payload = message.getPayload();
        SigPeerContent content = null;
        if (payload != null) {
            content = (SigPeerContent)payload.get("webrtc");
        }
        if (method == SigMessage.SigMethod.RESPONSE) {
            this.cleanupTimerTasks();
            this.startTransactionID = null;
            if (((SigResponseMessage)message).getResult() == SigResponseMessage.Result.SUCCEEDED) {
                this.state = SigLeg.SigLegState.STARTED;
                this.listener.doLegAccepted(this.sigProvider, this, (SigResponseMessage)message);
            } else {
                this.state = SigLeg.SigLegState.FAILED;
                this.listener.doLegRejected(this.sigProvider, this, (SigResponseMessage)message);
            }
        } else if (method == SigMessage.SigMethod.PRANSWER) {
            int holdTimeout = message.getHoldTimeout();
            if (this.finalResponseTimerTask == null) {
                if (holdTimeout != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SigLeg:   Received new HoldTimeout(" + holdTimeout + "sec) resetting finalResponseTimeout"), (Object[])new Object[0]);
                    }
                    this.finalResponseTimeout = holdTimeout * 1000;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg:   Starting RingingTimerTask-  finalResponseTimeout = " + this.finalResponseTimeout), (Object[])new Object[0]);
                }
                this.finalResponseTimerTask = new RingingTimerTask();
                timer.schedule(this.finalResponseTimerTask, this.finalResponseTimeout);
            }
            if (holdTimeout == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg(0):   remoteID = " + this.remoteEndpointID + "    sigSessionID = " + this.sigSessionID + "    Changing state to RINGING"), (Object[])new Object[0]);
                }
                this.state = SigLeg.SigLegState.RINGING;
            }
            this.listener.doPranswer(this.sigProvider, this, message);
        } else if (method == SigMessage.SigMethod.MESSAGE && content != null && content.getType() == SigPeerContent.SigPeerContentType.icecandidate) {
            if (this.state == SigLeg.SigLegState.STARTING) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg(1):   remoteID = " + this.remoteEndpointID + "    sigSessionID = " + this.sigSessionID + "    Changing state to RINGING"), (Object[])new Object[0]);
                }
                this.state = SigLeg.SigLegState.RINGING;
            }
            this.listener.doICECandidate(this.sigProvider, this, message);
        } else {
            if (this.state == SigLeg.SigLegState.STARTING) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg(2):   remoteID = " + this.remoteEndpointID + "    sigSessionID = " + this.sigSessionID + "    Changing state to RINGING"), (Object[])new Object[0]);
                }
                this.state = SigLeg.SigLegState.RINGING;
            }
            this.listener.doMessage(this.sigProvider, this, message);
        }
    }

    @Override
    public void stop(SigMessage message) {
        this.cleanupTimerTasks();
        if (this.listener != null) {
            this.listener.doLegStopped(this.sigProvider, this, message);
        }
    }

    public void destroy(String reason) {
        if (this.listener != null) {
            this.listener.destroyed(this.sigProvider, this, reason);
        }
    }

    private void cleanupTimerTasks() {
        if (this.retransmissionTimerTask != null) {
            this.retransmissionTimerTask.cancel();
            this.retransmissionTimerTask = null;
        }
        if (this.initialResponseTimerTask != null) {
            this.initialResponseTimerTask.cancel();
            this.initialResponseTimerTask = null;
        }
        if (this.finalResponseTimerTask != null) {
            this.finalResponseTimerTask.cancel();
            this.finalResponseTimerTask = null;
        }
    }

    public class RingingTimerTask
    extends TimerTask {
        @Override
        public void run() {
            SigLegImpl.this.state = SigLeg.SigLegState.FAILED;
            SigLegImpl.this.finalResponseTimerTask = null;
            SigLegImpl.this.cleanupTimerTasks();
            if (SigLegImpl.this.listener != null) {
                SigLegImpl.this.listener.doLegTimedout(SigLegImpl.this.sigProvider, SigLegImpl.this, "Timed out waiting for final response from: " + SigLegImpl.this.remoteEndpointID);
            }
        }
    }

    public class PranswerTimerTask
    extends TimerTask {
        @Override
        public void run() {
            SigLegImpl.this.state = SigLeg.SigLegState.FAILED;
            SigLegImpl.this.initialResponseTimerTask = null;
            SigLegImpl.this.cleanupTimerTasks();
            if (SigLegImpl.this.listener != null) {
                SigLegImpl.this.listener.doLegTimedout(SigLegImpl.this.sigProvider, SigLegImpl.this, "Timed out waiting for initial response from: " + SigLegImpl.this.remoteEndpointID);
            }
        }
    }

    public class RetransmissionTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (SigLegImpl.this.state != SigLeg.SigLegState.STARTING) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SigLeg:   RetransmissionTimerTask:   canceling retransmission, Leg is in wrong state = " + (Object)((Object)SigLegImpl.this.state)), (Object[])new Object[0]);
                }
                if (SigLegImpl.this.retransmissionTimerTask != null) {
                    SigLegImpl.this.retransmissionTimerTask.cancel();
                    SigLegImpl.this.retransmissionTimerTask = null;
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SigLeg:   RetransmissionTimerTask:   Timer expired,  retransmitting message", (Object[])new Object[0]);
            }
            SigLegImpl.this.origStartMessage.send();
        }
    }
}

