/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.sig.SigPayloadImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import java.util.UUID;

public class SigMessageImpl
implements SigMessage {
    private static final TraceComponent tc = Tr.register(SigMessageImpl.class);
    public static final String RTCOMM_VERSION = "rtcommVer";
    public static final String METHOD = "method";
    private static int currentMajorVersionNumber = 0;
    private static int currentMinorVersionNumber = 0;
    public static final String START = "START_SESSION";
    public static final String STOP = "STOP_SESSION";
    public static final String PRANSWER = "PRANSWER";
    public static final String SERVICE_QUERY = "SERVICE_QUERY";
    public static final String MESSAGE = "MESSAGE";
    public static final String DOCUMENT = "DOCUMENT";
    public static final String REFER = "REFER";
    public static final String DOCUMENT_REPLACED = "DOCUMENT_REPLACED";
    public static final String GROUP_UPDATE = "GROUP_UPDATE";
    public static final String CONTEXT = "appContext";
    public static final String TO_ENDPOINT_ID = "toEndpointID";
    public static final String PEER_CONTENT = "peerContent";
    public static final String SIG_SESS_ID = "sigSessID";
    public static final String REASON = "reason";
    public static final String TRANSACTION_ID = "transID";
    public static final String FROM_TOPIC = "fromTopic";
    public static final String HOLD_TIMEOUT = "holdTimeout";
    public static final String QUEUE_POSITION = "queuePosition";
    public static final String DETAILS = "details";
    public static final String ADDRESS_TOPIC = "addressTopic";
    public static final String PROTOCOLS = "protocols";
    public static final String PAYLOAD = "payload";
    public static final String PARTICIPANTS = "participants";
    protected RTCommProvider rtCommProvider;
    protected JSONObject messageObject;
    protected String channelID;
    protected String toEndpointID;
    protected String fromEndpointID;
    protected String destTopic;
    protected SigMessage.SigMethod method;
    protected String transactionID;
    protected String sigSessionID;
    protected boolean retain;
    protected int holdTimeout;
    protected String queuePosition;
    protected JSONObject details;
    protected String addressTopic;
    protected String[] protocols;
    protected SigPayloadImpl payload;

    public SigMessageImpl(SigMessage.SigMethod method, RTCommProvider rtCommProvider, String destTopic, String toEndpointID, String fromEndpointID, String fromTopic) {
        this.rtCommProvider = null;
        this.messageObject = null;
        this.channelID = null;
        this.toEndpointID = null;
        this.fromEndpointID = null;
        this.destTopic = null;
        this.method = null;
        this.transactionID = null;
        this.sigSessionID = null;
        this.retain = false;
        this.holdTimeout = 0;
        this.queuePosition = null;
        this.details = null;
        this.addressTopic = null;
        this.protocols = null;
        this.payload = null;
        this.method = method;
        this.rtCommProvider = rtCommProvider;
        this.toEndpointID = toEndpointID;
        this.fromEndpointID = fromEndpointID;
        this.destTopic = destTopic;
        this.messageObject = new JSONObject();
        this.messageObject.put((Object)RTCOMM_VERSION, (Object)"v1.0.0");
        this.messageObject.put((Object)METHOD, (Object)this.convertMethodToString(method));
        if (fromTopic != null && method != SigMessage.SigMethod.STOP) {
            this.messageObject.put((Object)FROM_TOPIC, (Object)fromTopic);
        }
        if (method == SigMessage.SigMethod.SERVICE_QUERY || method == SigMessage.SigMethod.START || method == SigMessage.SigMethod.REFER) {
            this.transactionID = UUID.randomUUID().toString();
            this.messageObject.put((Object)TRANSACTION_ID, (Object)this.transactionID);
        }
        if (toEndpointID != null && method != SigMessage.SigMethod.PRANSWER && method != SigMessage.SigMethod.MESSAGE && method != SigMessage.SigMethod.STOP) {
            this.messageObject.put((Object)TO_ENDPOINT_ID, (Object)toEndpointID);
        }
    }

    public SigMessageImpl(SigMessage.SigMethod method, RTCommProvider rtCommProvider, String destTopic, String toEndpointID, String fromEndpointID, String fromTopic, SigMessage message) {
        this.rtCommProvider = null;
        this.messageObject = null;
        this.channelID = null;
        this.toEndpointID = null;
        this.fromEndpointID = null;
        this.destTopic = null;
        this.method = null;
        this.transactionID = null;
        this.sigSessionID = null;
        this.retain = false;
        this.holdTimeout = 0;
        this.queuePosition = null;
        this.details = null;
        this.addressTopic = null;
        this.protocols = null;
        this.payload = null;
        this.method = method;
        this.rtCommProvider = rtCommProvider;
        this.toEndpointID = toEndpointID;
        this.fromEndpointID = fromEndpointID;
        this.destTopic = destTopic;
        this.messageObject = ((SigMessageImpl)message).copyMessage();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MessageObject is: " + this.messageObject.toString()), (Object[])new Object[0]);
        }
        this.messageObject.put((Object)METHOD, (Object)this.convertMethodToString(method));
        if (fromTopic != null && method != SigMessage.SigMethod.STOP) {
            this.messageObject.put((Object)FROM_TOPIC, (Object)fromTopic);
        }
        if (method == SigMessage.SigMethod.SERVICE_QUERY || method == SigMessage.SigMethod.START || method == SigMessage.SigMethod.REFER) {
            this.transactionID = UUID.randomUUID().toString();
            this.messageObject.put((Object)TRANSACTION_ID, (Object)this.transactionID);
        }
        if (toEndpointID != null && method != SigMessage.SigMethod.PRANSWER && method != SigMessage.SigMethod.MESSAGE && method != SigMessage.SigMethod.STOP) {
            this.messageObject.put((Object)TO_ENDPOINT_ID, (Object)toEndpointID);
        }
    }

    public SigMessageImpl(JSONObject rawMessage, RTCommProvider rtCommProvider) {
        block5: {
            this.rtCommProvider = null;
            this.messageObject = null;
            this.channelID = null;
            this.toEndpointID = null;
            this.fromEndpointID = null;
            this.destTopic = null;
            this.method = null;
            this.transactionID = null;
            this.sigSessionID = null;
            this.retain = false;
            this.holdTimeout = 0;
            this.queuePosition = null;
            this.details = null;
            this.addressTopic = null;
            this.protocols = null;
            this.payload = null;
            this.rtCommProvider = rtCommProvider;
            try {
                this.messageObject = rawMessage;
                String versionNumber = (String)this.messageObject.get((Object)RTCOMM_VERSION);
                if (this.isVersionCompatible(null)) {
                    String methodString = (String)this.messageObject.get((Object)METHOD);
                    this.method = this.convertStringToMethod(methodString);
                    this.transactionID = (String)this.messageObject.get((Object)TRANSACTION_ID);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid webrtc signaling protocol version number = " + versionNumber), (Object[])new Object[0]);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Exception occured converting message = " + ex), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void send() {
        block2: {
            try {
                this.rtCommProvider.sendMessage(this.messageObject, this.destTopic, this.fromEndpointID, this.retain);
            }
            catch (RTCommException ex) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception occured sending message = " + (Object)((Object)ex)), (Object[])new Object[0]);
            }
        }
    }

    public JSONObject copyMessage() {
        JSONObject message = (JSONObject)this.messageObject.clone();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("message is now: " + message), (Object[])new Object[0]);
        }
        return message;
    }

    public JSONObject render() {
        return this.messageObject;
    }

    @Override
    public void clear() {
        this.messageObject = null;
    }

    @Override
    public SigMessage.SigMethod getMethod() {
        return this.method;
    }

    @Override
    public void setHeader(String key, String value) {
        this.messageObject.put((Object)key, (Object)value);
    }

    @Override
    public String getHeader(String key) {
        return (String)this.messageObject.get((Object)key);
    }

    @Override
    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
        this.messageObject.put((Object)TRANSACTION_ID, (Object)transactionID);
    }

    @Override
    public String getTransactionID() {
        return this.transactionID;
    }

    @Override
    public void setAppContext(String appContext) {
        if (appContext != null && !appContext.isEmpty()) {
            this.messageObject.put((Object)CONTEXT, (Object)appContext);
        }
    }

    @Override
    public String getAppContext() {
        return (String)this.messageObject.get((Object)CONTEXT);
    }

    public void setSigLegID(String sigLegID) {
        this.sigSessionID = sigLegID;
        if (this.sigSessionID != null) {
            this.messageObject.put((Object)SIG_SESS_ID, (Object)this.sigSessionID);
        }
    }

    public String getSigLegID() {
        if (this.sigSessionID == null) {
            this.sigSessionID = (String)this.messageObject.get((Object)SIG_SESS_ID);
        }
        return this.sigSessionID;
    }

    @Override
    public String getReason() {
        return (String)this.messageObject.get((Object)REASON);
    }

    @Override
    public void setReason(String reason) {
        if (reason != null) {
            this.messageObject.put((Object)REASON, (Object)reason);
        }
    }

    @Override
    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    @Override
    public void setHoldTimeout(int holdTimeout) {
        this.holdTimeout = holdTimeout;
        this.messageObject.put((Object)HOLD_TIMEOUT, (Object)Integer.toString(holdTimeout));
    }

    @Override
    public int getHoldTimeout() {
        String localHoldTimeout = (String)this.messageObject.get((Object)HOLD_TIMEOUT);
        this.holdTimeout = localHoldTimeout != null ? Integer.parseInt(localHoldTimeout) : 0;
        return this.holdTimeout;
    }

    @Override
    public void setQueuePosition(String queuePosition) {
        this.queuePosition = queuePosition;
        this.messageObject.put((Object)QUEUE_POSITION, (Object)queuePosition);
    }

    @Override
    public String getQueuePosition() {
        this.queuePosition = (String)this.messageObject.get((Object)QUEUE_POSITION);
        return this.queuePosition;
    }

    @Override
    public void setDetails(JSONObject details) {
        this.details = details;
        this.messageObject.put((Object)DETAILS, (Object)details);
    }

    @Override
    public JSONObject getDetails() {
        this.details = (JSONObject)this.messageObject.get((Object)DETAILS);
        return this.details;
    }

    @Override
    public void setParticipants(String[] participants) {
        if (participants != null) {
            JSONArray tempArray = new JSONArray();
            for (int i = 0; i < participants.length; ++i) {
                tempArray.add((Object)participants[i]);
            }
            this.messageObject.put((Object)PARTICIPANTS, (Object)tempArray);
        }
    }

    @Override
    public String[] getParticipants() {
        String[] participants = null;
        JSONArray tempArray = (JSONArray)this.messageObject.get((Object)PARTICIPANTS);
        if (tempArray != null) {
            participants = new String[tempArray.size()];
            for (int i = 0; i < tempArray.size(); ++i) {
                participants[i] = (String)tempArray.get(i);
            }
        }
        return participants;
    }

    @Override
    public void setPayload(SigPayload payload) {
        if (payload != null) {
            if (!(payload instanceof SigPayloadImpl)) {
                throw new IllegalArgumentException("Invalid Instance of SigPayload");
            }
            this.payload = (SigPayloadImpl)payload;
            this.messageObject.put((Object)PAYLOAD, (Object)this.payload.getJSON());
        }
    }

    @Override
    public SigPayload getPayload() {
        SigPayloadImpl sigPayload;
        block3: {
            sigPayload = null;
            JSONObject tempPayload = (JSONObject)this.messageObject.get((Object)PAYLOAD);
            if (tempPayload != null) {
                try {
                    sigPayload = new SigPayloadImpl(tempPayload);
                }
                catch (Exception ex) {
                    sigPayload = null;
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Exception getting payload = " + ex), (Object[])new Object[0]);
                }
            }
        }
        return sigPayload;
    }

    @Override
    public String getFromEndpointID() {
        return this.fromEndpointID;
    }

    @Override
    public String getToEndpointID() {
        return this.toEndpointID;
    }

    @Override
    public void setFromEndpointID(String fromEndpointID) {
        this.fromEndpointID = fromEndpointID;
    }

    @Override
    public void setAddressTopic(String addressTopic) {
        this.addressTopic = addressTopic;
        this.messageObject.put((Object)ADDRESS_TOPIC, (Object)addressTopic);
    }

    @Override
    public String getAddressTopic() {
        this.addressTopic = (String)this.messageObject.get((Object)ADDRESS_TOPIC);
        return this.addressTopic;
    }

    @Override
    public String getVersion() {
        return (String)this.messageObject.get((Object)RTCOMM_VERSION);
    }

    @Override
    public void setProtocols(String[] protocols) {
        if (protocols != null) {
            JSONArray tempArray = new JSONArray();
            for (int i = 0; i < protocols.length; ++i) {
                tempArray.add((Object)protocols[i]);
            }
            this.messageObject.put((Object)PROTOCOLS, (Object)tempArray);
        }
    }

    @Override
    public String[] getProtocols() {
        String[] protocols = null;
        JSONArray tempArray = (JSONArray)this.messageObject.get((Object)PROTOCOLS);
        if (tempArray != null) {
            protocols = new String[tempArray.size()];
            for (int i = 0; i < tempArray.size(); ++i) {
                protocols[i] = (String)tempArray.get(i);
            }
        }
        return protocols;
    }

    @Override
    public boolean isVersionCompatible(String behaviorVersionNumber) {
        String messageVersionNumber;
        int messageMajorVersionNumber;
        boolean returnValue = true;
        int behaviorMajorVersionNumber = 0;
        behaviorMajorVersionNumber = behaviorVersionNumber == null ? currentMajorVersionNumber : SigMessageImpl.parseMajorVersionNumber(behaviorVersionNumber);
        if (behaviorMajorVersionNumber != (messageMajorVersionNumber = SigMessageImpl.parseMajorVersionNumber(messageVersionNumber = (String)this.messageObject.get((Object)RTCOMM_VERSION)))) {
            returnValue = false;
        }
        return returnValue;
    }

    protected String convertMethodToString(SigMessage.SigMethod method) {
        String methodString = null;
        switch (method) {
            case START: {
                methodString = START;
                break;
            }
            case STOP: {
                methodString = STOP;
                break;
            }
            case PRANSWER: {
                methodString = PRANSWER;
                break;
            }
            case MESSAGE: {
                methodString = MESSAGE;
                break;
            }
            case SERVICE_QUERY: {
                methodString = SERVICE_QUERY;
                break;
            }
            case DOCUMENT: {
                methodString = DOCUMENT;
                break;
            }
            case REFER: {
                methodString = REFER;
                break;
            }
            case DOCUMENT_REPLACED: {
                methodString = DOCUMENT_REPLACED;
                break;
            }
            case GROUP_UPDATE: {
                methodString = GROUP_UPDATE;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"convertMethodToString: invalid method", (Object[])new Object[0]);
            }
        }
        return methodString;
    }

    protected SigMessage.SigMethod convertStringToMethod(String methodString) {
        SigMessage.SigMethod method = null;
        if (methodString.compareTo(START) == 0) {
            method = SigMessage.SigMethod.START;
        } else if (methodString.compareTo(STOP) == 0) {
            method = SigMessage.SigMethod.STOP;
        } else if (methodString.compareTo(PRANSWER) == 0) {
            method = SigMessage.SigMethod.PRANSWER;
        } else if (methodString.compareTo(MESSAGE) == 0) {
            method = SigMessage.SigMethod.MESSAGE;
        } else if (methodString.compareTo(SERVICE_QUERY) == 0) {
            method = SigMessage.SigMethod.SERVICE_QUERY;
        } else if (methodString.compareTo(DOCUMENT) == 0) {
            method = SigMessage.SigMethod.DOCUMENT;
        } else if (methodString.compareTo(REFER) == 0) {
            method = SigMessage.SigMethod.REFER;
        } else if (methodString.compareTo(DOCUMENT_REPLACED) == 0) {
            method = SigMessage.SigMethod.DOCUMENT_REPLACED;
        } else if (methodString.compareTo(GROUP_UPDATE) == 0) {
            method = SigMessage.SigMethod.GROUP_UPDATE;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertStringToMethod: unknow method", (Object[])new Object[0]);
        }
        return method;
    }

    private static int parseMajorVersionNumber(String versionNumberString) {
        String majorVersionNumberString = versionNumberString.substring(versionNumberString.indexOf("v") + 1, versionNumberString.indexOf("."));
        int tempMajorVersionNumber = Integer.valueOf(majorVersionNumberString);
        return tempMajorVersionNumber;
    }

    private static int parseMinorVersionNumber(String versionNumberString) {
        String tempMinorVersionNumberString = versionNumberString.substring(versionNumberString.indexOf(".") + 1);
        tempMinorVersionNumberString = tempMinorVersionNumberString.substring(0, tempMinorVersionNumberString.indexOf("."));
        int tempMinorVersionNumber = Integer.valueOf(tempMinorVersionNumberString);
        return tempMinorVersionNumber;
    }

    static {
        currentMajorVersionNumber = SigMessageImpl.parseMajorVersionNumber("v1.0.0");
        currentMinorVersionNumber = SigMessageImpl.parseMinorVersionNumber("v1.0.0");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sig Version Numbers:   major = " + currentMajorVersionNumber + "  minor = " + currentMinorVersionNumber), (Object[])new Object[0]);
        }
    }
}

