/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.sig.SigContentImpl;
import com.ibm.ws.rtcomm.sig.SigPeerContentImpl;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import java.util.ArrayList;
import java.util.Iterator;

public class SigPayloadImpl
implements SigPayload {
    private static final TraceComponent tc = Tr.register(SigPayloadImpl.class);
    private JSONObject output = null;

    SigPayloadImpl() {
    }

    SigPayloadImpl(JSONObject jsonObject) {
        this.output = jsonObject;
    }

    @Override
    public JSONObject getJSON() {
        return this.output;
    }

    @Override
    public void add(String protocolName, SigContent content) {
        if (this.output == null) {
            this.output = new JSONObject();
        }
        this.output.put((Object)protocolName, (Object)content.getContent());
    }

    @Override
    public SigContent get(String protocolName) {
        SigContent sigContent;
        block3: {
            sigContent = null;
            try {
                JSONObject content = (JSONObject)this.output.get((Object)protocolName);
                if (content != null) {
                    sigContent = protocolName.compareToIgnoreCase("webrtc") == 0 ? new SigPeerContentImpl(content) : new SigContentImpl(content);
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("exception caught creating object = " + ex), (Object[])new Object[0]);
            }
        }
        return sigContent;
    }

    @Override
    public void remove(String protocolName) {
        this.output.remove((Object)protocolName);
    }

    @Override
    public int getNumberOfPayloadTypes() {
        if (this.output == null) {
            return 0;
        }
        return this.output.size();
    }

    @Override
    public Iterator getPayloadTypes() {
        if (this.output == null) {
            return null;
        }
        return this.output.keySet().iterator();
    }

    @Override
    public String[] getPayloadProtocols() {
        ArrayList<String> payloadProtocols = new ArrayList<String>(this.getNumberOfPayloadTypes());
        Iterator it = this.getPayloadTypes();
        if (it != null) {
            while (it.hasNext()) {
                String protocolName = (String)it.next();
                payloadProtocols.add(protocolName);
            }
        }
        return payloadProtocols.toArray(new String[this.getNumberOfPayloadTypes()]);
    }
}

