/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SigPeerContentImpl
implements SigPeerContent {
    private static final TraceComponent tc = Tr.register(SigPeerContentImpl.class);
    public static final String TYPE = "type";
    private String rawSDPString = null;
    private JSONObject rawUserData = null;
    private JSONObject rawCandidate = null;
    private JSONObject rawDetails = null;
    private SigPeerContent.SigPeerContentType type;

    public SigPeerContentImpl(SigPeerContent.SigPeerContentType type) {
        this.type = type;
    }

    public SigPeerContentImpl(JSONObject jsonObject) throws IOException, UnsupportedEncodingException {
        String typeString = (String)jsonObject.get((Object)TYPE);
        if (typeString != null) {
            if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.offer.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.offer;
            } else if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.answer.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.answer;
            } else if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.pranswer.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.pranswer;
            } else if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.icecandidate.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.icecandidate;
            } else if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.user.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.user;
            } else if (typeString.compareToIgnoreCase(SigPeerContent.SigPeerContentType.refer.toString()) == 0) {
                this.type = SigPeerContent.SigPeerContentType.refer;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("INVALID Content type = " + typeString), (Object[])new Object[0]);
            }
        }
        this.rawSDPString = (String)jsonObject.get((Object)SigPeerContent.SigPeerContentTypeValue.sdp.toString());
        this.rawCandidate = (JSONObject)jsonObject.get((Object)SigPeerContent.SigPeerContentTypeValue.candidate.toString());
        this.rawUserData = (JSONObject)jsonObject.get((Object)SigPeerContent.SigPeerContentTypeValue.userdata.toString());
        this.rawDetails = (JSONObject)jsonObject.get((Object)SigPeerContent.SigPeerContentTypeValue.details.toString());
    }

    @Override
    public SigPeerContent.SigPeerContentType getType() {
        return this.type;
    }

    @Override
    public String getRawSDP() {
        return this.rawSDPString;
    }

    @Override
    public void setRawSDP(String rawSDPString) {
        this.rawSDPString = rawSDPString;
    }

    @Override
    public JSONObject getRawCandidate() {
        return this.rawCandidate;
    }

    @Override
    public void setRawCandidate(JSONObject rawCandidate) {
        this.rawCandidate = rawCandidate;
    }

    @Override
    public void setUserData(JSONObject rawUserData) {
        this.rawUserData = rawUserData;
    }

    @Override
    public JSONObject getUserData() {
        return this.rawUserData;
    }

    @Override
    public void setReferDetails(JSONObject details) {
        this.rawDetails = details;
    }

    @Override
    public JSONObject getReferDetails() {
        return this.rawDetails;
    }

    @Override
    public JSONObject getContent() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)TYPE, (Object)this.type.toString());
        if (this.rawSDPString != null) {
            jsonObject.put((Object)SigPeerContent.SigPeerContentTypeValue.sdp.toString(), (Object)this.rawSDPString);
        }
        if (this.rawCandidate != null) {
            jsonObject.put((Object)SigPeerContent.SigPeerContentTypeValue.candidate.toString(), (Object)this.rawCandidate);
        }
        if (this.rawUserData != null) {
            jsonObject.put((Object)SigPeerContent.SigPeerContentTypeValue.userdata.toString(), (Object)this.rawUserData);
        }
        if (this.rawDetails != null) {
            jsonObject.put((Object)SigPeerContent.SigPeerContentTypeValue.details.toString(), (Object)this.rawDetails);
        }
        return jsonObject;
    }

    @Override
    public void setContent(JSONObject content) {
    }
}

