/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.sig.SigContentImpl;
import com.ibm.ws.rtcomm.sig.SigLegImpl;
import com.ibm.ws.rtcomm.sig.SigMessageImpl;
import com.ibm.ws.rtcomm.sig.SigPayloadImpl;
import com.ibm.ws.rtcomm.sig.SigPeerContentImpl;
import com.ibm.ws.rtcomm.sig.SigResponseMessageImpl;
import com.ibm.wsspi.rtcomm.RTCommException;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.RTCommProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigContent;
import com.ibm.wsspi.rtcomm.sig.SigLeg;
import com.ibm.wsspi.rtcomm.sig.SigLegListener;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigPayload;
import com.ibm.wsspi.rtcomm.sig.SigPeerContent;
import com.ibm.wsspi.rtcomm.sig.SigProvider;
import com.ibm.wsspi.rtcomm.sig.SigProviderListener;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class SigProviderImpl
extends SigProvider {
    private static final TraceComponent tc = Tr.register(SigProviderImpl.class, (String)"Rtcomm", (String)"com.ibm.ws.rtcomm.resources.Rtcomm");
    private volatile RTCommProvider rtCommProvider = null;
    private SigProviderListener providerListener = null;
    private SigProvider sigProvider = null;
    private String providerTopicName = null;
    private String nonsharedTopicName = null;
    private RTCommProviderListener rtcommListener = null;
    private String sphereTopicName = null;
    private Map<String, SigLegImpl> sigLegMap = new ConcurrentHashMap<String, SigLegImpl>();

    public SigProviderImpl(String providerTopicName, String sharedTopicPath, String primaryMessageServerURL, String secondaryMessageServerURL, String nonsharedTopicPath, String sphereTopicName) {
        if (sharedTopicPath == null) {
            sharedTopicPath = "/";
        }
        if (!sharedTopicPath.endsWith("/")) {
            sharedTopicPath = sharedTopicPath + "/";
        }
        if (nonsharedTopicPath == null) {
            nonsharedTopicPath = "/";
        }
        if (!nonsharedTopicPath.endsWith("/")) {
            nonsharedTopicPath = nonsharedTopicPath + "/";
        }
        if ((primaryMessageServerURL == null || primaryMessageServerURL.isEmpty()) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("primaryMessageServerURL is invalid = " + primaryMessageServerURL), (Object[])new Object[0]);
        }
        Random random = new Random();
        random.setSeed(System.nanoTime());
        int randomNumber = random.nextInt(Integer.MAX_VALUE);
        this.nonsharedTopicName = nonsharedTopicPath + randomNumber;
        if (sphereTopicName != null) {
            this.sphereTopicName = nonsharedTopicPath + sphereTopicName;
        }
        if (providerTopicName != null) {
            this.providerTopicName = sharedTopicPath + providerTopicName;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate1:    nonsharedTopicName = " + this.nonsharedTopicName + "    providerTopicName = " + this.providerTopicName + "    nonsharedTopicPath = " + nonsharedTopicPath + "    primary server = " + primaryMessageServerURL + "    secondary server = " + secondaryMessageServerURL), (Object[])new Object[0]);
        }
        this.rtCommProvider = RTCommProvider.createRTCommProvider((String)primaryMessageServerURL, (String)secondaryMessageServerURL);
    }

    @Override
    public void setWill(String lwtTopicName, String fromEndpointID, SigMessage message) {
        if (lwtTopicName != null) {
            this.rtCommProvider.setWill(lwtTopicName, fromEndpointID, ((SigMessageImpl)message).render());
        }
    }

    @Override
    public void destroy() {
        block4: {
            if (this.rtcommListener != null) {
                try {
                    Iterator<SigLegImpl> iterator = this.sigLegMap.values().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().destroy("Service shuting down");
                    }
                    this.sigLegMap.clear();
                    this.rtCommProvider.unregisterListener(this.rtcommListener);
                    this.rtcommListener = null;
                }
                catch (RTCommException e) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("destroy: Exception e: " + (Object)((Object)e)), (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void setSigProviderListener(SigProviderListener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setSigProviderListener", (Object[])new Object[0]);
        }
        if (this.providerListener != null) {
            throw new IllegalStateException("setSigProviderListener: SigProviderListener already exist!");
        }
        this.providerListener = listener;
        if (this.rtCommProvider != null) {
            try {
                this.rtcommListener = new Listener();
                this.rtCommProvider.registerListener(this.rtcommListener, this.providerTopicName, this.nonsharedTopicName, this.sphereTopicName);
            }
            catch (RTCommException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setSigProviderListener: ERROR: Exception: " + e.toString()), (Object[])new Object[0]);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setSigProviderListener: ERROR: rtCommProvider = null", (Object[])new Object[0]);
        }
    }

    @Override
    public SigPeerContent createPeerContent(SigPeerContent.SigPeerContentType type) {
        return new SigPeerContentImpl(type);
    }

    @Override
    public SigContent createContent(JSONObject content) {
        return new SigContentImpl(content);
    }

    @Override
    public SigPayload createPayload() {
        return new SigPayloadImpl();
    }

    @Override
    public SigMessage createMessage(SigMessage.SigMethod method, String destination, String toEndpointID, String fromEndpointID) {
        SigMessageImpl message = new SigMessageImpl(method, this.rtCommProvider, destination, toEndpointID, fromEndpointID, this.nonsharedTopicName);
        return message;
    }

    @Override
    public SigResponseMessage createResponse(SigMessage origMessage, String toEndointID, String fromEndpointID) {
        SigResponseMessageImpl message = new SigResponseMessageImpl(origMessage, this.rtCommProvider, ((SigMessageImpl)origMessage).getHeader("fromTopic"), toEndointID, fromEndpointID, this.nonsharedTopicName);
        return message;
    }

    @Override
    public SigLeg createLeg(String toEndpointID, String fromEndpointID, String[] protocols, SigPayload payload, String destination, String context, SigLegListener listener, long retransmissionTimeout, long initialResponseTimeout, long finalResponseTimeout, String transactionID, boolean retainMessage, String sigLegID, SigMessage message) {
        SigLegImpl leg = new SigLegImpl(this, this.rtCommProvider, listener, toEndpointID, fromEndpointID, destination, protocols, payload, context, this.nonsharedTopicName, retransmissionTimeout, initialResponseTimeout, finalResponseTimeout, transactionID, retainMessage, sigLegID, message);
        if (this.sigLegMap.containsKey(leg.getSigLegID()) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ERROR:   INVALID sigLegID = " + leg.getSigLegID() + "    ID already exists!!!"), (Object[])new Object[0]);
        }
        this.sigLegMap.put(leg.getSigLegID(), leg);
        return leg;
    }

    @Override
    public String getClientID() {
        return this.rtCommProvider.getClientID();
    }

    public static SigMessage deserializeMessage(JSONObject message) {
        SigMessageImpl returnValue = null;
        String method = (String)message.get((Object)"method");
        returnValue = method.equals("RESPONSE") ? new SigResponseMessageImpl(message, null) : new SigMessageImpl(message, null);
        return returnValue;
    }

    public static SigMessage createMessage(SigMessage.SigMethod method, RTCommProvider provider, String destinationTopic) {
        return new SigMessageImpl(method, provider, destinationTopic, null, null, null);
    }

    private SigMessage createMessage(JSONObject message, RTCommProvider provider) {
        SigMessageImpl returnValue = null;
        String method = (String)message.get((Object)"method");
        returnValue = method.equals("RESPONSE") ? new SigResponseMessageImpl(message, provider) : new SigMessageImpl(message, provider);
        return returnValue;
    }

    public class Listener
    implements RTCommProviderListener {
        public void messageReceived(String topicName, JSONObject message) {
            String fromEndpointID = topicName;
            if (topicName != null && topicName.contains("/")) {
                int slash = topicName.lastIndexOf("/");
                fromEndpointID = topicName.substring(slash + 1, topicName.length());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("messageReceived: topicName = " + topicName + "    fromEndpointID = " + fromEndpointID), (Object[])new Object[0]);
            }
            if (message == null) {
                if (SigProviderImpl.this.sphereTopicName != null && topicName.startsWith(SigProviderImpl.this.sphereTopicName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("messageReceived: LAST WILL received from : " + fromEndpointID), (Object[])new Object[0]);
                    }
                    Iterator iterator = SigProviderImpl.this.sigLegMap.values().iterator();
                    while (iterator.hasNext()) {
                        SigLegImpl leg = (SigLegImpl)iterator.next();
                        if (leg.getRemoteEndpointID().compareTo(fromEndpointID) != 0) continue;
                        SigProviderImpl.this.sigLegMap.remove(leg.getSigLegID());
                        SigMessageImpl stopMessage = new SigMessageImpl(SigMessage.SigMethod.STOP, SigProviderImpl.this.rtCommProvider, null, fromEndpointID, leg.getLocalEndpointID(), SigProviderImpl.this.nonsharedTopicName);
                        stopMessage.setReason("Client connection broken");
                        leg.stop(stopMessage);
                        iterator = SigProviderImpl.this.sigLegMap.values().iterator();
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"messageReceived: error:  empty message received over non-sphere topic name, trashing message.", (Object[])new Object[0]);
                }
                return;
            }
            SigMessageImpl sigMessage = (SigMessageImpl)SigProviderImpl.this.createMessage(message, SigProviderImpl.this.rtCommProvider);
            if (sigMessage.getMethod() == SigMessage.SigMethod.DOCUMENT) {
                return;
            }
            String versionNumber = sigMessage.getVersion();
            if (!sigMessage.isVersionCompatible(null)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("****   Unsupported version number received = " + versionNumber), (Object[])new Object[0]);
                }
                if (sigMessage.getMethod() != SigMessage.SigMethod.RESPONSE) {
                    SigResponseMessage response = SigProviderImpl.this.createResponse(sigMessage, fromEndpointID, sigMessage.getHeader("toEndpointID"));
                    response.setResult(SigResponseMessage.Result.FAILED);
                    response.setReason("Incompatible Version Number");
                    response.send();
                }
                return;
            }
            String sigLegID = sigMessage.getSigLegID();
            if (sigMessage.getMethod() == SigMessage.SigMethod.START && sigLegID != null) {
                if (SigProviderImpl.this.providerListener != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"START Session received:", (Object[])new Object[0]);
                    }
                    String toEndpointID = sigMessage.getHeader("toEndpointID");
                    SigLegImpl leg = new SigLegImpl(sigMessage, SigProviderImpl.this, SigProviderImpl.this.rtCommProvider, toEndpointID, fromEndpointID, sigLegID, SigProviderImpl.this.nonsharedTopicName);
                    SigProviderImpl.this.sigLegMap.put(sigLegID, leg);
                    SigProviderImpl.this.providerListener.doStartLeg(SigProviderImpl.this.sigProvider, fromEndpointID, leg, sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.STOP && sigLegID != null) {
                SigLegImpl leg;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"STOP Session received:", (Object[])new Object[0]);
                }
                if ((leg = (SigLegImpl)SigProviderImpl.this.sigLegMap.remove(sigLegID)) != null) {
                    leg.stop(sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR:   Invalid Sig Session ID received, trashing message", (Object[])new Object[0]);
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.SERVICE_QUERY) {
                if (SigProviderImpl.this.providerListener != null) {
                    SigProviderImpl.this.providerListener.doServiceQuery(SigProviderImpl.this.sigProvider, fromEndpointID, sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (sigLegID != null) {
                SigLegImpl leg = (SigLegImpl)SigProviderImpl.this.sigLegMap.get(sigLegID);
                if (leg != null) {
                    String remoteEndpointID = leg.getRemoteEndpointID();
                    if (leg.getState() != SigLeg.SigLegState.STARTING && fromEndpointID.compareTo(remoteEndpointID) != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ERROR: A client is attempting to respond to a session that has already been accepted", (Object[])new Object[0]);
                        }
                        SigMessageImpl stopMessage = new SigMessageImpl(SigMessage.SigMethod.STOP, SigProviderImpl.this.rtCommProvider, sigMessage.getHeader("fromTopic"), fromEndpointID, leg.getLocalEndpointID(), SigProviderImpl.this.nonsharedTopicName);
                        stopMessage.setSigLegID(sigMessage.getSigLegID());
                        stopMessage.setReason("Session is already active");
                        stopMessage.send();
                    } else {
                        if (leg.getState() == SigLeg.SigLegState.STARTING && fromEndpointID.compareTo(remoteEndpointID) != 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("leg is in STARTING state, changing remoteEndpointID from <" + remoteEndpointID + "> to <" + fromEndpointID + ">"), (Object[])new Object[0]);
                            }
                            leg.setRemoteEndpointID(fromEndpointID);
                        }
                        leg.processMessage(sigMessage);
                    }
                } else if (sigMessage.getMethod() == SigMessage.SigMethod.PRANSWER) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ERROR:  PRANSWER received w/o an associated session.", (Object[])new Object[0]);
                    }
                    SigMessageImpl stopMessage = new SigMessageImpl(SigMessage.SigMethod.STOP, SigProviderImpl.this.rtCommProvider, sigMessage.getHeader("fromTopic"), fromEndpointID, sigMessage.getHeader("toEndpointID"), SigProviderImpl.this.nonsharedTopicName);
                    stopMessage.setSigLegID(sigMessage.getSigLegID());
                    stopMessage.setReason("Session does not exist.");
                    stopMessage.send();
                    if (SigProviderImpl.this.providerListener != null) {
                        SigProviderImpl.this.providerListener.doPranswer(SigProviderImpl.this.sigProvider, sigMessage.getHeader("toEndpointID"), sigMessage);
                    }
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.MESSAGE) {
                if (SigProviderImpl.this.providerListener != null) {
                    SigProviderImpl.this.providerListener.doMessage(SigProviderImpl.this.sigProvider, fromEndpointID, sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.RESPONSE) {
                if (SigProviderImpl.this.providerListener != null) {
                    SigProviderImpl.this.providerListener.doResponse(SigProviderImpl.this.sigProvider, fromEndpointID, (SigResponseMessage)((Object)sigMessage));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.REFER) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("messageReceived: REFER received from : " + fromEndpointID), (Object[])new Object[0]);
                }
                if (SigProviderImpl.this.providerListener != null) {
                    SigProviderImpl.this.providerListener.doRefer(SigProviderImpl.this.sigProvider, fromEndpointID, sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (sigMessage.getMethod() == SigMessage.SigMethod.GROUP_UPDATE) {
                if (SigProviderImpl.this.providerListener != null) {
                    SigProviderImpl.this.providerListener.doGroupUpdate(SigProviderImpl.this.sigProvider, fromEndpointID, sigMessage);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: There is no sig provider listener. Dropping received message.", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("messageReceived: invalid message type received: " + (Object)((Object)sigMessage.getMethod())), (Object[])new Object[0]);
            }
        }
    }
}

