/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rtcomm.sig;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rtcomm.sig.SigMessageImpl;
import com.ibm.wsspi.rtcomm.RTCommProvider;
import com.ibm.wsspi.rtcomm.sig.SigMessage;
import com.ibm.wsspi.rtcomm.sig.SigResponseMessage;

public class SigResponseMessageImpl
extends SigMessageImpl
implements SigResponseMessage {
    private static final TraceComponent tc = Tr.register(SigResponseMessageImpl.class);
    public static final String RESPONSE = "RESPONSE";
    public static final String SERVICES = "services";
    public static final String ORIGINAL_METHOD = "orig";
    public static final String RESULT = "result";
    public static final String ENDPOINT_TOPIC = "endpointTopicName";
    public static final String FAILURE = "FAILURE";
    public static final String SUCCESS = "SUCCESS";
    private JSONObject services = null;

    public SigResponseMessageImpl(SigMessage origMessage, RTCommProvider rtCommProvider, String destTopic, String toEndpointID, String fromEndpointID, String fromTopic) {
        super(SigMessage.SigMethod.RESPONSE, rtCommProvider, destTopic, toEndpointID, fromEndpointID, fromTopic);
        this.setTransactionID(origMessage.getTransactionID());
        this.setSigLegID(((SigMessageImpl)origMessage).getSigLegID());
        this.messageObject.put((Object)ORIGINAL_METHOD, (Object)((SigMessageImpl)origMessage).getHeader("method"));
        if (origMessage.getMethod() != SigMessage.SigMethod.START) {
            this.messageObject.remove((Object)"fromTopic");
            this.messageObject.remove((Object)"toEndpointID");
        }
    }

    public SigResponseMessageImpl(SigMessage origMessage, RTCommProvider rtCommProvider, String destTopic, String toEndpointID, String fromEndpointID, String fromTopic, SigResponseMessage message) {
        super(SigMessage.SigMethod.RESPONSE, rtCommProvider, destTopic, toEndpointID, fromEndpointID, fromTopic, message);
        this.setTransactionID(origMessage.getTransactionID());
        this.setSigLegID(((SigMessageImpl)origMessage).getSigLegID());
        this.messageObject.put((Object)ORIGINAL_METHOD, (Object)((SigMessageImpl)origMessage).getHeader("method"));
        if (origMessage.getMethod() != SigMessage.SigMethod.START) {
            this.messageObject.remove((Object)"fromTopic");
            this.messageObject.remove((Object)"toEndpointID");
        }
    }

    public SigResponseMessageImpl(JSONObject rawMessage, RTCommProvider rtCommProvider) {
        super(rawMessage, rtCommProvider);
    }

    @Override
    public SigResponseMessage.SigResponseType getResponseType() {
        String originalMethod = (String)this.messageObject.get((Object)ORIGINAL_METHOD);
        if (originalMethod.equals("SERVICE_QUERY")) {
            return SigResponseMessage.SigResponseType.SERVICE_QUERY_RESPONSE;
        }
        if (originalMethod.equals("START_SESSION")) {
            return SigResponseMessage.SigResponseType.START_RESPONSE;
        }
        if (originalMethod.equals("REFER")) {
            return SigResponseMessage.SigResponseType.REFER_RESPONSE;
        }
        throw new IllegalStateException("Invalid response message: original method = " + originalMethod);
    }

    @Override
    public SigResponseMessage.Result getResult() {
        SigResponseMessage.Result returnValue = SigResponseMessage.Result.FAILED;
        String result = (String)this.messageObject.get((Object)RESULT);
        returnValue = result != null ? (result.equals(SUCCESS) ? SigResponseMessage.Result.SUCCEEDED : (result.equals(FAILURE) ? SigResponseMessage.Result.FAILED : SigResponseMessage.Result.NO_RESULT)) : SigResponseMessage.Result.NO_RESULT;
        return returnValue;
    }

    @Override
    public void setResult(SigResponseMessage.Result result) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setResult; result = " + result.toString()), (Object[])new Object[0]);
        }
        if (result == SigResponseMessage.Result.SUCCEEDED) {
            this.messageObject.put((Object)RESULT, (Object)SUCCESS);
        } else {
            this.messageObject.put((Object)RESULT, (Object)FAILURE);
        }
    }

    @Override
    public void setServices(JSONObject services) {
        if (this.getResponseType() != SigResponseMessage.SigResponseType.SERVICE_QUERY_RESPONSE) {
            throw new IllegalStateException("Setting a service on a non service query response. response type is: " + this.getResponseType().toString());
        }
        this.services = services;
    }

    @Override
    public JSONObject getServices() {
        if (this.getResponseType() == SigResponseMessage.SigResponseType.SERVICE_QUERY_RESPONSE) {
            return (JSONObject)this.messageObject.get((Object)SERVICES);
        }
        throw new IllegalStateException("Getting services on a non service query response. response type is: " + this.getResponseType().toString());
    }

    @Override
    public void send() {
        if (this.services != null) {
            this.messageObject.put((Object)SERVICES, (Object)this.services);
        }
        super.send();
    }

    @Override
    protected String convertMethodToString(SigMessage.SigMethod method) {
        if (method != SigMessage.SigMethod.RESPONSE) {
            throw new IllegalStateException("method does not match message type");
        }
        return RESPONSE;
    }

    @Override
    protected SigMessage.SigMethod convertStringToMethod(String methodString) {
        if (methodString.compareTo(RESPONSE) != 0) {
            throw new IllegalStateException("method does not match message type");
        }
        return SigMessage.SigMethod.RESPONSE;
    }
}

