/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.letsencrypt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.ParametersAreNonnullByDefault;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.provider.AbstractAcmeProvider;

@ParametersAreNonnullByDefault
public class LetsEncryptAcmeProvider
extends AbstractAcmeProvider {
    private static final String V02_DIRECTORY_URL = "https://acme-v02.api.letsencrypt.org/directory";
    private static final String STAGING_DIRECTORY_URL = "https://acme-staging-v02.api.letsencrypt.org/directory";

    @Override
    public boolean accepts(URI serverUri) {
        return "acme".equals(serverUri.getScheme()) && "letsencrypt.org".equals(serverUri.getHost());
    }

    @Override
    public URL resolve(URI serverUri) {
        String directoryUrl;
        String path = serverUri.getPath();
        if (path == null || "".equals(path) || "/".equals(path) || "/v02".equals(path)) {
            directoryUrl = V02_DIRECTORY_URL;
        } else if ("/staging".equals(path)) {
            directoryUrl = STAGING_DIRECTORY_URL;
        } else {
            throw new IllegalArgumentException("Unknown URI " + serverUri);
        }
        try {
            return new URL(directoryUrl);
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException(directoryUrl, ex);
        }
    }
}

