/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.PasswordExpiredException;
import com.ibm.ws.security.authentication.UserRevokedException;
import com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule;
import com.ibm.ws.security.context.SubjectRegistryManager;
import com.ibm.ws.security.registry.UserRegistry;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UsernameAndPasswordLoginModule
extends ServerCommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UsernameAndPasswordLoginModule.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private UserRegistry userRegistry;
    private String username = null;
    private String urAuthenticatedId = null;
    static final long serialVersionUID = -1034522143030294360L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={AuthenticationException.class, IllegalArgumentException.class, WSLoginFailedException.class})
    public boolean login() throws LoginException {
        if (this.isAlreadyProcessed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Already processed by other login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        try {
            Callback[] callbacks = this.getRequiredCallbacks(this.callbackHandler);
            String user = ((NameCallback)callbacks[0]).getName();
            char[] passwordChars = ((PasswordCallback)callbacks[1]).getPassword();
            if (user == null || passwordChars == null) {
                return false;
            }
            if (user.trim().isEmpty()) {
                return false;
            }
            this.setAlreadyProcessed();
            this.userRegistry = this.getUserRegistry();
            this.urAuthenticatedId = this.userRegistry.checkPassword(user, String.valueOf(passwordChars));
            if (this.urAuthenticatedId != null) {
                try {
                    SubjectRegistryManager.startSubjectRegistryDetectionOnZOS();
                    this.username = this.getSecurityName(user, this.urAuthenticatedId);
                    this.setUpTemporarySubject();
                }
                finally {
                    SubjectRegistryManager.clearSubjectRegistryDetectionOnZOS();
                }
                this.updateSharedState();
                return true;
            }
            Tr.audit((TraceComponent)tc, (String)"JAAS_AUTHENTICATION_FAILED_BADUSERPWD", (Object[])new Object[]{user});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"JAAS_AUTHENTICATION_FAILED_BADUSERPWD", (Object[])new Object[]{user}, (String)"CWWKS1100A: Authentication failed for the userid {0}. A bad userid and/or password was specified."));
        }
        catch (com.ibm.ws.security.registry.PasswordExpiredException callbacks) {
            void e;
            FFDCFilter.processException((Throwable)callbacks, (String)"com.ibm.ws.security.authentication.jaas.modules.UsernameAndPasswordLoginModule", (String)"98", (Object)this, (Object[])new Object[0]);
            throw new PasswordExpiredException(e.getLocalizedMessage(), (Exception)e);
        }
        catch (com.ibm.ws.security.registry.UserRevokedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.UsernameAndPasswordLoginModule", (String)"100", (Object)this, (Object[])new Object[0]);
            throw new UserRevokedException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        catch (WSLoginFailedException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (LoginException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.UsernameAndPasswordLoginModule", (String)"112", (Object)this, (Object[])new Object[0]);
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.UsernameAndPasswordLoginModule", (String)"114", (Object)this, (Object[])new Object[0]);
            throw new AuthenticationException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        callbackHandler.handle(callbacks);
        return callbacks;
    }

    private void setUpTemporarySubject() throws Exception {
        this.temporarySubject = new Subject();
        String accessId = AccessIdUtil.createAccessId((String)"user", (String)this.userRegistry.getRealm(), (String)this.userRegistry.getUniqueUserId(this.urAuthenticatedId));
        this.setWSPrincipal(this.temporarySubject, this.username, accessId, "password");
        this.setCredentials(this.temporarySubject, this.username, this.urAuthenticatedId);
        this.setOtherPrincipals(this.temporarySubject, this.username, accessId, "password", null);
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.urAuthenticatedId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.setUpSubject();
        return true;
    }

    @Override
    public boolean abort() {
        this.cleanUpSubject();
        this.urAuthenticatedId = null;
        this.username = null;
        return true;
    }

    @Override
    public boolean logout() {
        this.cleanUpSubject();
        this.urAuthenticatedId = null;
        this.username = null;
        return true;
    }
}

