/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClaimsUtils {
    public static final TraceComponent tc = Tr.register(ClaimsUtils.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static final JsonBuilderFactory builderFactory = Json.createBuilderFactory(null);
    static final long serialVersionUID = -841773229330532747L;

    @ManualTrace
    public JwtClaims getJwtClaims(String jwt) throws JoseException {
        String methodName = "getJwtClaims";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        JwtClaims jwtclaims = new JwtClaims();
        String payload = this.getJwtPayload(jwt);
        if (payload != null) {
            jwtclaims = this.getClaimsFromJwtPayload(jwt, payload);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtclaims);
        }
        return jwtclaims;
    }

    @ManualTrace
    String getJwtPayload(String jwt) {
        String[] parts;
        String methodName = "getJwtPayload";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt});
        }
        String payload = null;
        if (jwt != null && (parts = JsonUtils.splitTokenString((String)jwt)).length > 0) {
            payload = JsonUtils.fromBase64ToJsonString((String)parts[1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, payload);
        }
        return payload;
    }

    @ManualTrace
    JwtClaims getClaimsFromJwtPayload(String jwt, String payload) throws JoseException {
        String methodName = "getClaimsFromJwtPayload";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt, payload});
        }
        JwtClaims jwtclaims = this.parsePayloadAndCreateClaims(payload);
        jwtclaims.setStringClaim(Claims.raw_token.name(), jwt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Key : raw_token, Value: raw_token", (Object[])new Object[0]);
        }
        this.convertJoseTypes(jwtclaims);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtclaims);
        }
        return jwtclaims;
    }

    @ManualTrace
    JwtClaims parsePayloadAndCreateClaims(String payload) throws JoseException {
        String methodName = "parsePayloadAndCreateClaims";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{payload});
        }
        JwtClaims jwtClaims = new JwtClaims();
        Map payloadClaims = JsonUtil.parseJson((String)payload);
        Set entries = payloadClaims.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            this.addEntryToClaims(entry, jwtClaims);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jwtClaims);
        }
        return jwtClaims;
    }

    void addEntryToClaims(Map.Entry<String, Object> entry, JwtClaims jwtclaims) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key : " + key + ", Value: " + value), (Object[])new Object[0]);
        }
        if (key != null && value != null) {
            jwtclaims.setClaim(key, value);
        }
    }

    private void convertJoseTypes(JwtClaims claimsSet) {
        if (claimsSet.hasClaim("address")) {
            this.replaceMapWithJsonObject("address", claimsSet);
        }
        if (claimsSet.hasClaim("jwk")) {
            this.replaceMapWithJsonObject("jwk", claimsSet);
        }
        if (claimsSet.hasClaim("sub_jwk")) {
            this.replaceMapWithJsonObject("sub_jwk", claimsSet);
        }
        if (claimsSet.hasClaim("aud")) {
            this.convertToList("aud", claimsSet);
        }
        if (claimsSet.hasClaim("groups")) {
            this.convertToList("groups", claimsSet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void replaceMapWithJsonObject(String claimName, JwtClaims claimsSet) {
        block3: {
            try {
                Map map = (Map)claimsSet.getClaimValue(claimName, Map.class);
                JsonObjectBuilder builder = builderFactory.createObjectBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    builder.add((String)entry.getKey(), entry.getValue().toString());
                }
                JsonObject jsonObject = builder.build();
                claimsSet.setClaim(claimName, (Object)jsonObject);
            }
            catch (MalformedClaimException map) {
                void e;
                FFDCFilter.processException((Throwable)map, (String)"com.ibm.ws.security.mp.jwt.impl.utils.ClaimsUtils", (String)"170", (Object)this, (Object[])new Object[]{claimName, claimsSet});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("The value for the claim [" + claimName + "] could not be convered to a Map: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={MalformedClaimException.class})
    private void convertToList(String claimName, JwtClaims claimsSet) {
        block5: {
            ArrayList<String> list = null;
            try {
                list = claimsSet.getStringListClaimValue(claimName);
            }
            catch (MalformedClaimException e) {
                try {
                    String value = claimsSet.getStringClaimValue(claimName);
                    if (value != null) {
                        list = new ArrayList<String>();
                        list.add(value);
                        claimsSet.setClaim(claimName, list);
                    }
                }
                catch (MalformedClaimException e1) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("The value for the claim [" + claimName + "] could not be convered to a string list: " + e1.getLocalizedMessage()), (Object[])new Object[0]);
                }
            }
        }
    }
}

