/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Attribute {
    String _name;
    String _type;
    List<String> _values;

    public Attribute(String name, String type, String[] values) {
        this.init(name, type, values);
    }

    public Attribute(String name, String type, String value) {
        this.init(name, type, new String[]{value});
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public List<String> getValues() {
        return this._values;
    }

    public String[] getValuesArray() {
        return this._values.toArray(new String[this._values.size()]);
    }

    public String getValue() {
        String result = null;
        if (this._values != null && this._values.size() > 0) {
            result = this._values.get(0);
        }
        return result;
    }

    public void setValues(String[] values) {
        this._values.clear();
        this.init(this._name, this._type, values);
    }

    private void init(String name, String type, String[] values) {
        this._name = name;
        this._type = type;
        this._values = new ArrayList<String>();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this._values.add(values[i]);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{name: " + this._name);
        sb.append(" type: " + this._type);
        sb.append(" values: [");
        if (this.isSensitive(this._name)) {
            sb.append("*****");
        } else {
            ListIterator<String> li = this._values.listIterator();
            while (li.hasNext()) {
                sb.append(li.next());
                if (!li.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("]}");
        return sb.toString();
    }

    private boolean isSensitive(String name) {
        return "client_secret".equals(name);
    }
}

