/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.audit;

import com.ibm.oauth.core.api.audit.OAuthAuditEntry;
import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Logger;

public class SimpleFileOAuthAuditHandler
implements OAuthAuditHandler {
    static final String CLASS = SimpleFileOAuthAuditHandler.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    static final SimpleDateFormat DATE_FORMAT;
    static final String SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String TZ_UTC = "UTC";
    static final String DEFAULT_AUDIT_ENTRY_FORMAT = "%1$s\n%2$s";
    static final String ERROR_AUDIT_ENTRY_FORMAT = "%1$s\n%3$-20s %4$s\n%2$s";
    public static final String FILENAME = "simpleFileAuditHandler.filename";
    private boolean initialized = false;
    private PrintWriter output = null;

    @Override
    public void init(OAuthComponentConfiguration config) {
        String filename = config.getConfigPropertyValue(FILENAME);
        if (filename != null) {
            File actualFile = new File(filename);
            try {
                this.output = new PrintWriter(new BufferedWriter(new FileWriter(actualFile, true)));
                this.initialized = true;
            }
            catch (IOException e) {
                _log.warning("Cannot get writer for " + filename + ", audit handler disabled");
            }
        } else {
            _log.warning("simpleFileAuditHandler.filename config is null, audit handler disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEntry(OAuthAuditEntry entry) throws OAuthException {
        if (this.initialized) {
            String text = "";
            if (entry.getError() == null) {
                text = String.format(DEFAULT_AUDIT_ENTRY_FORMAT, DATE_FORMAT.format(entry.getTimeStamp()), entry.getAttributes());
            } else {
                OAuthException error = entry.getError();
                text = String.format(ERROR_AUDIT_ENTRY_FORMAT, DATE_FORMAT.format(entry.getTimeStamp()), entry.getAttributes(), error.getError(), error.getMessage());
            }
            PrintWriter printWriter = this.output;
            synchronized (printWriter) {
                this.output.println(text);
                this.output.flush();
            }
        }
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_FORMAT);
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getTimeZone(TZ_UTC));
        DATE_FORMAT = sdf;
    }
}

