/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20AuthorizationCodeInvalidClientException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20AuthorizationCodeInvalidClientException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _code;
    private String _clientId;

    public OAuth20AuthorizationCodeInvalidClientException(String code, String clientId) {
        super("invalid_grant", "The authorization code: " + code + " does not belong to the client attempting to use it: " + clientId, null);
        this._code = code;
        this._clientId = clientId;
    }

    public OAuth20AuthorizationCodeInvalidClientException(String msgKey, String code, String clientId) {
        super("invalid_grant", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{code, clientId}), null);
        this._code = code;
        this._clientId = clientId;
        this._msgKey = msgKey;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(this._clientId, locale, encoding));
    }

    String getCode() {
        return this._code;
    }

    String getClientId() {
        return this._clientId;
    }
}

