/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.responsetype.impl;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AccessDeniedException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20ResponseTypeHandlerCodeImpl
implements OAuth20ResponseTypeHandler {
    static final String CLASS = OAuth20ResponseTypeHandlerCodeImpl.class.getName();
    static Logger _log = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestResponseType(AttributeList attributeList, JsonArray redirectUris, boolean allowRegexpRedirects) throws OAuthException {
        String methodName = "validateRequestResponseType";
        _log.entering(CLASS, methodName, new Object[]{redirectUris});
        try {
            String redirect = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:query:param");
            if (OidcOAuth20Util.isNullEmpty(redirect) && (OidcOAuth20Util.isNullEmpty(redirectUris) || redirectUris.size() != 1 || allowRegexpRedirects)) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "redirect_uri", null);
            }
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:oauth:request");
            if (username == null || username.length() == 0) {
                throw new OAuth20AccessDeniedException("security.oauth20.error.access.denied");
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensResponseType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, String redirectUri) {
        ArrayList<OAuth20Token> result = null;
        String methodName = "buildTokensResponseType";
        _log.entering(CLASS, methodName, new Object[]{redirectUri});
        try {
            String clientId = attributeList.getAttributeValueByNameAndType("client_id", "urn:ibm:names:query:param");
            String code_challenge = attributeList.getAttributeValueByNameAndType("code_challenge", "urn:ibm:names:query:param");
            String code_challenge_method = attributeList.getAttributeValueByNameAndType("code_challenge_method", "urn:ibm:names:query:param");
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:oauth:request");
            String redirect = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:query:param");
            String[] scope = attributeList.getAttributeValuesByName("scope");
            Map<String, String[]> tokenMap = tokenFactory.buildTokenMap(clientId, username, redirect, null, scope, null, "authorization_code");
            if (code_challenge != null && code_challenge_method != null) {
                this.addPKCEAttributes(code_challenge, code_challenge_method, tokenMap);
            }
            OAuth20TokenHelper.getExternalClaims(tokenMap, attributeList);
            OAuth20Token code = tokenFactory.createAuthorizationCode(tokenMap);
            result = new ArrayList<OAuth20Token>();
            result.add(code);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }

    private void addPKCEAttributes(String code_challenge, String code_challenge_method, Map<String, String[]> tokenMap) {
        String methodName = "addPKCEAttributes";
        _log.entering(CLASS, methodName, tokenMap);
        String key = "com.ibm.wsspi.security.oidc.external.claims:code_challenge";
        tokenMap.put(key, new String[]{code_challenge});
        key = "com.ibm.wsspi.security.oidc.external.claims:code_challenge_method";
        tokenMap.put(key, new String[]{code_challenge_method});
        _log.exiting(CLASS, methodName, tokenMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseResponseType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseResponseType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String code = token.getTokenString();
                attributeList.setAttribute("code", "urn:ibm:names:oauth:response:attribute", new String[]{code});
                String codeId = token.getId();
                attributeList.setAttribute("authorization_code_id", "urn:ibm:names:oauth:response:metadata", new String[]{codeId});
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

