/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.google.gson.JsonObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcBaseClientDBModel {
    private static final TraceComponent tc = Tr.register(OidcBaseClientDBModel.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String CLASS = OidcBaseClientDBModel.class.getName();
    private String componentId;
    private String clientId;
    @Sensitive
    private String clientSecret;
    private String displayName;
    private String redirectUri;
    private int enabled;
    @Sensitive
    private JsonObject clientMetadata;
    static final long serialVersionUID = 2358598711189647097L;

    public OidcBaseClientDBModel(String componentId, String clientId, String clientSecret, String displayName, String redirectUri, int enabled, JsonObject clientMetadata) {
        this.componentId = componentId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.displayName = displayName == null || displayName.isEmpty() ? clientId : displayName;
        this.redirectUri = redirectUri;
        this.enabled = enabled;
        this.clientMetadata = clientMetadata;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (displayName == null || displayName.isEmpty()) {
            displayName = this.getClientId();
        }
        this.displayName = displayName;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    @Sensitive
    public JsonObject getClientMetadata() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Set entries = this.clientMetadata.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                if (key.equals("client_secret")) {
                    sb.append(" " + key + "=secret_removed");
                    continue;
                }
                sb.append(" " + key + "=" + entry.getValue());
            }
            sb.append("]");
            Tr.debug((TraceComponent)tc, (String)CLASS, (Object[])new Object[]{"getClientMetadata: " + sb.toString()});
        }
        return this.clientMetadata;
    }

    public void setClientMetadata(@Sensitive JsonObject clientMetadata) {
        this.clientMetadata = clientMetadata;
    }
}

