/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.token.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.oauth20.token.WSOAuth20Token;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSOAuth20TokenImpl
implements WSOAuth20Token,
Serializable {
    private static final long serialVersionUID = -6131956027925854971L;
    static final TraceComponent tc = Tr.register(WSOAuth20TokenImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private boolean isReadOnly = false;
    private HashMap<String, Object> attributes = new HashMap();
    private long expiration = 0L;
    private String principal = null;
    private boolean isvalid = true;
    private String cacheKey = null;
    private String tokenString = null;
    private String clientId = null;
    private String[] scopes = null;
    private String provider = null;

    @Override
    public String getTokenString() {
        return this.tokenString;
    }

    public void setTokenString(String token) {
        this.tokenString = token;
    }

    @Override
    public String getClientID() {
        return this.clientId;
    }

    public void setClientID(String client) {
        this.clientId = client;
    }

    @Override
    public String[] getScope() {
        return this.scopes;
    }

    public void setScope(String[] scopes) {
        this.scopes = scopes;
    }

    public void addAttribute(String key, Object value) {
        SecurityManager sm;
        if (key.startsWith("com.ibm.wsspi.security.oauth20") && (sm = System.getSecurityManager()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + WSOAuth20Token.UPDATE_OAUTH_PERM.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission(WSOAuth20Token.UPDATE_OAUTH_PERM);
        }
        if (!this.isReadOnly) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting attribute with key: " + key + ", value: " + value), (Object[])new Object[0]);
            }
            this.attributes.put(key, value);
        }
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public String getProperty(String key) {
        String value = (String)this.attributes.get(key);
        return value;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public long getExpirationTime() {
        return this.expiration;
    }

    public void setExpirationTime(long t) {
        this.expiration = t;
    }

    @Override
    public String getUser() {
        return this.principal;
    }

    public void setUser(String user) {
        this.principal = user;
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String key) {
        this.cacheKey = key;
    }

    @Override
    public boolean isValid() {
        long now = new Date().getTime();
        return this.isvalid && now > this.expiration;
    }

    public void inValidate() {
        this.isvalid = false;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Provider:").append(this.provider).append(",");
        sb.append("user:").append(this.principal).append(",");
        sb.append("client:").append(this.clientId).append(",");
        sb.append("expiration:").append(new Date(this.expiration)).append(",");
        sb.append("token:").append(this.tokenString).append(",");
        if (this.scopes != null) {
            sb.append("scopes:");
            int size = this.scopes.length;
            for (int i = 0; i < size; ++i) {
                sb.append(this.scopes[i]).append(",");
            }
        }
        return sb.toString();
    }
}

