/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.util.RateLimiter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.web.ClientAuthnData;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.security.oauth20.web.WebUtils;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientAuthentication {
    private static TraceComponent tc = Tr.register(ClientAuthentication.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static final String PROVIDER_BUNDLE = "com.ibm.ws.security.oauth20.resources.ProviderMsgs";
    private static final ArrayList<OAuth20Request.EndpointType> endpointTypeForInvalidClientList = new ArrayList(10);
    static boolean appPasswordMisConfigEvaluated;
    static final long serialVersionUID = 8428890518344195308L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ClientAuthenticationDataException.class})
    public boolean verify(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType endpointType) throws IOException, ServletException, OidcServerException {
        boolean verified = false;
        ClientAuthnData data = null;
        try {
            data = new ClientAuthnData(request, response);
        }
        catch (OAuth20DuplicateParameterException oAuth20DuplicateParameterException) {
            void e;
            FFDCFilter.processException((Throwable)oAuth20DuplicateParameterException, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"76", (Object)this, (Object[])new Object[]{provider, request, response, endpointType});
            this.handleDuplicateParameterException((OAuth20DuplicateParameterException)e, response);
            return false;
        }
        String grantType = null;
        try {
            grantType = this.checkForRepeatedOrEmptyParameter(request, "grant_type");
        }
        catch (OAuth20DuplicateParameterException oAuth20DuplicateParameterException) {
            void e;
            FFDCFilter.processException((Throwable)oAuth20DuplicateParameterException, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"84", (Object)this, (Object[])new Object[]{provider, request, response, endpointType});
            this.handleDuplicateParameterException((OAuth20DuplicateParameterException)e, response);
            return false;
        }
        String authScheme = this.getAuthenticationScheme(request);
        try {
            verified = this.isClientAuthenticationDataValid(provider, request, response, endpointType, data, grantType, authScheme);
        }
        catch (ClientAuthenticationDataException e) {
            return false;
        }
        if (!verified) {
            this.sendErrorAndLogMessageForInvalidClient(request, response, endpointType, data, authScheme);
            return false;
        }
        request.setAttribute("authenticatedClient", (Object)data.getUserName());
        if ("password".equals(grantType) && !provider.isSkipUserValidation()) {
            verified = this.isResourceOwnerCredentialValid(provider, request, response, endpointType, data, authScheme);
        }
        return verified;
    }

    private boolean isClientAuthenticationDataValid(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType endpointType, ClientAuthnData data, String grantType, String authScheme) throws OidcServerException, ClientAuthenticationDataException {
        boolean isClientAuthenticationDataValid = false;
        if (data.hasAuthnData()) {
            isClientAuthenticationDataValid = this.isProvidedClientAuthenticationDataValid(provider, response, endpointType, data, grantType, authScheme);
        } else if (!data.isBasicAuth()) {
            String uri = request.getRequestURI();
            this.sendErrorAndLogMessage(response, 400, "invalid_request", null, MESSAGE_BUNDLE, "OAUTH_INVALID_CLIENT", "CWWKS1406E: The " + endpointType.toString() + " request had an invalid client credential. The request URI was {" + uri + "}.", new Object[]{endpointType.toString(), uri}, "security.oauth20.error.missing.parameter", new Object[]{"client_id"});
            throw new ClientAuthenticationDataException();
        }
        return isClientAuthenticationDataValid;
    }

    private boolean isProvidedClientAuthenticationDataValid(OAuth20Provider provider, HttpServletResponse response, OAuth20Request.EndpointType endpointType, ClientAuthnData data, String grantType, String authScheme) throws ClientAuthenticationDataException, OidcServerException {
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        if (clientProvider == null) {
            int statusCode = 400;
            if (authScheme != null) {
                statusCode = 401;
            }
            this.sendErrorAndLogMessage(response, statusCode, "invalid_client", authScheme, PROVIDER_BUNDLE, "security.oauth20.error.missing.client.provider", "CWOAU0070E: A client provider was not found for the OAuth provider.", new Object[0], null, null);
            throw new ClientAuthenticationDataException();
        }
        String password = data.getPassWord();
        if (password == null && !data.isBasicAuth()) {
            password = "";
        }
        boolean clientSpecifiesPublic = this.isPublicClient(clientProvider, data);
        boolean isClientAuthenticationDataValid = provider.isAllowPublicClients() || clientSpecifiesPublic ? this.isValidPublicClient(response, password, clientProvider, data, endpointType, grantType, authScheme) : clientProvider.validateClient(data.getUserName(), password);
        if (isClientAuthenticationDataValid) {
            isClientAuthenticationDataValid = clientProvider.get(data.getUserName()).isEnabled();
            if (!isClientAuthenticationDataValid && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Client " + data.getUserName() + " is not enabled so cannot be verified"), (Object[])new Object[0]);
            }
        } else {
            RateLimiter.limit();
        }
        return isClientAuthenticationDataValid;
    }

    private boolean isPublicClient(OidcOAuth20ClientProvider clientProvider, ClientAuthnData data) {
        OidcBaseClient client = null;
        try {
            client = clientProvider.get(data.getUserName());
        }
        catch (OidcServerException oidcServerException) {
            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"196", (Object)this, (Object[])new Object[]{clientProvider, data});
        }
        return client != null && client.isPublicClient();
    }

    private boolean isValidPublicClient(HttpServletResponse response, String password, OidcOAuth20ClientProvider clientProvider, ClientAuthnData data, OAuth20Request.EndpointType endpointType, String grantType, String authScheme) throws OidcServerException, ClientAuthenticationDataException {
        boolean isClientAuthenticationDataValid;
        if (password != null && password.length() > 0) {
            isClientAuthenticationDataValid = clientProvider.validateClient(data.getUserName(), password);
        } else {
            if (this.grantTypeRequiresConfidentialClient(grantType)) {
                int errorCode = 400;
                if (authScheme != null) {
                    errorCode = 401;
                }
                this.sendErrorAndLogMessage(response, errorCode, "invalid_client", authScheme, PROVIDER_BUNDLE, "security.oauth20.error.granttype.requires.confidential.client", "CWOAU0071E: A public client attempted to access the " + endpointType.toString() + " endpoint using the " + grantType + " grant type. The client_id is: " + data.getUserName(), new Object[]{endpointType.toString(), grantType, data.getUserName()}, null, null);
                throw new ClientAuthenticationDataException();
            }
            isClientAuthenticationDataValid = clientProvider.exists(data.getUserName());
        }
        return isClientAuthenticationDataValid;
    }

    private void sendErrorAndLogMessageForInvalidClient(HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType endpointType, ClientAuthnData data, String authScheme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ClientAuthentication with invalid_client. endpointType: " + (Object)((Object)endpointType)), (Object[])new Object[0]);
        }
        if (endpointTypeForInvalidClientList.contains((Object)endpointType)) {
            int errorCode = 400;
            if (authScheme != null) {
                errorCode = 401;
            }
            String uri = request.getRequestURI();
            this.sendErrorAndLogMessage(response, errorCode, "invalid_client", authScheme, MESSAGE_BUNDLE, "OAUTH_INVALID_CLIENT", "CWWKS1406E: The " + endpointType.toString() + " request had an invalid client credential. The request URI was {" + uri + "}.", new Object[]{endpointType.toString(), uri}, "security.oauth20.endpoint.client.auth.error", new Object[]{data.getUserName()});
        } else {
            WebUtils.sendErrorJSON(response, 401, "invalid_client", null, authScheme);
            Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.client.auth.error", (Object[])new Object[]{data.getUserName()});
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isResourceOwnerCredentialValid(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType endpointType, ClientAuthnData data, String authScheme) throws OidcServerException {
        boolean isCredentialValid = false;
        this.appPasswordMisConfigurationCheck(provider, data);
        try {
            isCredentialValid = provider.isPasswordGrantRequiresAppPassword() ? this.validateResourceOwnerCredentialWithAppPassword(request, response, endpointType, provider, data) : this.validateResourceOwnerCredential(provider, request, response, endpointType);
        }
        catch (OAuth20DuplicateParameterException oAuth20DuplicateParameterException) {
            void e;
            FFDCFilter.processException((Throwable)oAuth20DuplicateParameterException, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"278", (Object)this, (Object[])new Object[]{provider, request, response, endpointType, data, authScheme});
            this.handleDuplicateParameterException((OAuth20DuplicateParameterException)e, response);
            return false;
        }
        catch (OAuth20MissingParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"281", (Object)this, (Object[])new Object[]{provider, request, response, endpointType, data, authScheme});
            this.handleMissingParameterException(e, response);
            return false;
        }
        if (isCredentialValid) {
            String client;
            String user = EndpointUtils.getParameter(request, "username");
            if (EndpointUtils.reachedTokenLimit(provider, request, user, client = data.getUserName())) {
                isCredentialValid = false;
                this.createTokenLimitReachedError(request, response, client, endpointType, authScheme);
            }
        } else {
            this.sendErrorForInvalidResourceOwnerCredentials(request, response, endpointType, authScheme, provider.isPasswordGrantRequiresAppPassword());
        }
        return isCredentialValid;
    }

    void appPasswordMisConfigurationCheck(OAuth20Provider provider, ClientAuthnData data) {
        if (appPasswordMisConfigEvaluated) {
            return;
        }
        OidcBaseClient client = null;
        boolean providerWantsAppPassword = provider.isPasswordGrantRequiresAppPassword();
        boolean clientSupportsAppPassword = false;
        String clientId = data.getUserName();
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        if (clientProvider != null & clientId != null) {
            try {
                client = clientProvider.get(clientId);
            }
            catch (OidcServerException oidcServerException) {
                FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"318", (Object)this, (Object[])new Object[]{provider, data});
            }
        }
        if (client != null && client.isAppPasswordAllowed()) {
            clientSupportsAppPassword = true;
        }
        if (clientSupportsAppPassword && !providerWantsAppPassword) {
            Tr.warning((TraceComponent)tc, (String)"security.oauth20.apppassword.config.c1p0.warning", (Object[])new Object[]{client.getClientId(), provider.getID()});
        }
        if (!clientSupportsAppPassword && providerWantsAppPassword) {
            Tr.warning((TraceComponent)tc, (String)"security.oauth20.apppassword.config.c0p1.warning", (Object[])new Object[]{client.getClientId(), provider.getID()});
        }
        appPasswordMisConfigEvaluated = true;
    }

    private void createTokenLimitReachedError(HttpServletRequest request, HttpServletResponse response, String client, OAuth20Request.EndpointType endpointType, String authScheme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ClientAuthentication with too many token requests. endpointType: " + (Object)((Object)endpointType)), (Object[])new Object[0]);
        }
        if (endpointTypeForInvalidClientList.contains((Object)endpointType)) {
            int statusCode = 400;
            WebUtils.sendErrorJSON(response, statusCode, "invalid_request", null);
        }
    }

    private void sendErrorForInvalidResourceOwnerCredentials(HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType endpointType, String authScheme, boolean isAppPasswordCheck) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ClientAuthentication with invalid_resource_owner_credentials. endpointType: " + (Object)((Object)endpointType)), (Object[])new Object[0]);
        }
        if (endpointTypeForInvalidClientList.contains((Object)endpointType)) {
            String userName = request.getParameter("username");
            int errorCode = 400;
            if (authScheme != null) {
                errorCode = 401;
            }
            String message = "security.oauth20.endpoint.resowner.auth.error";
            String defaultMsg = "CWOAU0069E: The resource owner could not be verified. Either the resource owner: " + userName + " or password is incorrect.";
            if (isAppPasswordCheck) {
                message = "security.oauth20.endpoint.resowner.apppassword.error";
                defaultMsg = "CWOAU0074E: The application password exchange request for user [{0}] could not be completed because the application password could not be verified. The password is either incorrect, expired, deleted, or is supplied with the wrong client credentials.";
            }
            this.sendErrorAndLogMessage(response, errorCode, "invalid_client", authScheme, PROVIDER_BUNDLE, message, defaultMsg, new Object[]{userName}, null, null);
        } else {
            WebUtils.sendErrorJSON(response, 401, "invalid_client", null, authScheme);
        }
    }

    protected boolean grantTypeRequiresConfidentialClient(String grantType) {
        return "client_credentials".equalsIgnoreCase(grantType) || "urn:ietf:params:oauth:grant-type:jwt-bearer".equalsIgnoreCase(grantType);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean validateResourceOwnerCredential(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType type) throws OidcServerException, OAuth20DuplicateParameterException, OAuth20MissingParameterException {
        boolean valid = false;
        String userName = "";
        try {
            UserRegistry reg = this.getUserRegistry();
            userName = this.checkForRepeatedOrEmptyParameter(request, "username");
            if (userName == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "username", null);
            }
            String passWord = this.checkForRepeatedOrEmptyParameter(request, "password");
            if (passWord == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "password", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateResourceOwnerCredential for Username " + userName), (Object[])new Object[0]);
            }
            if (reg.checkPassword(userName, passWord) != null) {
                valid = true;
            }
            if (valid) {
                String userNameOverride = userName;
                if (provider.isROPCPreferUserPrincipalName()) {
                    userNameOverride = request.getUserPrincipal().getName();
                } else if (provider.isROPCPreferUserSecurityName()) {
                    userNameOverride = reg.getUserSecurityName(userName);
                }
                if (!userNameOverride.equals(userName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setting attribute to override user name to " + userNameOverride), (Object[])new Object[0]);
                    }
                    request.setAttribute("overriddenusername", (Object)userNameOverride);
                }
            }
        }
        catch (OAuth20DuplicateParameterException reg) {
            void e;
            FFDCFilter.processException((Throwable)reg, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"455", (Object)this, (Object[])new Object[]{provider, request, response, type});
            throw e;
        }
        catch (OAuth20MissingParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"457", (Object)this, (Object[])new Object[]{provider, request, response, type});
            throw e;
        }
        catch (Exception e) {
            void e1;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"459", (Object)this, (Object[])new Object[]{provider, request, response, type});
            Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.resowner.auth.error", (Object[])new Object[]{userName});
            throw new OidcServerException("invalid_resource_owner_credential", "server_error", 400, (Throwable)e1);
        }
        return valid;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean validateResourceOwnerCredentialWithAppPassword(HttpServletRequest request, HttpServletResponse response, OAuth20Request.EndpointType type, OAuth20Provider provider, ClientAuthnData clientAuthnData) throws OidcServerException, OAuth20DuplicateParameterException, OAuth20MissingParameterException {
        boolean valid = false;
        String userName = "";
        try {
            userName = this.checkForRepeatedOrEmptyParameter(request, "username");
            if (userName == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "username", null);
            }
            String appPassWord = this.checkForRepeatedOrEmptyParameter(request, "password");
            if (appPassWord == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "password", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validateResourceOwnerCredential for Username " + userName), (Object[])new Object[0]);
            }
            if (this.checkAppPassword(userName, appPassWord, provider, clientAuthnData) != null) {
                valid = true;
            }
        }
        catch (OAuth20DuplicateParameterException appPassWord) {
            void e;
            FFDCFilter.processException((Throwable)appPassWord, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"503", (Object)this, (Object[])new Object[]{request, response, type, provider, clientAuthnData});
            throw e;
        }
        catch (OAuth20MissingParameterException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"505", (Object)this, (Object[])new Object[]{request, response, type, provider, clientAuthnData});
            throw e;
        }
        catch (Exception e) {
            void e1;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthentication", (String)"507", (Object)this, (Object[])new Object[]{request, response, type, provider, clientAuthnData});
            Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.resowner.apppassword.error", (Object[])new Object[]{userName});
            throw new OidcServerException("invalid_resource_owner_credential", "server_error", 400, (Throwable)e1);
        }
        return valid;
    }

    private Object checkAppPassword(String userName, String appPassword, OAuth20Provider provider, ClientAuthnData clientAuthnData) {
        String lookupKey = appPassword;
        String encode = provider.getAccessTokenEncoding();
        lookupKey = "plain".equals(encode) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, encode);
        OAuth20Token accessToken = provider.getTokenCache().get(lookupKey);
        if (accessToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Access token was not found in the provider's token cache", (Object[])new Object[0]);
            }
            return null;
        }
        accessToken = this.assertTokenIsUsedByAllowedClient(accessToken, clientAuthnData, provider);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkAppPassword obtained access token: " + accessToken), (Object[])new Object[0]);
        }
        if (accessToken == null) {
            return null;
        }
        if (accessToken.getGrantType().equals("app_password")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkAppPassword obtained access token for an app password " + accessToken), (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAppPassword access token is not for app password, return null", (Object[])new Object[0]);
            }
            return null;
        }
        if (!accessToken.getUsername().equals(userName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("UserName from token request: " + userName + " does not match userName of app password: " + accessToken.getUsername() + ", return null"), (Object[])new Object[0]);
            }
            return null;
        }
        return accessToken;
    }

    private OAuth20Token assertTokenIsUsedByAllowedClient(OAuth20Token accessToken, ClientAuthnData clientAuthnData, OAuth20Provider provider) {
        String clientIdFromAuthnData = clientAuthnData.getUserName();
        String[] usedBy = accessToken.getUsedBy();
        if (usedBy != null) {
            List<String> usedByList = Arrays.asList(usedBy);
            if (!usedByList.contains(clientIdFromAuthnData)) {
                Tr.error((TraceComponent)tc, (String)"security.oauth20.apppassword.exchange.wrongclient", (Object[])new Object[]{usedBy[0], clientIdFromAuthnData});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Client ID [" + clientIdFromAuthnData + "] not found in used_by list of allowed clients for this token " + usedByList), (Object[])new Object[0]);
                }
                return null;
            }
        } else {
            Map<String, String[]> extensionProperties = accessToken.getExtensionProperties();
            if (extensionProperties != null) {
                extensionProperties.put("com.ibm.wsspi.security.oidc.external.claims:used_by", new String[]{clientIdFromAuthnData});
                if (!provider.isLocalStoreUsed()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("persist the token : " + accessToken.getId() + " to database after adding usedBy ext with the client : " + clientIdFromAuthnData), (Object[])new Object[0]);
                    }
                    OAuth20EnhancedTokenCache cache = provider.getTokenCache();
                    cache.removeByHash(accessToken.getId());
                    cache.addByHash(accessToken.getId(), accessToken, accessToken.getLifetimeSeconds());
                }
            }
        }
        return accessToken;
    }

    protected UserRegistry getUserRegistry() throws WSSecurityException {
        return RegistryHelper.getUserRegistry(null);
    }

    private void handleDuplicateParameterException(OAuth20DuplicateParameterException e, HttpServletResponse response) {
        WebUtils.sendErrorJSON(response, 400, "invalid_request", e.getMessage(), null);
        Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
    }

    private void handleMissingParameterException(OAuth20MissingParameterException e, HttpServletResponse response) {
        WebUtils.sendErrorJSON(response, 400, "invalid_request", e.getMessage(), null);
        Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
    }

    private void sendErrorAndLogMessage(HttpServletResponse response, int statusCode, String errorCode, String authScheme, String webMsgBundleName, String webMsgKey, String webDefaultMsg, Object[] webMsgArgs, String logMsgKey, Object[] logMsgArgs) {
        String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)webMsgBundleName, (String)webMsgKey, (Object[])webMsgArgs, (String)webDefaultMsg);
        WebUtils.sendErrorJSON(response, statusCode, errorCode, errorMsg, authScheme);
        if (logMsgKey != null) {
            Tr.error((TraceComponent)tc, (String)logMsgKey, (Object[])logMsgArgs);
        } else {
            Tr.error((TraceComponent)tc, (String)webMsgKey, (Object[])webMsgArgs);
        }
    }

    private String getAuthenticationScheme(HttpServletRequest request) {
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null) {
            String[] headerSplit;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got Authorization header: " + authzHeader), (Object[])new Object[0]);
            }
            if ((headerSplit = authzHeader.split(" ")).length > 0) {
                String authScheme = headerSplit[0].trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got authentication scheme: " + authScheme), (Object[])new Object[0]);
                }
                return authScheme;
            }
        }
        return null;
    }

    @Sensitive
    private String checkForRepeatedOrEmptyParameter(HttpServletRequest request, String parameter) throws OAuth20DuplicateParameterException {
        String[] paramArray = request.getParameterValues(parameter);
        if (paramArray != null && paramArray.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", parameter);
        }
        if (paramArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No values found for parameter: " + parameter), (Object[])new Object[0]);
            }
            return null;
        }
        String paramValue = paramArray[0];
        if (paramValue.isEmpty()) {
            return null;
        }
        return paramValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.authorize);
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.token);
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.introspect);
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.revoke);
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.app_password);
        endpointTypeForInvalidClientList.add(OAuth20Request.EndpointType.app_token);
        appPasswordMisConfigEvaluated = false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ClientAuthenticationDataException
    extends Exception {
        static final long serialVersionUID = 8136921912117992841L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ClientAuthenticationDataException() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.ClientAuthentication$ClientAuthenticationDataException", ClientAuthenticationDataException.class, (String)"OAUTH", (String)ClientAuthentication.PROVIDER_BUNDLE);
        }
    }
}

