/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.token.Payload;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AttributeToSubject {
    public static final TraceComponent tc = Tr.register(AttributeToSubject.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    public static final String JOBJ_TYPE = "jobj";
    public static final String PAYLOAD_TYPE = "payload";
    protected String realm = null;
    protected String uniqueSecurityName = null;
    protected String userName = null;
    protected String tokenString = null;
    protected String customCacheKey = null;
    protected String clientId = null;
    protected ArrayList<String> groupIds = null;
    protected ConvergedClientConfig clientConfig;
    static final long serialVersionUID = -1960751261544162843L;

    public AttributeToSubject() {
    }

    public AttributeToSubject(ConvergedClientConfig clientConfig, JSONObject jobj, String accessToken) {
        this.earlyinit(clientConfig, accessToken);
        this.initialize(clientConfig, jobj, accessToken);
    }

    public void earlyinit(ConvergedClientConfig clientConfig, String tokenStr) {
        this.tokenString = tokenStr;
        this.clientConfig = clientConfig;
        this.clientId = clientConfig.getClientId();
    }

    public void initialize(ConvergedClientConfig clientConfig, JSONObject jobj, String accessToken) {
        if (this.userName == null || this.userName.isEmpty()) {
            this.userName = this.getTheUserName(clientConfig, jobj);
        }
        if (this.userName != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user name = ", (Object[])new Object[]{this.userName});
            }
            this.customCacheKey = this.userName + this.tokenString.hashCode();
            if (!clientConfig.isMapIdentityToRegistryUser()) {
                if (this.realm == null || this.realm.isEmpty()) {
                    this.realm = this.getTheRealmName(clientConfig, jobj, null);
                }
                if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                    this.uniqueSecurityName = this.getTheUniqueSecurityName(clientConfig, jobj, null);
                }
                if (this.groupIds == null || this.groupIds.isEmpty()) {
                    block13: {
                        if (jobj.get((Object)clientConfig.getGroupIdentifier()) != null) {
                            if (jobj.get((Object)clientConfig.getGroupIdentifier()) instanceof ArrayList) {
                                this.groupIds = (ArrayList)jobj.get((Object)clientConfig.getGroupIdentifier());
                            } else {
                                try {
                                    String group = (String)jobj.get((Object)clientConfig.getGroupIdentifier());
                                    this.groupIds = new ArrayList();
                                    this.groupIds.add(group);
                                }
                                catch (ClassCastException group) {
                                    FFDCFilter.processException((Throwable)group, (String)"com.ibm.ws.security.openidconnect.clients.common.AttributeToSubject", (String)"91", (Object)this, (Object[])new Object[]{clientConfig, jobj, accessToken});
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                                    Tr.debug((TraceComponent)tc, (String)"can not get meaningful group due to CCE.", (Object[])new Object[0]);
                                }
                            }
                        }
                    }
                    if (this.groupIds != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"groups size = ", (Object[])new Object[]{this.groupIds.size()});
                    }
                }
            }
        }
    }

    public AttributeToSubject(ConvergedClientConfig clientConfig, Payload payload, String idToken) {
        this.earlyinit(clientConfig, idToken);
        this.initializep(clientConfig, payload, idToken);
    }

    public void initializep(ConvergedClientConfig clientConfig, Payload payload, String idToken) {
        String uid = null;
        if (this.userName == null || this.userName.isEmpty()) {
            String attrUsedToCreateSubject = "userIdentifier";
            uid = clientConfig.getUserIdentifier();
            if (uid != null && !uid.isEmpty()) {
                this.userName = (String)payload.get(uid);
            } else {
                attrUsedToCreateSubject = "userIdentityToCreateSubject";
                uid = clientConfig.getUserIdentityToCreateSubject();
                if (uid == null || uid.isEmpty()) {
                    uid = "sub";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The userIdentityToCreateSubject config attribute is null or empty; defaulting to " + uid), (Object[])new Object[0]);
                    }
                }
                this.userName = (String)payload.get(uid);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user name = '" + this.userName + "' and the user identifier = " + uid + " " + (this.userName == null)), (Object[])new Object[0]);
            }
            if (this.userName == null) {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_ID_TOKEN_MISSING_CLAIM", (Object[])new Object[]{this.clientId, uid, attrUsedToCreateSubject});
                return;
            }
        }
        this.customCacheKey = this.userName + this.tokenString.toString().hashCode();
        if (!clientConfig.isMapIdentityToRegistryUser()) {
            if (this.realm == null || this.realm.isEmpty()) {
                this.realm = this.getTheRealmName(clientConfig, null, payload);
            }
            if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                this.uniqueSecurityName = this.getTheUniqueSecurityName(clientConfig, null, payload);
            }
            if (this.groupIds == null || this.groupIds.isEmpty()) {
                this.groupIds = (ArrayList)payload.get(clientConfig.getGroupIdentifier());
                if (this.groupIds != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"groups size = ", (Object[])new Object[]{this.groupIds.size()});
                }
            }
        }
    }

    public boolean checkUserNameForNull() {
        if (this.userName == null || this.userName.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no principal", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public Hashtable<String, Object> handleCustomProperties() {
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        if (this.clientConfig.isIncludeCustomCacheKeyInSubject()) {
            customProperties.put("com.ibm.wsspi.security.cred.cacheKey", this.customCacheKey);
            customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        return customProperties;
    }

    public ProviderAuthenticationResult doMapping(Hashtable<String, Object> customProperties, Subject subject) {
        if (!this.clientConfig.isMapIdentityToRegistryUser()) {
            String uniqueID = new StringBuffer("user:").append(this.realm).append("/").append(this.uniqueSecurityName).toString();
            ArrayList<String> groups = new ArrayList<String>();
            if (this.groupIds != null && !this.groupIds.isEmpty()) {
                Iterator<String> it = this.groupIds.iterator();
                while (it.hasNext()) {
                    String group = new StringBuffer("group:").append(this.realm).append("/").append(it.next()).toString();
                    groups.add(group);
                }
            }
            customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
            if (this.realm != null && !this.realm.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.realm", this.realm);
            }
            if (groups != null && !groups.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.groups", groups);
            }
        }
        if (!customProperties.containsKey("com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds")) {
            long storingTime = new Date().getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find custom property for credential storage time, so recording current time = " + storingTime), (Object[])new Object[0]);
            }
            customProperties.put("com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds", storingTime);
        }
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, this.userName, subject, customProperties, null);
        return oidcResult;
    }

    public boolean checkForNullRealm() {
        if (this.realm == null || this.realm.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no realm", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected String getTheUserName(ConvergedClientConfig clientConfig, JSONObject jobj) {
        if (jobj != null) {
            String uid = clientConfig.getUserIdentifier();
            if (uid != null && !uid.isEmpty()) {
                if (jobj.get((Object)uid) != null) {
                    if (jobj.get((Object)uid) instanceof String) {
                        this.userName = (String)jobj.get((Object)uid);
                    } else {
                        Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INCORRECT_CLAIM_TYPE", (Object[])new Object[]{clientConfig.getUserIdentifier(), "userIdentifier"});
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_MISSING_USERID", (Object[])new Object[]{clientConfig.getUserIdentifier(), "userIdentifier"});
                }
            } else {
                String uidToCreateSub = clientConfig.getUserIdentityToCreateSubject();
                if (jobj.get((Object)uidToCreateSub) != null) {
                    if (jobj.get((Object)uidToCreateSub) instanceof String) {
                        this.userName = (String)jobj.get((Object)uidToCreateSub);
                    } else {
                        Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INCORRECT_CLAIM_TYPE", (Object[])new Object[]{uidToCreateSub, "userIdentityToCreateSubject"});
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_MISSING_USERID", (Object[])new Object[]{uidToCreateSub, "userIdentityToCreateSubject"});
                }
            }
            return this.userName;
        }
        return null;
    }

    protected String getTheRealmName(ConvergedClientConfig clientConfig, JSONObject jobj, Payload payload) {
        if (jobj != null) {
            String realmName = null;
            realmName = clientConfig.getRealmName();
            if (realmName != null && !realmName.isEmpty()) {
                this.realm = realmName;
            } else {
                if (jobj.get((Object)clientConfig.getRealmIdentifier()) != null && jobj.get((Object)clientConfig.getRealmIdentifier()) instanceof String) {
                    this.realm = (String)jobj.get((Object)clientConfig.getRealmIdentifier());
                }
                if (this.realm == null || this.realm.isEmpty()) {
                    this.realm = (String)jobj.get((Object)"iss");
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"realm name = ", (Object[])new Object[]{this.realm});
            }
            return this.realm;
        }
        if (payload != null) {
            String realmName = null;
            realmName = clientConfig.getRealmName();
            if (realmName != null && !realmName.isEmpty()) {
                this.realm = realmName;
            } else {
                this.realm = (String)payload.get(clientConfig.getRealmIdentifier());
                if (this.realm == null || this.realm.isEmpty()) {
                    this.realm = (String)payload.get("iss");
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"realm name = ", (Object[])new Object[]{this.realm});
            }
            return this.realm;
        }
        return null;
    }

    protected String getTheUniqueSecurityName(ConvergedClientConfig clientConfig, JSONObject jobj, Payload payload) {
        if (jobj != null) {
            if (jobj.get((Object)clientConfig.getUniqueUserIdentifier()) != null && jobj.get((Object)clientConfig.getUniqueUserIdentifier()) instanceof String) {
                this.uniqueSecurityName = (String)jobj.get((Object)clientConfig.getUniqueUserIdentifier());
            }
            if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                this.uniqueSecurityName = this.userName;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unique security name = ", (Object[])new Object[]{this.uniqueSecurityName});
            }
            return this.uniqueSecurityName;
        }
        if (payload != null) {
            this.uniqueSecurityName = (String)payload.get(clientConfig.getUniqueUserIdentifier());
            if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                this.uniqueSecurityName = this.userName;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unique security name = ", (Object[])new Object[]{this.uniqueSecurityName});
            }
            return this.uniqueSecurityName;
        }
        return null;
    }

    public AttributeToSubject(ConvergedClientConfig clientConfig, OidcTokenImplBase idToken) {
        this.clientConfig = clientConfig;
        this.clientId = clientConfig.getClientId();
        this.tokenString = idToken.getAllClaimsAsJson();
        String uid = null;
        String attrUsedToCreateSubject = "userIdentifier";
        if (this.userName == null || this.userName.isEmpty()) {
            uid = clientConfig.getUserIdentifier();
            if (uid != null && !uid.isEmpty()) {
                this.userName = (String)idToken.getClaim(uid);
            } else {
                attrUsedToCreateSubject = "userIdentityToCreateSubject";
                uid = clientConfig.getUserIdentityToCreateSubject();
                if (uid != null && !uid.isEmpty()) {
                    this.userName = (String)idToken.getClaim(uid);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The userIdentityToCreateSubject config attribute is used", (Object[])new Object[0]);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user name = '" + this.userName + "' and the user identifier = " + uid), (Object[])new Object[0]);
            }
        }
        if (this.userName == null) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_JWT_MISSING_CLAIM", (Object[])new Object[]{this.clientId, uid, attrUsedToCreateSubject});
        } else {
            this.customCacheKey = this.userName + this.tokenString.toString().hashCode();
            if (!clientConfig.isMapIdentityToRegistryUser()) {
                if (this.realm == null || this.realm.isEmpty()) {
                    this.realm = clientConfig.getRealmName();
                    if (this.realm == null) {
                        if (idToken.getClaim(clientConfig.getRealmIdentifier()) != null && idToken.getClaim(clientConfig.getRealmIdentifier()) instanceof String) {
                            this.realm = (String)idToken.getClaim(clientConfig.getRealmIdentifier());
                        }
                        if (this.realm == null || this.realm.isEmpty()) {
                            this.realm = (String)idToken.getClaim("iss");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"realm name = ", (Object[])new Object[]{this.realm});
                    }
                }
                if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                    if (idToken.getClaim(clientConfig.getUniqueUserIdentifier()) instanceof String) {
                        this.uniqueSecurityName = (String)idToken.getClaim(clientConfig.getUniqueUserIdentifier());
                    }
                    if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                        this.uniqueSecurityName = this.userName;
                    }
                }
                if (this.groupIds == null || this.groupIds.isEmpty()) {
                    Object objGroupIds = idToken.getClaim(clientConfig.getGroupIdentifier());
                    if (objGroupIds != null) {
                        if (objGroupIds instanceof ArrayList) {
                            this.groupIds = (ArrayList)objGroupIds;
                        } else {
                            if (this.groupIds == null) {
                                this.groupIds = new ArrayList();
                            }
                            this.groupIds.add((String)objGroupIds);
                        }
                    }
                    if (this.groupIds != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("objGroupIds" + objGroupIds + " groups size = "), (Object[])new Object[]{this.groupIds.size()});
                    }
                }
            }
        }
    }
}

