/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCTokenTypeHandlerFactory;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class IDTokenFactory
extends OAuth20TokenFactory {
    private static final String SHARED_KEY = "sharedKey";
    private static final String CLASS = IDTokenFactory.class.getName();
    private static Logger log = Logger.getLogger(CLASS);
    private OAuth20ComponentInternal component;
    static final long serialVersionUID = -7622225859278250645L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IDTokenFactory(OAuth20ComponentInternal component) {
        super(component);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory", "<init>", new Object[]{component});
        }
        this.component = component;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory", "<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OAuth20Token createIDToken(Map<String, String[]> tokenMap) {
        String methodName = "createIDToken";
        log.entering(CLASS, methodName);
        OAuth20Token token = null;
        boolean finestLoggable = log.isLoggable(Level.FINEST);
        try {
            int remainingLifetime;
            HashMap<String, String[]> idTokenMap = new HashMap<String, String[]>();
            idTokenMap.putAll(tokenMap);
            OAuth20Token scopes = tokenMap.get("scope");
            boolean issueIDToken = false;
            for (String scope : scopes) {
                if (!"openid".equals(scope)) continue;
                issueIDToken = true;
            }
            if (!issueIDToken) {
                OAuth20Token oAuth20Token = null;
                return oAuth20Token;
            }
            String componentId = this.component.getParentComponentInstance().getInstanceId();
            idTokenMap.put("COMPONENTID", new String[]{componentId});
            OAuth20ConfigProvider config = this.component.get20Configuration();
            int lifetime = config.getTokenLifetimeSeconds();
            if (idTokenMap.containsKey("LIFETIME") && (remainingLifetime = Integer.parseInt(OAuth20Util.getValueFromMap((String)"LIFETIME", idTokenMap))) < lifetime) {
                lifetime = remainingLifetime;
            }
            String lifeStr = Integer.toString(lifetime);
            if (finestLoggable) {
                log.logp(Level.FINEST, CLASS, methodName, "Creating id token with remaining lifetime: " + lifeStr + " seconds");
            }
            idTokenMap.put("LIFETIME", new String[]{lifeStr});
            int length = config.getAccessTokenLength();
            String lengthStr = Integer.toString(length);
            idTokenMap.put("LENGTH", new String[]{lengthStr});
            OAuth20TokenTypeHandler handler = null;
            try {
                handler = OIDCTokenTypeHandlerFactory.getIDTokenHandler(this.component);
                if (handler != null) {
                    OidcServerConfig oidcServerConfig;
                    String clientId = OAuth20Util.getValueFromMap((String)"client_id", tokenMap);
                    OidcOAuth20ClientProvider clientProvider = config.getClientProvider();
                    OidcBaseClient oidcClient = clientProvider.get(clientId);
                    if (oidcClient instanceof BaseClient) {
                        OidcBaseClient baseClient = oidcClient;
                        String sharedKey = baseClient.getClientSecret();
                        idTokenMap.put(SHARED_KEY, new String[]{sharedKey});
                    }
                    if ((token = handler.createToken(idTokenMap)) != null && (oidcServerConfig = OIDCProvidersConfig.getOidcServerConfigForOAuth20Provider(componentId)) != null && oidcServerConfig.cacheIDToken()) {
                        super.persistToken(token);
                    }
                    idTokenMap.remove(SHARED_KEY);
                }
            }
            catch (OAuthConfigurationException clientId) {
                void e;
                FFDCFilter.processException((Throwable)clientId, (String)"com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory", (String)"137", (Object)((Object)this), (Object[])new Object[]{tokenMap});
                log.throwing(CLASS, methodName, (Throwable)e);
            }
            catch (OidcServerException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory", (String)"140", (Object)((Object)this), (Object[])new Object[]{tokenMap});
                log.throwing(CLASS, methodName, e);
            }
        }
        finally {
            log.exiting(CLASS, methodName);
        }
        return token;
    }
}

