/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InternalException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerCodeImpl;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.common.cl.BuildResponseTypeUtil;
import com.ibm.ws.security.openidconnect.server.plugins.IDTokenFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class OIDCGrantTypeHandlerCodeImpl
extends OAuth20GrantTypeHandlerCodeImpl {
    private static final String CLASS = OIDCGrantTypeHandlerCodeImpl.class.getName();
    private static Logger log = Logger.getLogger(CLASS);
    static final long serialVersionUID = 504825937030359098L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OIDCGrantTypeHandlerCodeImpl() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "<init>", new Object[0]);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void validateRequestGrantType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String issuerIdentifier;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "validateRequestGrantType", new Object[]{attributeList, tokens});
        }
        super.validateRequestGrantType(attributeList, tokens);
        String[] scopes = this.getScopesFromAuthorizationCode(tokens);
        if (this.hasOpenIDScope(scopes) && ((issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier")) == null || issuerIdentifier.isEmpty())) {
            throw new OAuth20InternalException("security.oauth20.error.token.internal.missing.issuer", new Throwable("Missing issuerIdentifier"), new String[0]);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "validateRequestGrantType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String[] getScopesFromAuthorizationCode(List<OAuth20Token> tokens) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "getScopesFromAuthorizationCode", new Object[]{tokens});
        }
        String[] scopes = null;
        if (tokens.size() >= 1) {
            OAuth20Token code = tokens.get(0);
            scopes = code.getScope();
        }
        String[] stringArray = scopes;
        if (log != null && log.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "getScopesFromAuthorizationCode", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasOpenIDScope(String[] scopes) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "hasOpenIDScope", new Object[]{scopes});
        }
        boolean result = false;
        if (scopes != null) {
            for (String scope : scopes) {
                if (!"openid".equals(scope)) continue;
                result = true;
                break;
            }
        }
        boolean bl = result;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl", "hasOpenIDScope", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        ArrayList<OAuth20Token> tokenList;
        block6: {
            String methodName = "buildTokensGrantType";
            log.entering(CLASS, methodName);
            tokenList = super.buildTokensGrantType(attributeList, tokenFactory, tokens);
            try {
                OAuth20Token code;
                String requestType = attributeList.getAttributeValueByNameAndType("request_feature", "urn:ibm:names:oauth:request");
                if (!"oidc".equals(requestType) || tokens.size() < 1 || (code = tokens.get(0)) == null) break block6;
                String clientId = attributeList.getAttributeValueByName("client_id");
                String redirectUri = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:body:param");
                String[] scopes = code.getScope();
                String username = code.getUsername();
                String stateId = code.getStateId();
                if (scopes == null) break block6;
                for (String scope : scopes) {
                    if (!"openid".equals(scope)) continue;
                    if (tokenList == null) {
                        tokenList = new ArrayList<OAuth20Token>();
                    }
                    IDTokenFactory idTokenFactory = new IDTokenFactory(tokenFactory.getOAuth20ComponentInternal());
                    Map idTokenMap = idTokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, scopes, code, "authorization_code");
                    BuildResponseTypeUtil.putAccessTokenInMap((Map)idTokenMap, tokenList);
                    BuildResponseTypeUtil.putIssuerIdentifierInMap((Map)idTokenMap, (AttributeList)attributeList);
                    OAuth20Token id = idTokenFactory.createIDToken(idTokenMap);
                    if (id != null) {
                        tokenList.add(id);
                    }
                    break;
                }
            }
            finally {
                log.exiting(CLASS, methodName);
            }
        }
        return tokenList;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        log.entering(CLASS, methodName);
        BuildResponseTypeUtil.buildResponseGrantType((AttributeList)attributeList, tokens);
    }
}

