/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UserRegistryProxy
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(UserRegistryProxy.class, (String)"UserRegistry", (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages");
    private final String realm;
    private final List<UserRegistry> delegates;
    static final long serialVersionUID = -1915171785296525319L;

    UserRegistryProxy(String realm, List<UserRegistry> delegates) {
        this.realm = realm;
        this.delegates = delegates;
        if (delegates.size() <= 1) {
            throw new IllegalArgumentException("Using the UserRegistryProxy on a set of 1 or less delegates is pointless and/or meaningless");
        }
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String checkPassword(String userSecurityName, @Sensitive String password) throws RegistryException {
        for (UserRegistry registry : this.delegates) {
            String ret = registry.checkPassword(userSecurityName, password);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.mapCertificate(chain);
            }
            catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
                void cmnse;
                FFDCFilter.processException((Throwable)certificateMapNotSupportedException, (String)"com.ibm.ws.security.registry.internal.UserRegistryProxy", (String)"88", (Object)this, (Object[])new Object[]{chain});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"CertificateMapNotSupportedException caught on mapCertificate", (Object[])new Object[]{registry, chain, cmnse});
            }
            catch (CertificateMapFailedException cmnse) {
                void cmfe;
                FFDCFilter.processException((Throwable)cmnse, (String)"com.ibm.ws.security.registry.internal.UserRegistryProxy", (String)"92", (Object)this, (Object[])new Object[]{chain});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"CertificateMapFailedException caught on mapCertificate", (Object[])new Object[]{registry, chain, cmfe});
            }
        }
        throw new CertificateMapFailedException("Unable to map certificate: " + chain);
    }

    @Override
    public boolean isValidUser(String userSecurityName) throws RegistryException {
        for (UserRegistry registry : this.delegates) {
            if (!registry.isValidUser(userSecurityName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SearchResult getUsers(String pattern, int limit) throws RegistryException {
        SearchResult ret = new SearchResult();
        for (UserRegistry registry : this.delegates) {
            SearchResult result = registry.getUsers(pattern, limit);
            ret = this.mergeSearchResults(ret, result);
        }
        return ret;
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUserDisplayName(String userSecurityName) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getUserDisplayName(userSecurityName);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUserDisplayName", (Object[])new Object[]{registry, userSecurityName, enf});
            }
        }
        throw new EntryNotFoundException(userSecurityName + " does not exist");
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUniqueUserId(String userSecurityName) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getUniqueUserId(userSecurityName);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUniqueUserId", (Object[])new Object[]{registry, userSecurityName, enf});
            }
        }
        throw new EntryNotFoundException(userSecurityName + " does not exist");
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getUserSecurityName(uniqueUserId);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUserSecurityName", (Object[])new Object[]{registry, uniqueUserId, enf});
            }
        }
        throw new EntryNotFoundException(uniqueUserId + " does not exist");
    }

    @Override
    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException, RegistryException {
        Iterator<UserRegistry> iterator = this.delegates.iterator();
        if (iterator.hasNext()) {
            block7: {
                UserRegistry registry = iterator.next();
                try {
                    return registry.getUsersForGroup(groupSecurityName, limit);
                }
                catch (NotImplementedException notImplementedException) {
                    FFDCFilter.processException((Throwable)notImplementedException, (String)"com.ibm.ws.security.registry.internal.UserRegistryProxy", (String)"186", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"NotImplementedException caught on getUsersForGroup", (Object[])new Object[]{registry, groupSecurityName, limit});
                    }
                    throw new NotImplementedException("getUsersForGroup not implemented");
                }
                catch (EntryNotFoundException nie) {
                    FFDCFilter.processException((Throwable)nie, (String)"com.ibm.ws.security.registry.internal.UserRegistryProxy", (String)"192", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUsersForGroup", (Object[])new Object[]{registry, groupSecurityName, limit});
                    }
                }
                catch (CustomRegistryException enf) {
                    FFDCFilter.processException((Throwable)enf, (String)"com.ibm.ws.security.registry.internal.UserRegistryProxy", (String)"198", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"CustomRegistryException caught on getUsersForGroup", (Object[])new Object[]{registry, groupSecurityName, limit});
                }
            }
            throw new EntryNotFoundException(groupSecurityName + " does not exist.");
        }
        return null;
    }

    @Override
    public boolean isValidGroup(String groupSecurityName) throws RegistryException {
        for (UserRegistry registry : this.delegates) {
            if (!registry.isValidGroup(groupSecurityName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SearchResult getGroups(String pattern, int limit) throws RegistryException {
        SearchResult ret = new SearchResult();
        for (UserRegistry registry : this.delegates) {
            SearchResult result = registry.getGroups(pattern, limit);
            ret = this.mergeSearchResults(ret, result);
        }
        return ret;
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getGroupDisplayName(groupSecurityName);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getGroupDisplayName", (Object[])new Object[]{registry, groupSecurityName, enf});
            }
        }
        throw new EntryNotFoundException(groupSecurityName + " does not exist");
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getUniqueGroupId(groupSecurityName);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUniqueGroupId", (Object[])new Object[]{registry, groupSecurityName, enf});
            }
        }
        throw new EntryNotFoundException(groupSecurityName + " does not exist");
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, RegistryException {
        for (UserRegistry registry : this.delegates) {
            try {
                return registry.getGroupSecurityName(uniqueGroupId);
            }
            catch (EntryNotFoundException enf) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getGroupSecurityName", (Object[])new Object[]{registry, uniqueGroupId, enf});
            }
        }
        throw new EntryNotFoundException(uniqueGroupId + " does not exist");
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public List<String> getUniqueGroupIdsForUser(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        int attempts = 0;
        int exceptions = 0;
        ArrayList<String> ret = new ArrayList<String>();
        for (UserRegistry registry : this.delegates) {
            ++attempts;
            try {
                List<String> result = registry.getUniqueGroupIdsForUser(uniqueUserId);
                ret.addAll(result);
            }
            catch (EntryNotFoundException enf) {
                ++exceptions;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getUniqueGroupIdsForUser", (Object[])new Object[]{registry, uniqueUserId, enf});
            }
        }
        if (attempts == exceptions) {
            throw new EntryNotFoundException(uniqueUserId + " does not exist");
        }
        return ret;
    }

    @Override
    @FFDCIgnore(value={EntryNotFoundException.class})
    public List<String> getGroupsForUser(String userSecurityName) throws EntryNotFoundException, RegistryException {
        int attempts = 0;
        int exceptions = 0;
        ArrayList<String> ret = new ArrayList<String>();
        for (UserRegistry registry : this.delegates) {
            ++attempts;
            try {
                List<String> result = registry.getGroupsForUser(userSecurityName);
                ret.addAll(result);
            }
            catch (EntryNotFoundException enf) {
                ++exceptions;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException caught on getGroupsForUser", (Object[])new Object[]{registry, userSecurityName, enf});
            }
        }
        if (attempts == exceptions) {
            throw new EntryNotFoundException(userSecurityName + " does not exist");
        }
        return ret;
    }

    private SearchResult mergeSearchResults(SearchResult inDest, SearchResult source) {
        List<String> list = inDest.getList();
        list.addAll(source.getList());
        boolean hasMore = inDest.hasMore() || source.hasMore();
        return new SearchResult(list, hasMore);
    }

    @Override
    public String getType() {
        return "UNKNOWN";
    }
}

