/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RequestUtil {
    private static final TraceComponent tc = Tr.register(RequestUtil.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String KEY_SOCIAL_LOGIN_CONFIG = "socialLoginConfig";
    static ConcurrentServiceReferenceMap<String, SocialLoginConfig> socialLoginConfigRef = new ConcurrentServiceReferenceMap("socialLoginConfig");
    static final long serialVersionUID = -3723239709417511896L;

    public static void setSocialLoginConfigRef(ConcurrentServiceReferenceMap<String, SocialLoginConfig> socialLoginConfigRef) {
        RequestUtil.socialLoginConfigRef = socialLoginConfigRef;
    }

    public static SocialLoginConfig getSocialLoginConfig(String key) {
        return (SocialLoginConfig)socialLoginConfigRef.getService((Object)key);
    }

    public static String getCtxRootUrl(HttpServletRequest req, String samlCtxPath) {
        String hostName = req.getServerName();
        Integer httpsPort = RequestUtil.getRedirectPortFromRequest(req);
        if (httpsPort == null && req.isSecure()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The redirect SSL port is null from request. Trying to get http port", (Object[])new Object[0]);
            }
            int port = req.getServerPort();
            String httpSchema = req.getScheme();
            return httpSchema + "://" + hostName + (port > 0 && port != 443 ? ":" + port : "") + samlCtxPath;
        }
        return "https://" + hostName + (httpsPort == null ? "" : ":" + httpsPort) + samlCtxPath;
    }

    protected static Integer getRedirectPortFromRequest(HttpServletRequest req) {
        HttpServletRequest sr = RequestUtil.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return (Integer)((IPrivateRequestAttributes)sr).getPrivateAttribute("SecurityRedirectPort");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRedirectUrl called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    static HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }
}

