/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialConfigUtils {
    public static final TraceComponent tc = Tr.register(SocialConfigUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = 2204284113533776492L;

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory getSSLSocketFactory(String uniqueId, SSLContext classSslContext, AtomicServiceReference<SocialLoginService> socialLoginServiceRef, String sslRef) throws SocialLoginException {
        SSLSocketFactory sslSocketFactory = null;
        if (classSslContext == null) {
            SocialLoginService service = (SocialLoginService)socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            SSLSupport sslSupport = service.getSslSupport();
            if (sslSupport == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL support could not be found for social login service", (Object[])new Object[0]);
                }
                return null;
            }
            try {
                sslSocketFactory = sslSupport.getSSLSocketFactory(sslRef);
                JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslSocketFactory (" + sslRef + ") get: " + sslSocketFactory), (Object[])new Object[0]);
                }
            }
            catch (Exception jsseHelper) {
                void e;
                FFDCFilter.processException((Throwable)jsseHelper, (String)"com.ibm.ws.security.social.internal.utils.SocialConfigUtils", (String)"52", (Object)this, (Object[])new Object[]{uniqueId, classSslContext, socialLoginServiceRef, sslRef});
                throw new SocialLoginException("FAILED_TO_GET_SSL_CONTEXT", (Exception)e, new Object[]{uniqueId, e.getLocalizedMessage()});
            }
        }
        return sslSocketFactory;
    }
}

